﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_CorrectHomework : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { }
                if (id != 0)
                {
                    this.LoadHomeworkInfo(id);
                    this.InitButtonText();
                }
                else
                {
                    Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    
    protected void LoadHomeworkInfo(int id)
    {
        try
        {
            string sql = string.Format("select sw.id,st.truename,sw.createTime submitTime,hh.Createtime postTime,hh.endtime,hh.Content HWContent,sw.Content subContent,sw.state,sw.fileurl,sw.comment,sw.userid,hst.[Name] subjectName,hh.id HId from hs_submitwork sw,hs_homework hh,hs_student st,hs_subject hst where st.id=sw.userid and sw.homeworkid=hh.id and sw.id={0} and hst.id=hh.subjectid", id);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.hidHomeworkId.Value = dt.Rows[0]["HId"].ToString();

                this.ltCurStu.Text = dt.Rows[0]["trueName"].ToString();
                this.ltEndTime.Text = "<font color=\"red\">"+DateTime.Parse(dt.Rows[0]["endtime"].ToString()).ToString("yyyy年MM月dd日") + this.ConvertDayOfWeek(DateTime.Parse(dt.Rows[0]["endtime"].ToString()).DayOfWeek.ToString())+"</font>";
                this.ltFile.Text = string.IsNullOrEmpty(dt.Rows[0]["fileurl"].ToString()) == true ? "<font color=\"red\">无附件</font>" : dt.Rows[0]["fileurl"].ToString();
                this.ltHWContent.Text = dt.Rows[0]["HWContent"].ToString();
                this.ltHWSubject.Text = dt.Rows[0]["subjectName"].ToString();
                this.ltPostTime.Text = "<font color=\"red\">" + DateTime.Parse(dt.Rows[0]["posttime"].ToString()).ToString("yyyy年MM月dd日") + this.ConvertDayOfWeek(DateTime.Parse(dt.Rows[0]["posttime"].ToString()).DayOfWeek.ToString()) + "</font>";
                this.ltSubmitTime.Text = "<font color=\"red\">" + DateTime.Parse(dt.Rows[0]["submittime"].ToString()).ToString("yyyy年MM月dd日") + this.ConvertDayOfWeek(DateTime.Parse(dt.Rows[0]["submittime"].ToString()).DayOfWeek.ToString()) + "</font>";

                this.txtHWContent.Text = dt.Rows[0]["subContent"].ToString();
                this.txtComment.Text = dt.Rows[0]["comment"].ToString();
            }
        }
        catch { }
    }

    protected void InitButtonText()
    {
        try
        {
            string sql = string.Format("select top 1 sw.id from hs_submitwork sw,hs_student st where st.id=sw.userid and sw.homeworkid={0} and sw.state=1 and sw.Id!={1}",this.hidHomeworkId.Value,Request.QueryString["id"]);

            object obj = WinStar.DBUtility.DbHelperSQL.GetSingle(sql);
            if (obj != null && obj != "")
            {
                this.btnSubmit.Text = "提交并批改下一篇";
                this.hidNextSbId.Value = obj.ToString();
            }
            else
            {
                this.btnSubmit.Text = "提交";
            }
        }
        catch { }
    }

    protected string ConvertDayOfWeek(string str)
    {
        string strD = string.Empty;
        switch (str.ToLower())
        { 
            case "sunday":
                strD = " 星期日";
                break;
            case "monday":
                strD = " 星期一";
                break;
            case "tuseday":
                strD = " 星期二";
                break;
            case "wednesday":
                strD = " 星期三";
                break;
            case "thursday":
                strD = " 星期四";
                break;
            case "friday":
                strD = " 星期五";
                break;
            case "saturday":
                strD = " 星期六";
                break;
        }
        return strD;
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.SubmitWork bll = new WinStar.BLL.SubmitWork();
                WinStar.Model.SubmitWork model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));
                model.Comment = this.txtComment.Text;
                model.State = 2;

                bll.Update(model);
                if (this.btnSubmit.Text == "提交并批改下一篇")
                {
                    Common.alert("批改提交成功！", "CorrectHomework.aspx?id=" + this.hidNextSbId.Value);
                }
                else
                {
                    Common.alert("批改提交成功！","CorrectHomeworkList.aspx?id="+this.hidHomeworkId.Value);
                }
            }
            catch { Common.alert("批改提交失败，请重试！"); }
        }
    }
}