﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_CorrectHomework : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { }
                if (id > 0)
                {
                    this.LoadHomeworkInfo(id);

                    this.LoadSubmitListInfo();
                }
                else
                {
                    Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }        
    }
    /// <summary>
    /// 加载作业提交列表
    /// </summary>
    protected void LoadSubmitListInfo()
    {
        try
        {
            string sql = string.Format("select sw.id,st.Num,st.TrueName,sw.CreateTime,sw.state from hs_submitwork sw,hs_student st where st.id=sw.userid and st.classid={0} and sw.homeworkid={1}",this.hidClassId.Value,Request.QueryString["id"]);

            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            PagedDataSource pds = new PagedDataSource();
            pds.DataSource = dt.DefaultView;

            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = this.AspNetPager1.PageSize;

            this.rptSubmitkList.DataSource = pds;
            this.rptSubmitkList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载家庭作业信息
    /// </summary>
    /// <param name="id">家庭作业id</param>
    protected void LoadHomeworkInfo(int id)
    {
        try
        {
            WinStar.Model.HomeWork model = new WinStar.BLL.HomeWork().GetModel(id);
            this.hidClassId.Value = model.ClassId.ToString();
            this.ltClassName.Text = this.GetCname(Convert.ToInt32(model.ClassId));
            this.ltContent.Text = model.Content;
            this.ltCorrectedCount.Text = "<font color=\"red\">"+this.GetHomeworkSCount(id, 2, model.ClassId)+"</font> 人";
            this.ltEndDate.Text = DateTime.Parse(model.EndTime.ToString()).ToString("yyyy年MM月dd日");
            this.ltPostDate.Text = DateTime.Parse(model.CreateTime.ToString()).ToString("yyyy年MM月dd日");
            this.ltStudentCount.Text = "<font color=\"red\">" + this.GetStudentByClassId(model.ClassId) + "</font> 人";
            this.ltSubmitCount.Text = "<font color=\"red\">" + this.GetHomeworkSCount(id, 1, model.ClassId) + "</font> 人";
        }
        catch { }
    }
    /// <summary>
    /// 获取作业提交情况或批改情况
    /// </summary>
    /// <param name="hID">作业Id</param>
    /// <param name="state">是否批改</param>
    /// <param name="classId">班级Id</param>
    /// <returns></returns>
    protected object GetHomeworkSCount(object hID, object state,object classId)
    {
        object str = "";
        try
        {
            string sql = string.Empty;
            if (state.ToString() == "2")
            {
                sql = string.Format("select count(*) from hs_submitwork s,hs_student st where st.Id=s.userid and s.homeworkid={0} and st.classid={1} and s.state={2}", hID, classId, state);
            }
            else
            {
                sql = string.Format("select count(*) from hs_submitwork s,hs_student st where st.Id=s.userid and s.homeworkid={0} and st.classid={1}", hID, classId, state);
            }

            str = WinStar.DBUtility.DbHelperSQL.GetSingle(sql);
        }
        catch { }

        return str;
    }
    /// <summary>
    /// 根据班级id获取学生人数
    /// </summary>
    /// <param name="id">班级id</param>
    /// <returns></returns>
    protected object GetStudentByClassId(object id)
    {
        object obj = "";
        try
        {
            obj = WinStar.DBUtility.DbHelperSQL.GetSingle(string.Format("select count(*) from hs_student where classid={0}",id));
        }
        catch { }
        return obj;
    }

    #region 加载班级
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        string yein = "";
        int isgrade = 0;
        WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
        int gid = Convert.ToInt32(sclass.GId);
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
        yein = grade.YearIn.ToString();
        isgrade = Convert.ToInt32(grade.TypeAge);
        return GetGradeName(yein, isgrade) + "(" + new WinStar.BLL.Class().GetModel(classID).ClassNum + ")班";
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }

    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    #endregion
    
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadSubmitListInfo();
    }
}