﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_CourseTableList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            
            if (!string.IsNullOrEmpty(Request.QueryString["ClassId"]))
            {
                ViewState["ClassId"] = Request.QueryString["ClassId"];
            }
            else
            {
                ViewState["ClassId"] = "0";
            }
            LoadClass();
            LoadCourseList();
        }
    }

    /// <summary>
    /// 加载拥有的班级
    /// </summary>
    protected void LoadClass()
    {
        try
        {
            string str = "<ul class=\"SubjectTab\">";
            string sql = "Select distinct classid from HS_TeacherSubject Where TeacherId=" + Request.Cookies["TeacherMaster"]["TeacherId"].ToString();
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
              
                if (ViewState["ClassId"].ToString() == "0")
                {
                    ViewState["ClassId"] = dt.Rows[0][0];
                }
                //已经有班级就默认加载我的班级
                foreach (DataRow dr in dt.Rows)
                {
                    string CName = GetCname(int.Parse(dr[0].ToString()));
                    if (CName != "<font color=red>已经毕业</font>" && CName != "<font color=red>还没开学</font>")
                    {
                        if (ViewState["ClassId"].ToString() == dr[0].ToString())
                        {
                            str += "<li class=\"selected\"><a href='CourseTableList.aspx?ClassId=" + dr[0].ToString() + "'>" + CName + "(" + new WinStar.BLL.Class().GetModel(int.Parse(dr[0].ToString())).ClassNum + ")班</a></li>";
                        }
                        else
                        {
                            str += "<li><a href='CourseTableList.aspx?ClassId=" + dr[0].ToString() + "'>" + CName + "(" + new WinStar.BLL.Class().GetModel(int.Parse(dr[0].ToString())).ClassNum + ")班</a></li>";
                        }
                    }
                }
                str += "</ul>";
                this.tdSubjectList.InnerHtml = str;
            }
            else
            {
                Common.alert("你暂时没有班级，建议认领班级！", "ClassList.aspx");
            }
        }
        catch { }
    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        try
        {
            string yein = "";
            int isgrade = 0;
            WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
            int gid = Convert.ToInt32(sclass.GId);
            WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
            yein = grade.YearIn.ToString();
            isgrade = Convert.ToInt32(grade.TypeAge);
            return GetGradeName(yein, isgrade);
        }
        catch { return ""; }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }

    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }
    protected void LoadCourseList()
    {
        try
        {
            DataTable c = new WinStar.BLL.CourseTable().GetList("ClassId=" + ViewState["ClassId"].ToString() + "").Tables[0];
            if (c.Rows.Count > 0)
            {
                System.Text.StringBuilder listStr = new System.Text.StringBuilder();

            
                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期一") + "'>");
                listStr.AppendLine("<li class='liXq'>星期一</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][2] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][3] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][4] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][5] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][6] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][7] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][8] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][9] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][10] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][11] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][12] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期二") + "'>");
                listStr.AppendLine("<li class='liXq'>星期二</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][13] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][14] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][15] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][16] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][17] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][18] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][19] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][20] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][21] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][22] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][23] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期三") + "'>");
                listStr.AppendLine("<li class='liXq'>星期三</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][24] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][25] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][26] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][27] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][28] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][29] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][30] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][31] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][32] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][33] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][34] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期四") + "'>");
                listStr.AppendLine("<li class='liXq'>星期四</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][35] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][36] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][37] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][38] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][39] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][40] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][41] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][42] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][43] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][44] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][45] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期五") + "'>");
                listStr.AppendLine("<li class='liXq'>星期五</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][46] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][47] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][48] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][49] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][50] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][51] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][52] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][53] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][54] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][55] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][56] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期六") + "'>");
                listStr.AppendLine("<li class='liXq'>星期六</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][57] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][58] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][59] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][60] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][61] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][62] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][63] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][64] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][65] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][66] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][67] + "</li>");
                listStr.AppendLine("</ul>");

                listStr.AppendLine("<ul class='ulTab " + this.getXq("星期日") + "'>");
                listStr.AppendLine("<li class='liXq'>星期天</li>");
                listStr.AppendLine("<li class='liSw'>上午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][68] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][69] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][70] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][71] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][72] + "</li>");
                listStr.AppendLine("<li class='liSw'>下午</li>");
                listStr.AppendLine("<li>" + c.Rows[0][73] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][74] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][75] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][76] + "</li>");
                listStr.AppendLine("<li class='liSw'>自修</li>");
                listStr.AppendLine("<li>" + c.Rows[0][77] + "</li>");
                listStr.AppendLine("<li>" + c.Rows[0][78] + "</li>");
                listStr.AppendLine("</ul>");
                this.tdCourseList.InnerHtml = listStr.ToString();
            }
            else
            {
                this.tdCourseList.InnerHtml = "<center>班主任还没有设置课程表，请过段时间来看！</center>";
            }

        }
        catch
        {

        }
    }
    protected string getXq(string Xq)
    {
        string abc = DateTime.Now.GetDateTimeFormats('D')[2].ToString().Substring(0, 3);
        if (Xq == abc)
        {
            return "isSelect";
        }
        else
        {
            return "";
        }
    }
}