﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_DiscussListRe : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && !string.IsNullOrEmpty(Request.QueryString["did"]))
            {                
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid);

                this.LoadDiscussInfo(Convert.ToInt32(Request.QueryString["did"]));
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    protected void LoadDiscussInfo(int did)
    {
        try
        {
            WinStar.Model.GroupDiscuss model = new WinStar.BLL.GroupDiscuss().GetModel(did);
            this.ltAbout.Text = model.About;
            this.txtReContent.Text = model.ReAbout;
        }
        catch { }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.GroupDiscuss bll = new WinStar.BLL.GroupDiscuss();
                WinStar.Model.GroupDiscuss model = bll.GetModel(Convert.ToInt32(Request.QueryString["did"]));
                model.ReAbout = this.txtReContent.Text;

                bll.Update(model);

                Common.alert("操作成功！","DiscussList.aspx?id="+Request.QueryString["id"]);
            }
            catch { Common.alert("操作失败，请重试"); }
        }
    }
}