﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_ExamAdd : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            subjectlist();
            classlist();
        }
    }

    protected void subjectlist()
    {
        try
        {
            this.subject.DataSource = WinStar.DBUtility.DbHelperSQL.Query(string.Format("select distinct ht.subjectId,hs.Name from hs_teachersubject ht,hs_subject hs where ht.SubjectId=hs.id and ht.teacherid={0}", Session["TeacherId"])).Tables[0];

            this.subject.DataTextField = "Name";
            this.subject.DataValueField = "subjectId";
            this.subject.DataBind();
        }
        catch { }
    }
    protected void classlist()
    {
        
        try
        {
            string sql = "select  distinct classid,HS_Class.*,HS_Grade.* ";
            sql += " from HS_TeacherSubject,HS_Class,HS_Grade   ";
            sql += " where HS_TeacherSubject.teacherid='" + Session["TeacherId"].ToString() + "' and HS_Class.id=HS_TeacherSubject.classid and HS_Grade.id=HS_Class.gid and HS_TeacherSubject.SubjectId='" + this.subject.SelectedValue + "'";
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                string by = string.Empty;
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    by = GetGradeName(dt.Rows[i]["YearIn"].ToString(), int.Parse(dt.Rows[i]["TypeAge"].ToString()));

                    if (by.Trim() != "已经毕业" && by.Trim() != "还没开学")
                    {

                        this.CheckBoxList1.Items.Add(new ListItem(by + dt.Rows[i]["ClassNum"].ToString() + "班级", dt.Rows[i]["classid"].ToString()));
                    }
                }
            }
        }
        catch{ }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=red>请先设置好学期</font> <a href=TermList.aspx>点击这里</a>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "还没开学";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "已经毕业";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "已经毕业";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + isclass.ToString() + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";
        }
    }
    protected void btn1_Click(object sender, EventArgs e)
    {
        if (this.btn1.Text == "全选")
        {
            for (int b = 0; b < CheckBoxList1.Items.Count; b++)
            {

                this.CheckBoxList1.Items[b].Selected = true;
            }
            this.btn1.Text = "取消";
        }
        else
        {
            for (int b = 0; b < CheckBoxList1.Items.Count; b++)
            {

                this.CheckBoxList1.Items[b].Selected = false;
            }
            this.btn1.Text = "全选";
        }
    }
    protected void btn2_Click(object sender, EventArgs e)
    {
        string title = this.title.Text;
        string content = this.Summary.Value;
        WinStar.BLL.ExamInfo n = new WinStar.BLL.ExamInfo();
        WinStar.Model.ExamInfo m = new WinStar.Model.ExamInfo();
        m.ExamName = title;
        m.About = content;
        m.Creatime = DateTime.Now;
        m.ExamTime = Convert.ToDateTime(this.StartTime.Text);
        m.Sid = int.Parse(this.subject.SelectedValue);
        m.Tid = int.Parse(Session["TeacherId"].ToString());
        string cid = string.Empty;
        for (int i = 0; i <= this.CheckBoxList1.Items.Count - 1; i++)
        {
            if (this.CheckBoxList1.Items[i].Selected)
            {
                cid += this.CheckBoxList1.Items[i].Value+",";
               
             
            }
        }
        if (cid != "")
        {
            m.ExamClass = cid.Trim(',');
            n.Add(m);
            Common.alert("添加成功", "Examlist.aspx");
        }
        else
        {
            Common.alert("请选择班级");
        }
    }
    protected void subject_SelectedIndexChanged(object sender, EventArgs e)
    {
        classlist();
    }
}