﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_ExamList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["Type"] != null && Request["Type"].ToString() == "Del")
            {
                if (Request["id"] != null && Request["id"].ToString() != "")
                {
                    NoticeDel(Request["id"].ToString());
                }
            }
            else
            {
                bindlist();
            }
        }
    }
    protected void bindlist()
    {
        try
        {
            WinStar.BLL.ExamInfo n = new WinStar.BLL.ExamInfo();
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = n.GetList("tid='" + Session["TeacherId"].ToString() + "' order by id desc").Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;

            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.noticeList.DataSource = pds;
            this.noticeList.DataBind();
        }
        catch { }
    }
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        bindlist();
    }
    protected void NoticeDel(string id)
    {
        WinStar.BLL.Results r = new WinStar.BLL.Results();

        WinStar.BLL.ExamInfo u = new WinStar.BLL.ExamInfo();
        bool x=WinStar.DBUtility.DbHelperSQL.Exists("select id  from Hs_Results where eid='" + id + "'");
        if (x == false)
        {
            if (u.Exists(int.Parse(id)))
            {
                u.Delete(int.Parse(id));
                Common.alert("删除成功", "ExamList.aspx");
                return;
            }
        }
        else
        {
            Common.alert("此考试已有人参加，如要删除，请先删除参加人员的考试成绩");
            return;
        }
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnRpt_Click(object sender, EventArgs e)
    {
        try
        {
            int i = 0;
            foreach (RepeaterItem Item in this.noticeList.Items)
            {
                System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)Item.FindControl("ckbIndex");

                if (chk.Checked)
                {
                    new WinStar.BLL.Notice().Delete(int.Parse(chk.Value));
                    i++;
                }
            }
            if (i > 0)
            {
                Common.alert("删除成功", "ExamList.aspx");
                return;
            }
            else
            {
                Common.alert("没有选中的记录");
                return;
            }
        }
        catch
        {
            Common.alert("删除出错，请重试");
        }
    }

    protected string sub(string sid)
    {
        string sql = "select * from HS_Subject where id='" + sid + "'";
        SqlDataReader dr = WinStar.DBUtility.DbHelperSQL.ExecuteReader(sql);
        if (dr.Read())
        {
            return dr["name"].ToString();
        }
        dr.Close();
        return "";
    }
    protected string getbj(string cid)
    {
        string bj2 = string.Empty;
        string[] sArray=cid.Split(',') ;
        string bj = string.Empty;
        string sql=string.Empty;
        foreach (string i in sArray)
        {
            bj = string.Empty;
            sql = "Select g.TypeAge,g.YearIn,c.Id,c.ClassNum,c.GId From HS_Class c,HS_Grade g Where c.GId=g.Id And c.Id='"+ i.ToString().TrimEnd(',')+"'";
            SqlDataReader dr = WinStar.DBUtility.DbHelperSQL.ExecuteReader(sql);
            if (dr.Read())
            {
                bj = GetGradeName(dr[1].ToString(), int.Parse(dr[0].ToString()));
                bj2 += bj + dr[3].ToString() + "班级,";
            }

            dr.Close();
        }
        return bj2.TrimEnd(',');
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=red>请先设置好学期</font> <a href=TermList.aspx>点击这里</a>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + isclass.ToString() + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";
        }
    }
}