﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.IO;

public partial class Teacher_FileList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                if (!string.IsNullOrEmpty(Request.QueryString["fid"])) //请求的下载操作
                {
                    try
                    {
                        WinStar.Model.GroupFile model = new WinStar.BLL.GroupFile().GetModel(Convert.ToInt32(Request.QueryString["fid"]));
                        string filePath = Server.MapPath(model.FileUrl);
                        this.File_open(filePath, model.About + Path.GetExtension(filePath));
                    }
                    catch { Common.alert("下载失败，请重试！"); }
                }
                if (!string.IsNullOrEmpty(Request.QueryString["dfid"])) //请求的是删除操作
                {
                    int fid = Convert.ToInt32(Request.QueryString["dfid"]);
                    bool isSuccess = this.DeleteFileById(fid);
                    if (!isSuccess)
                    {
                        Common.alert("删除失败，请重试！");
                    }
                }
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid); //加载小组信息

                this.LoadGroupFileList(gid); //加载小组共享文件列表
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 加载小组共享文件列表
    /// </summary>
    /// <param name="gid"></param>
    protected void LoadGroupFileList(int gid)
    {
        try
        {
            PagedDataSource pds = new PagedDataSource();
            string sql = string.Format("select gf.Id,gf.FileUrl,gf.About,gf.CreateTime,s.TrueName from hs_GroupFile gf,hs_student s where gf.UserId=s.Id and gf.GroupId={0} order by gf.Id desc", gid);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex-1;
            pds.PageSize = this.AspNetPager1.PageSize;

            this.rptFileList.DataSource = pds;
            this.rptFileList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadGroupFileList(Convert.ToInt32(Request.QueryString["id"]));
    }
    /// <summary>
    /// 转换文件标题
    /// </summary>
    /// <param name="title">文件标题</param>
    /// <param name="fileUrl">文件地址</param>
    /// <returns></returns>
    protected string GetFileName(object title,object fileUrl,object fid)
    {
        string fileInfo = string.Empty;
        try
        {
            if (File.Exists(Server.MapPath(fileUrl.ToString())))
            {
                string fileExt = Path.GetExtension(Server.MapPath(fileUrl.ToString()));
                fileExt = fileExt.Length > 1 ? fileExt.Substring(1) : "";
                if (File.Exists(Server.MapPath(string.Format("images/fileIco/{0}.gif", fileExt))))
                {
                    fileInfo += "<a href=\"FileList.aspx?id=" + Request.QueryString["id"] + "&fid=" + fid + "\"><img src=\"images/fileIco/" + fileExt + ".gif\" />&nbsp;" + title + "</a>";
                }
                else
                {
                    fileInfo += "<a href=\"FileList.aspx?id=" + Request.QueryString["id"] + "&fid=" + fid + "\"><img src=\"images/fileIco/other.gif\" />&nbsp;" + title + "</a>";
                }
            }
            else
            {
                fileInfo += title+"&nbsp;<font color=\"red\">--文件不存在或已被删除</font>";
            }
        }
        catch { }
        return fileInfo;
    }
    /// <summary>
    /// 获取文件大小
    /// </summary>
    /// <param name="fileUrl">文件地址</param>
    /// <returns></returns>
    protected string GetFileSize(object fileUrl)
    {
        string fileSize = string.Empty;

        try
        {
            if (System.IO.File.Exists(Server.MapPath(fileUrl.ToString())))
            {
                System.IO.FileInfo fs = new System.IO.FileInfo(Server.MapPath(fileUrl.ToString()));
                int fileS = Convert.ToInt32(fs.Length);

                double kbSize = fileS / 1024;
                fileSize = kbSize + "kb";
                double MSize = 0;
                double GSize = 0;
                if ((kbSize / 1024) > 1) //如果大于1M
                {
                    MSize = Math.Round((kbSize / 1024), 2);
                }
                if ((MSize / 1024) > 1) //如果大于1G
                {
                    GSize = Math.Round((MSize / 1024), 2);
                }
                if (GSize != 0)
                {
                    fileSize = GSize + "G";
                }
                if (MSize != 0)
                {
                    fileSize = MSize + "M";
                }
            }
            else
            {
                fileSize = "<font color=\"red\">未知</font>";
            }
        }
        catch { fileSize = "<font color=\"red\">未知</font>"; }

        return fileSize;
    }
    /// <summary>
    /// 下载方法
    /// </summary>
    /// <param name="filePath"></param>
    /// <param name="FileName"></param>
    protected void File_open(string filePath, string FileName)
    {
        try
        {
            //以字符流的形式下载文件 
            FileStream fs = new FileStream(filePath, FileMode.Open);
            byte[] bytes = new byte[(int)fs.Length];
            fs.Read(bytes, 0, bytes.Length);
            fs.Close();
            Response.ContentType = "application/octet-stream";
            //通知浏览器下载文件而不是打开 
            Response.AddHeader("Content-Disposition", "attachment; filename=" + HttpUtility.UrlEncode(FileName, System.Text.Encoding.UTF8));
            Response.BinaryWrite(bytes);
            Response.Flush();
            Response.End();
        }
        catch { }
    }
    /// <summary>
    /// 删除共享文件
    /// </summary>
    /// <param name="fid">共享文件Id</param>
    /// <returns></returns>
    protected bool DeleteFileById(int fid)
    {
        bool result = false;
        try
        {
            WinStar.BLL.GroupFile bll = new WinStar.BLL.GroupFile();
            WinStar.Model.GroupFile model = bll.GetModel(fid);            

            bll.Delete(fid); //删除数据库记录

            result = true;

            string filePath = Server.MapPath(model.FileUrl);
            if (File.Exists(filePath))
            {
                File.Delete(filePath); //删除实际物理文件，释放服务器空间
            }
        }
        catch { }
        return result;
    }

    protected string PrintCaoZuoMsg(object id)
    {
        string msg = string.Empty;
        try
        {
            msg = "<a href=\"FileList.aspx?id="+Request.QueryString["id"]+"&dfid="+id+"\" onclick=\"{if(confirm('您确定要删除当前共享文件吗？')){return ture;}return false;}\">删除</a>";
        }
        catch { }
        return msg;
    }    
    /// <summary>
    /// 删除所选按单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDeleteAll_Click(object sender, EventArgs e)
    {
        try
        {
            string idList = "(";
            int selectedCount = 0;
            foreach (RepeaterItem item in this.rptFileList.Items)
            {
                System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)item.FindControl("chkId");
                if (chk.Checked)
                {
                    idList += chk.Value + ",";
                    selectedCount++;
                }
            }
            idList = idList.TrimEnd(',') + ")";

            System.Text.StringBuilder sql = new System.Text.StringBuilder();
            sql.Append("delete from HS_GroupFile where");
            sql.Append(" Id in ");
            sql.Append(idList);

            System.Collections.Hashtable hashtable = new System.Collections.Hashtable();
            hashtable.Add(sql, null);

            WinStar.DBUtility.DbHelperSQL.ExecuteSqlTran(hashtable);

            Common.alert("成功删除了" + selectedCount + "个共享文件！", "FileList.aspx?id=" + Request.QueryString["id"]);
        }
        catch { Common.alert("删除失败，请重试"); }
    }
}