﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_GroupEdit : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1); }

                if (id == 0)
                    Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
                else
                    this.LoadGroupInfo(id);
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);

            this.txtGroupName.Text = model.Name;
            this.txtGroupAbout.Text = model.About;
        }
        catch { }
    }
    /// <summary>
    /// 检查兴趣小组名称验证事件
    /// </summary>
    /// <param name="source"></param>
    /// <param name="args"></param>
    protected void cvGroupName_ServerValidate(object source, ServerValidateEventArgs args)
    {
        try
        {
            WinStar.BLL.Group bll = new WinStar.BLL.Group();

            WinStar.Model.Group model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));
            if (model.Name == this.txtGroupName.Text.Trim())
            {
                args.IsValid = true;
            }
            else
            {
                string sqlWhere = string.Format(" [Name] ='{0}'", this.txtGroupName.Text.Trim());
                int count = (bll.GetModelList(sqlWhere)).Count;

                args.IsValid = count > 0 ? false : true;
            }
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.Group bll = new WinStar.BLL.Group();
                WinStar.Model.Group model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));

                model.About = this.txtGroupAbout.Text.Trim();
                model.Name = this.txtGroupName.Text.Trim();

                bll.Update(model);

                Common.alert("修改成功","GroupList.aspx");
            }
            catch { Common.alert("修改失败，请重试"); }
        }
    }
}