﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;

public partial class Teacher_GroupIndex : TeacherPageBase
{
    protected string GroupIndexInfo = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                if (!string.IsNullOrEmpty(Request.QueryString["ac"]) && !string.IsNullOrEmpty(Request.QueryString["sid"]))
                {//请求的是忽略申请的操作
                    if (!this.ChangeGroupUserState(Request.QueryString["sid"], gid, 0))
                    {
                        Common.alert("忽略申请操作失败，请重试！");
                    }
                }
                if (!string.IsNullOrEmpty(Request.QueryString["as"]) && !string.IsNullOrEmpty(Request.QueryString["sid"]))
                {//请求的是批准加入的操作
                    if (!this.ChangeGroupUserState(Request.QueryString["sid"], gid, 1))
                    {
                        Common.alert("批准申请操作失败，请重试！");
                    }
                }

                this.LoadGroupShenQing(); //加载入组申请列表

                this.LoadGroupInfo(gid); //加载小组信息

                this.LoadGroupNoticeList(gid); //加载小组通知
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.GroupIndexInfo = model.Name + " 小组首页";

            WinStar.BLL.GroupComment gcbll = new WinStar.BLL.GroupComment();
            object gcComment = WinStar.DBUtility.DbHelperSQL.GetSingle(string.Format("select top 1 [Content] from HS_GroupComment where GroupId={0} order by Id Desc", id));

            this.ltAbout.Text = model.About;
            this.ltComment.Text = gcComment == null ? "暂无评语" : gcComment.ToString();
            object GroupLeaderId = WinStar.DBUtility.DbHelperSQL.GetSingle(string.Format("select top 1 UserId from HS_GroupUser where GroupId={0} and HeadMan=1", id));
            this.ltGroupLeader.Text = GroupLeaderId == null ? "暂无" : new WinStar.BLL.Student().GetModel(Convert.ToInt32(GroupLeaderId)).TrueName;
            this.ltMemberCount.Text = WinStar.DBUtility.DbHelperSQL.GetSingle(string.Format("select count(*) from HS_GroupUser where GroupId={0} and State=1", id)) + "人";
            this.ltName.Text = model.Name;
            this.ltTeacher.Text = new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(model.TeacherId)).TrueName;

            this.ltGroupNoticeMore.Text = "[<a href=\"NoticeList.aspx?id=" + id + "\">更多通知</a>]";
        }
        catch { }
    }
    /// <summary>
    /// 加载小组通知
    /// </summary>
    /// <param name="id">小组Id</param>
    private void LoadGroupNoticeList(int id)
    {
        try
        {
            string sql = string.Format("select top 5 * from HS_GroupNotice where GroupId={0} order by Id Desc", id);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            this.rptGroupNotice.DataSource = dt.DefaultView;
            this.rptGroupNotice.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载入组申请列表
    /// </summary>
    private void LoadGroupShenQing()
    {
        try
        {
            string sql = string.Format("select g.Id,UserId,TrueName,ClassId from hs_groupUser g,hs_student s where g.UserId=s.Id and GroupId={0} and g.State=0", Request.QueryString["id"]);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            dt.Columns.Add("Num");
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                dt.Rows[i]["Num"] = i + 1;
            }

            this.ltShenQCount.Text = dt.Rows.Count + "";
            if (dt.Rows.Count > 0)
            {
                this.rptShenQ.DataSource = dt.DefaultView;
                this.rptShenQ.DataBind();
            }
            else
            {
                this.ltNoData.Text = "目前没有学生申请加入本小组！";
            }

        }
        catch { }
    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classId"></param>
    /// <returns></returns>
    protected string GetClassName(object classId)
    {
        string cName = "未知";
        try
        {
            cName = Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(classId)));
        }
        catch { }
        return cName;
    }
    /// <summary>
    /// 处理申请请求
    /// </summary>
    /// <param name="sid">学生Id</param>
    /// <param name="gid">小组Id</param>
    /// <param name="action">1代表批准申请，0代表忽略申请</param>
    /// <returns></returns>
    private bool ChangeGroupUserState(object sid, int gid, int action)
    {
        bool result = false;
        try
        {
            System.Text.StringBuilder sql = new System.Text.StringBuilder();
            SqlParameter[] param = null;
            if (action == 1) //批准申请
            {
                sql.Append("update hs_groupUser set state=1");
                sql.Append(" where GroupId=@groupId");
                sql.Append(" and UserId=@userId");
            }
            else //忽略申请
            {
                sql.Append("delete from hs_groupUser");
                sql.Append(" where GroupId=@groupId");
                sql.Append(" and UserId=@userId");
            }
            param = new SqlParameter[] { 
                    new SqlParameter("@groupId",gid),
                    new SqlParameter("@userId",sid)
                };

            int effectCount = WinStar.DBUtility.DbHelperSQL.ExecuteSql(sql.ToString(), param);
            if (effectCount > 0)
                result = true;                
        }
        catch { }

        return result;
    }
}