﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.Data.SqlClient;

public partial class Teacher_GroupList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"])) //请求的是删除操作
            {
                try
                {
                    bool isSuccess = this.DeleteGroupById(Convert.ToInt32(Request.QueryString["id"])); //执行删除操作
                    if (!isSuccess)
                    {
                        Common.alert("删除失败，请重试", "Default.aspx");
                    }
                }
                catch { Common.alert("删除失败，请重试", "Default.aspx"); }
            }            
            this.LoadGroupList(); //加载小组列表
        }
    }
    /// <summary>
    /// 通过小组Id删除小组信息
    /// </summary>
    /// <param name="id"></param>
    protected bool DeleteGroupById(int id)
    {
        bool result = false;
        try
        {
            System.Collections.Hashtable tableSql = new System.Collections.Hashtable();

            StringBuilder sqlComment = new StringBuilder(); //删除小组下的评语
            sqlComment.Append("delete from hs_groupComment");
            sqlComment.Append(" where GroupId=@gid");

            StringBuilder sqlDiscuss = new StringBuilder(); //删除小组下的交流信息
            sqlDiscuss.Append("delete from hs_groupDiscuss");
            sqlDiscuss.Append(" where GroupId=@gid");

            StringBuilder sqlFile = new StringBuilder(); //删除小组下的共享文件
            sqlFile.Append("delete from hs_groupFile");
            sqlFile.Append(" where GroupId=@gid");

            StringBuilder sqlNote = new StringBuilder(); //删除小组下的学习笔记
            sqlNote.Append("delete from hs_groupNote");
            sqlNote.Append(" where GroupId=@gid");

            StringBuilder sqlNotice = new StringBuilder(); //删除小组下通知
            sqlNotice.Append("delete from hs_groupNotice");
            sqlNotice.Append(" where GroupId=@gid");

            StringBuilder sqlPic = new StringBuilder(); //删除小组下的图片
            sqlPic.Append("delete from hs_groupPic");
            sqlPic.Append(" where GroupId=@gid");

            StringBuilder sqlUser = new StringBuilder(); //删除小组下学生
            sqlUser.Append("delete from hs_groupUser");
            sqlUser.Append(" where GroupId=@gid");

            StringBuilder sqlGroup = new StringBuilder(); //最后执行删除小组
            sqlGroup.Append("delete from hs_group");
            sqlGroup.Append(" where Id=@gid");


            SqlParameter[] param = new SqlParameter[] { 
                new SqlParameter("@gid",id)
            };

            tableSql.Add(sqlComment, param);
            tableSql.Add(sqlDiscuss, param);
            tableSql.Add(sqlFile, param);
            tableSql.Add(sqlNote, param);
            tableSql.Add(sqlNotice, param);
            tableSql.Add(sqlPic, param);
            tableSql.Add(sqlUser, param);
            tableSql.Add(sqlGroup, param);

            WinStar.DBUtility.DbHelperSQL.ExecuteSqlTran(tableSql);

            result = true;
        }
        catch { }
        return result;
    }
    /// <summary>
    /// 加载兴趣小组列表
    /// </summary>
    protected void LoadGroupList()
    {
        try
        {
            WinStar.BLL.Group bll = new WinStar.BLL.Group();

            PagedDataSource pds = new PagedDataSource();
            DataTable dt = bll.GetList(string.Format(" TeacherId={0}",Convert.ToInt32(Session["TeacherId"]))).Tables[0];

            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.rptGroupList.DataSource = pds;
            this.rptGroupList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 添加兴趣小组按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        Response.Redirect("GroupAdd.aspx");
    }
    /// <summary>
    /// 通过教师Id获取教师姓名
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    protected string GetTeacherName(object id)
    {
        string teacherName = string.Empty;

        try
        {
            teacherName = new WinStar.BLL.Teacher().GetModelList(string.Format(" Id={0}",Convert.ToInt32(id)))[0].TrueName;
        }
        catch { teacherName = "未知"; }

        return teacherName;
    }
    /// <summary>
    /// 通过小组Id获取小组成员数量
    /// </summary>
    /// <param name="groupId"></param>
    /// <returns></returns>
    protected string GetGroupMemberCount(object groupId)
    {
        string memberCount = string.Empty;

        try
        {
            string sql = string.Format("select count(*) from HS_GroupUser where GroupId={0} and State=1",Convert.ToInt32(groupId));
            memberCount = "<font color=\"red\">"+WinStar.DBUtility.DbHelperSQL.GetSingle(sql)+"</font> 人";
        }
        catch { memberCount = "<font color=\"green\">人数不明确</font>"; }

        return memberCount;
    }
    /// <summary>
    /// 分页控件，也索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadGroupList();
    }
}