﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.Data.SqlClient;

public partial class Teacher_GroupUser : TeacherPageBase
{
    protected string GroupIndexInfo = string.Empty;
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["gid"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["gid"]);

                if (!string.IsNullOrEmpty(Request.QueryString["ac"]) && !string.IsNullOrEmpty(Request.QueryString["sid"]))
                {//请求的是撤销组长职务的操作
                    if (!this.CancelGroupLeader(Request.QueryString["sid"], gid))
                    {
                        Common.alert("组长职务撤销失败，请重试！");
                    }
                }
                if (!string.IsNullOrEmpty(Request.QueryString["as"]) && !string.IsNullOrEmpty(Request.QueryString["sid"]))
                {//请求的是设为组长职务的操作
                    if (!this.SetGroupLeader(Request.QueryString["sid"], gid))
                    {
                        Common.alert("设为组长失败，请重试！");
                    }
                }
                if (!string.IsNullOrEmpty(Request.QueryString["ad"]) && !string.IsNullOrEmpty(Request.QueryString["sid"]))
                {//请求的是删除成员的操作
                    if (!this.DelGroupMember(Request.QueryString["sid"], gid))
                    {
                        Common.alert("移除成员失败，请重试！");
                    }
                }
                
                this.LoadGroupInfo(gid);

                this.LoadGroupUserList(gid);
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    private bool DelGroupMember(object sid, int gid)
    {
        bool result = false;
        try
        {
            StringBuilder sql = new StringBuilder();
            sql.Append("delete from hs_groupUser");
            sql.Append(" where GroupId=@gid");
            sql.Append(" and UserId=@uid");

            SqlParameter[] param = new SqlParameter[] { 
                new SqlParameter("@gid",gid),
                new SqlParameter("@uid",sid)
            };

            System.Collections.Hashtable tableSql = new System.Collections.Hashtable();
            tableSql.Add(sql, param);

            WinStar.DBUtility.DbHelperSQL.ExecuteSqlTran(tableSql);

            result = true;
        }
        catch { }
        return result;
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.GroupIndexInfo = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a> >>";
        }
        catch { }
    }
    /// <summary>
    /// 加载小组成员列表
    /// </summary>
    /// <param name="gid"></param>
    protected void LoadGroupUserList(int gid)
    {
        try
        {
            WinStar.BLL.GroupUser bll = new WinStar.BLL.GroupUser();

            PagedDataSource pds = new PagedDataSource();
            string sql = string.Format("select gu.*,gs.TrueName from hs_groupUser gu,hs_Student gs where gs.Id=gu.Userid and gu.groupId={0} and gu.State=1",gid);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            if (dt.Rows.Count > 0)
            {
                pds.DataSource = dt.DefaultView;
                this.AspNetPager1.RecordCount = pds.Count;
                pds.AllowPaging = true;
                pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
                pds.PageSize = AspNetPager1.PageSize;

                this.rptUserList.DataSource = pds;
                this.rptUserList.DataBind();
            }
            else
            {
                this.AspNetPager1.Visible = false;
                this.ltNoData.Text = "<center style=\"color:red;\">该小组目前暂无任何成员</center>";
            }
        }
        catch { }
    }
    /// <summary>
    /// 分页控件也索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadGroupUserList(Convert.ToInt32(Request.QueryString["id"]));
    }
    /// <summary>
    /// 加载学生姓名
    /// </summary>
    /// <param name="userId">学生id</param>
    /// <param name="headMan">是否为组长</param>
    /// <returns></returns>
    protected string GetStudentName(object userId,object headMan)
    {
        string str = string.Empty;
        try
        {
            WinStar.BLL.Student bll = new WinStar.BLL.Student();
            WinStar.Model.Student model=bll.GetModel(Convert.ToInt32(userId));
            str = headMan.ToString().ToLower()=="false" ? model.TrueName : model.TrueName+"&nbsp;&nbsp;<font color=\"red\">小组组长</font>";
        }
        catch { }
        return str;
    }
    /// <summary>
    /// 加载班级
    /// </summary>
    /// <param name="userId">学生id</param>
    /// <returns></returns>
    protected string GetStudentName(object userId)
    {
        string str = string.Empty;
        try
        {
            WinStar.BLL.Student bll = new WinStar.BLL.Student();
            WinStar.Model.Student model = bll.GetModel(Convert.ToInt32(userId));

            str = Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(model.ClassId)));
        }
        catch { }
        return str;
    }
    /// <summary>
    /// 撤销组长职务
    /// </summary>
    /// <param name="sid">学生Id</param>
    /// <param name="gid">学生所在小组Id</param>
    /// <returns></returns>
    private bool CancelGroupLeader(object sid,object gid)
    {
        bool result = false;
        try
        {
            StringBuilder sql = new StringBuilder();
            sql.Append("update hs_groupUser ");
            sql.Append("set HeadMan=0 ");
            sql.Append(" where groupId=@groupId");
            sql.Append(" and UserId=@userId");

            SqlParameter[] param = new SqlParameter[] { 
                new SqlParameter("@groupId",gid),
                new SqlParameter("@userId",sid)
            };

            int effectCount = WinStar.DBUtility.DbHelperSQL.ExecuteSql(sql.ToString(),param);
            if (effectCount > 0)
                result = true;
            else
                result = false;
        }
        catch { }
        return result;
    }
    /// <summary>
    /// 设为组长
    /// </summary>
    /// <param name="sid">学生Id</param>
    /// <param name="gid">学生所在小组Id</param>
    /// <returns></returns>
    private bool SetGroupLeader(object sid, object gid)
    {
        bool result = false;
        try
        {
            //--------- 重置组长 -----------
            StringBuilder sql = new StringBuilder();
            sql.Append("update hs_groupUser ");
            sql.Append("set HeadMan=0 ");
            sql.Append("where groupId=@groupId");
            sql.Append(" update hs_groupUser ");
            sql.Append("set HeadMan=1 ");
            sql.Append(" where groupId=@groupId");
            sql.Append(" and UserId=@userId");

            SqlParameter[] param = new SqlParameter[] { 
                new SqlParameter("@groupId",gid),
                new SqlParameter("@userId",sid)
            };

            System.Collections.Hashtable table = new System.Collections.Hashtable();
            table.Add(sql, param);
            
            WinStar.DBUtility.DbHelperSQL.ExecuteSqlTran(table);
            result = true;
        }
        catch { }
        return result;
    }
}