﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_HomeworkAdd : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.LoadSubjectList(); //加载学科

            this.LoadTeacherClass(); //加载班级
        }
    }
    
    protected void LoadSubjectList()
    {
        try
        {
            this.ddlSubjectList.DataSource = WinStar.DBUtility.DbHelperSQL.Query(string.Format("select distinct ht.subjectId,hs.Name from hs_teachersubject ht,hs_subject hs where ht.SubjectId=hs.id and ht.teacherid={0}",Session["TeacherId"])).Tables[0];
            this.ddlSubjectList.DataTextField = "Name";
            this.ddlSubjectList.DataValueField = "subjectId";
            this.ddlSubjectList.DataBind();
        }
        catch { }
    }

    #region 加载班级
    /// <summary>
    /// 加载班级列表
    /// </summary>
    protected void LoadTeacherClass()
    {
        try
        {
            string sql = string.Format("select distinct ClassId from hs_teachersubject where teacherid={0} and SubjectId={1}  order by ClassId", Session["TeacherId"],this.ddlSubjectList.SelectedValue);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            if (dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    int CID = Convert.ToInt32(dt.Rows[i]["ClassId"]);
                    string CName = this.GetCname(CID);
                    if (CName == "已毕业" || CName == "未开学")
                    {
                        dt.Rows[i].Delete();
                    }
                }

                this.rptClassList.DataSource = dt.DefaultView;
                this.rptClassList.DataBind();
            }
            else
            {
                //该科任老师没有执教任何班级
            }
        }
        catch { }
    }
    protected object GetClassName(object classId)
    {
        object OCname = "";
        try
        {
            int CID = Convert.ToInt32(classId);
            string CName = this.GetCname(CID);

            object classNum = new WinStar.BLL.Class().GetModel(CID).ClassNum;

            OCname = CName + "(" + classNum + ")班";
        }
        catch { }
        return OCname;
    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        string yein = "";
        int isgrade = 0;
        WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
        int gid = Convert.ToInt32(sclass.GId);
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
        yein = grade.YearIn.ToString();
        isgrade = Convert.ToInt32(grade.TypeAge);
        return GetGradeName(yein, isgrade);
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "未开学";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "已毕业";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "已毕业";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }

    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    #endregion
    /// <summary>
    /// 确认添加按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                System.Collections.Hashtable hashtable = new System.Collections.Hashtable();
                foreach (RepeaterItem item in this.rptClassList.Items)
                {
                    System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)item.FindControl("chkId");
                    if (chk.Checked)
                    {
                        System.Text.StringBuilder sql = new System.Text.StringBuilder();
                        sql.Append("insert into hs_homework ");
                        sql.Append("(ClassId,[Content],CreateTime,EndTime,SubjectId) values");
                        sql.Append("(@ClassId,@Content,@CreateTime,@EndTime,@SubjectId)");

                        System.Data.SqlClient.SqlParameter[] param = new System.Data.SqlClient.SqlParameter[] { 
                            new System.Data.SqlClient.SqlParameter("@ClassId",chk.Value),
                            new System.Data.SqlClient.SqlParameter("@Content",this.txtContent.Value),
                            new System.Data.SqlClient.SqlParameter("@CreateTime",DateTime.Now),
                            new System.Data.SqlClient.SqlParameter("@EndTime",this.txtEndDate.Text),
                            new System.Data.SqlClient.SqlParameter("@SubjectId",this.ddlSubjectList.SelectedValue)
                        };

                        hashtable.Add(sql, param);
                    }
                }

                WinStar.DBUtility.DbHelperSQL.ExecuteSqlTran(hashtable); //执行添加操作

                Common.alert("作业布置成功！", "HomeworkList.aspx");
            }
            catch { Common.alert("作业布置失败，请重试！"); }
        }
    }
    /// <summary>
    /// 学科更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ddlSubjectList_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.LoadTeacherClass();
    }
}