﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_HomeworkEdit : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { }
                if (id > 0)
                {
                    this.LoadSubjectList();
                    this.LoadHomeworkInfo(id);
                }
                else
                {
                    Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载学科列表
    /// </summary>
    protected void LoadSubjectList()
    {
        try
        {
            this.ddlSubjectList.DataSource = WinStar.DBUtility.DbHelperSQL.Query(string.Format("select distinct ht.subjectId,hs.Name from hs_teachersubject ht,hs_subject hs where ht.SubjectId=hs.id and ht.teacherid={0}", Session["TeacherId"])).Tables[0];
            this.ddlSubjectList.DataTextField = "Name";
            this.ddlSubjectList.DataValueField = "subjectId";
            this.ddlSubjectList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载家庭作业信息
    /// </summary>
    /// <param name="id">家庭作业id</param>
    protected void LoadHomeworkInfo(int id)
    {
        try
        {
            WinStar.Model.HomeWork model = new WinStar.BLL.HomeWork().GetModel(id);
            this.ltClassName.Text = this.GetCname(Convert.ToInt32(model.ClassId));
            this.txtContent.Value = model.Content;
            this.txtEndDate.Text = DateTime.Parse(model.EndTime.ToString()).ToShortDateString();
            this.ddlSubjectList.SelectedValue = model.SubjectId.ToString();
        }
        catch { }
    }
    #region 加载班级
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        string yein = "";
        int isgrade = 0;
        WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
        int gid = Convert.ToInt32(sclass.GId);
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
        yein = grade.YearIn.ToString();
        isgrade = Convert.ToInt32(grade.TypeAge);
        return GetGradeName(yein, isgrade) + "(" + new WinStar.BLL.Class().GetModel(classID).ClassNum + ")班";
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }

    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    #endregion
    /// <summary>
    /// 保存修改按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.HomeWork bll = new WinStar.BLL.HomeWork();

                WinStar.Model.HomeWork model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));
                model.Content = this.txtContent.Value;
                model.EndTime = DateTime.Parse(this.txtEndDate.Text);
                model.SubjectId = Convert.ToInt32(this.ddlSubjectList.SelectedValue);

                bll.Update(model);

                Common.alert("保存修改成功！","HomeworkList.aspx");
            }
            catch { Common.alert("保存修改失败，请重试！"); }
        }
    }
}