﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_MyInfo : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {        
        if (!IsPostBack)
        {
            this.LoadTeacherInfo();
        }
    }

    protected void LoadTeacherInfo()
    {
        try
        {
            WinStar.Model.Teacher model = new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(Session["TeacherId"]));
            
            this.ltUserName.Text = model.UserName;
            this.ltLoginTimes.Text = model.LoginTimes.ToString();
            this.txtPhone.Text = model.TelPhone;
            this.txtTrueName.Text = model.TrueName;

            this.rdobtnSex.SelectedValue = model.Sex==true ? "1" : "0";
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.Teacher bll = new WinStar.BLL.Teacher();
                WinStar.Model.Teacher model = bll.GetModel(Convert.ToInt32(Session["TeacherId"]));

                model.TrueName = this.txtTrueName.Text.Trim();
                model.TelPhone = this.txtPhone.Text.Trim();
                model.Sex = this.rdobtnSex.SelectedValue == "1" ? true : false;
                if (!string.IsNullOrEmpty(this.txtPassword.Text.Trim()))
                {
                    model.PassWord = this.txtPassword.Text.Trim();
                }

                bll.Update(model);

                Common.alert("修改成功！", "Myinfo.aspx");
            }
            catch { Common.alert("修改失败，请重试！"); }
        }
    }
}