﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_NewEdit : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {          
            if (Request["id"] != null && Request["id"].ToString() != "")
            {
                WinStar.BLL.News n = new WinStar.BLL.News();
                WinStar.Model.News mn = n.GetModel(int.Parse(Request["id"].ToString()));
                ViewState["Nid"] = Request["id"].ToString();
                this.title.Text = mn.Title;
                this.Summary.Value = mn.Content;
                this.nabout.Text = mn.About;
                if (mn.TitlePic != "")
                {
                    this.piclink.Text = "<a href=\"'" + mn.TitlePic + "'\">查看图片</a>";
                }
                this.banji.Text = getbj(mn.ClassId.ToString());
            }
        }
    }   
    protected string getbj(string cid)
    {
        string bj = string.Empty;
        string sql = "Select g.TypeAge,g.YearIn,c.Id,c.ClassNum,c.GId From HS_Class c,HS_Grade g Where c.GId=g.Id And c.Id=" + cid;
        SqlDataReader dr = WinStar.DBUtility.DbHelperSQL.ExecuteReader(sql);
        if (dr.Read())
        {
            bj = GetGradeName(dr[1].ToString(), int.Parse(dr[0].ToString()));
            return bj + dr[3].ToString() + "班级";
        }
        dr.Close();
        dr.Dispose();
        return "";
    }      
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=red>请先设置好学期</font> <a href=TermList.aspx>点击这里</a>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "还没开学";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "已经毕业";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "已经毕业";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + isclass.ToString() + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";
        }
    }
    protected void btn2_Click(object sender, EventArgs e)
    {
        string PicURL = string.Empty;
        if (!string.IsNullOrEmpty(this.FileUpload1.PostedFile.FileName))
        {
            string filename1 = FileUpload1.PostedFile.FileName;
            string ext = filename1.Substring(filename1.LastIndexOf(".")).ToLower();
            if (ext != ".gif" && ext != ".jpg" && ext != ".jpeg" && ext != ".bmp" && ext != ".png")
            {
                Response.Write("<script>alert('图片文件格式不对!支持JPG、GIF、PNG、BMP格式。');history.back(-1);</script>");
                return;
            }
            else
            {
                string filename2 = DateTime.Now.ToString("yyyyMMddhhmmss");
                string path = Server.MapPath(@"..\UploadFile\news\");
                if (!Directory.Exists(path))
                {
                    Directory.CreateDirectory(path);
                }
                string fpath = path + filename2 + ext;
                FileUpload1.SaveAs(fpath);
                PicURL = "UploadFile/news/" + filename2 + ext;
            }
        }

        if (this.nabout.Text.Length > 122)
        {
            Common.alert("摘要字符不能超过122个！");
            return;
        }
        string title = this.title.Text;
        string content = this.Summary.Value;
        WinStar.BLL.News n = new WinStar.BLL.News();
        WinStar.Model.News m = n.GetModel(int.Parse(ViewState["Nid"].ToString()));
        m.Title = title;
        m.Content = content;
        m.About = this.nabout.Text;
        m.CreateTime = DateTime.Now;
        if (PicURL != "")
        {
            m.TitlePic = PicURL;
        }
        n.Update(m);
        Common.alert("修改成功", "Newslist.aspx");
    }
}