﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_NoteList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.hGid.Value = gid.ToString();

                this.LoadGroupInfo(gid); //加载小组信息

                this.InitDateStatus(gid); //初始化日期状态

                if (!string.IsNullOrEmpty(Request.QueryString["date"])) //用户有日期请求
                {
                    Response.Write(this.LoadGroupNoteByDate(Request.QueryString["date"], gid));
                    Response.End();
                }
                else //默认加载当前日期日子
                {
                    this.tdNoteList.InnerHtml = this.LoadGroupNoteByDate(DateTime.Now.ToString("yyyy-MM-dd"), gid);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 初始化日期状态
    /// </summary>
    /// <param name="id">小组Id</param>
    protected void InitDateStatus(int id)
    {
        this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']";
        try
        {
            string sql = string.Format("select distinct convert(varchar(25),createTime,23) as NoteDate from HS_groupNote where groupId={0}", id);

            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                string dateList = ",disabledDates:[";
                foreach (DataRow dr in dt.Rows)
                {
                    dateList += "'" + dr[0] + "',";
                }
                dateList = dateList.TrimEnd(',');
                dateList += "]";

                this.ltMsg.Text += dateList;

                this.ltMsg.Text += "})</script>";
            }
            else
            {
                this.ltMsg.Text += ",disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']})</script>";
            }
        }
        catch { this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:function(dp){alert('你选择的日期是:'+dp.cal.getDateStr())},opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "'],disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']});</script>"; }
    }
    /// <summary>
    /// 根据日期加载学习笔记
    /// </summary>
    /// <param name="date">日期</param>
    /// <param name="gid">小组id</param>
    protected string LoadGroupNoteByDate(string date, int gid)
    {
        System.Text.StringBuilder listStr = new System.Text.StringBuilder();
        try
        {
            string sql = string.Format("select gn.Id,gn.GroupId,gn.UserId,gn.Title,gn.Content,gn.CreateTime,gn.Hits,gs.TrueName from hs_groupNote gn,hs_Student gs where gn.groupId={0} and gs.Id = gn.UserId and convert(varchar(25),createTime,23)='{1}'",gid,date);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        listStr.AppendLine("<table class=\"noteTable\">");
                        listStr.AppendLine("<tr class=\"header\" style=\"background-color: #0099CC; line-height: 20px;\"><th>");
                        listStr.AppendLine("<font color=\"#F7941D\">学生姓名：</font>" + dr["TrueName"] + "&nbsp;<font color=\"#F7941D\">日期：</font>" + DateTime.Parse(dr["CreateTime"].ToString()).ToString("yyyy年MM月dd日"));
                        listStr.AppendLine("</th></tr>");
                        listStr.AppendLine("<tr style=\"border-bottom: 1px solid #DEEFFA;\"><td style=\"line-height: 30px;\">");
                        listStr.AppendLine("<b>标题：</b>" + dr["Title"]);
                        listStr.AppendLine("</td></tr>");
                        listStr.AppendLine("<tr><td>");
                        listStr.AppendLine("<b>笔记内容：</b><br />");
                        listStr.AppendLine("<p class=\"noteContent\">");
                        listStr.AppendLine(dr["Content"].ToString());
                        listStr.AppendLine("</p>");
                        listStr.AppendLine("</td></tr></table>");
                    }
                }
                else
                {
                    listStr.AppendLine("<center style=\"line-height:30px;color:red;\">" + DateTime.Parse(date).ToString("yyyy年MM月dd日") + "，今天没有该组成员的学习笔记!<br />点击右侧日历可查看其它日期的学习笔记！</center>");
                }
            }
        }
        catch { }

        return listStr.ToString();
    }
}