﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_NoticeAdd : TeacherPageBase
{
    protected string GroupIndexInfo = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid);
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.GroupIndexInfo = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 添加按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.Model.GroupNotice model = new WinStar.Model.GroupNotice();
                model.Content = this.txtNoticeContent.Text.Trim();
                model.CreateTime = DateTime.Now;
                model.GroupId = Convert.ToInt32(Request.QueryString["id"]);
                model.Title = this.txtNoticeTitle.Text.Trim();

                int effectCount = new WinStar.BLL.GroupNotice().Add(model);
                if (effectCount > 0)
                {
                    Common.alert("添加成功","NoticeList.aspx?id="+Request.QueryString["id"]);
                }
                else
                {
                    Common.alert("添加失败，请重试");
                }
            }
            catch { Common.alert("添加失败，请重试"); }
        }
    }
}