﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_NoticeEdit : TeacherPageBase
{
    protected string GroupIndexInfo = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && !string.IsNullOrEmpty(Request.QueryString["gid"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["gid"]);

                this.LoadGroupInfo(gid);

                this.LoadNoticeInfo(Convert.ToInt32(Request.QueryString["id"]));
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            int gid = Convert.ToInt32(Request.QueryString["gid"]);
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(gid);
            this.GroupIndexInfo = "<a href=\"GroupIndex.aspx?id=" + gid + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 加载公共信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadNoticeInfo(int id)
    {
        try
        {
            WinStar.Model.GroupNotice model = new WinStar.BLL.GroupNotice().GetModel(id);
            this.txtNoticeTitle.Text = model.Title;
            this.txtNoticeContent.Text = model.Content;
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.GroupNotice bll = new WinStar.BLL.GroupNotice();

                WinStar.Model.GroupNotice model = bll.GetModel(Convert.ToInt32(Request.QueryString["id"]));
                model.Content = this.txtNoticeContent.Text.Trim();
                model.CreateTime = DateTime.Now;
                model.Title = this.txtNoticeTitle.Text.Trim();

                bll.Update(model);
                
                Common.alert("修改成功！", "NoticeList.aspx?id=" + Request.QueryString["gid"]);                    
            }
            catch { Common.alert("添加失败，请重试"); }
        }
    }
}