﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_NoticeList : TeacherPageBase
{
    protected string GroupIndexInfo = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                if (!string.IsNullOrEmpty(Request.QueryString["nid"])) //请求的是删除操作
                {
                    int nid = Convert.ToInt32(Request.QueryString["nid"]);
                    bool isSuccess = this.DeleteNoticeById(nid);
                    if (!isSuccess)
                    {
                        Common.alert("删除失败，请重试！");
                    }
                }
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid);

                this.LoadNoticeList();
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.GroupIndexInfo = "<a href=\"GroupIndex.aspx?id="+id+"\">"+model.Name + " 小组首页</a>";
            this.ltGroupInfo.Text = this.GroupIndexInfo;
        }
        catch { }
    }
    /// <summary>
    /// 加载小组通知
    /// </summary>
    protected void LoadNoticeList()
    {
        try
        {
            WinStar.BLL.GroupNotice bll = new WinStar.BLL.GroupNotice();

            PagedDataSource pds = new PagedDataSource();

            string sqlWhere = string.Format(" GroupId={0} order by CreateTime Desc", Convert.ToInt32(Request.QueryString["id"]));
            DataTable dt = bll.GetList(sqlWhere).Tables[0];

            pds.DataSource = dt.DefaultView;

            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = this.AspNetPager1.PageSize;

            this.rptNoticeList.DataSource = pds;
            this.rptNoticeList.DataBind();
        }
        catch { }
    }

    protected string PrintCaoZuoMsg(object Nid)
    {
        string msg = string.Empty;
        try
        {
            msg = "<a href=\"javascript:void(0);\" onclick=\"openDMWindow('NoticeInfo.aspx?id="+Nid+"',640,400)\">查看</a>&nbsp;&nbsp;<a href=\"NoticeEdit.aspx?id=" + Nid + "&gid=" + Request.QueryString["id"] + "\">编辑</a>&nbsp;&nbsp;<a href=\"javascript:void(0);\" onclick=\"{if(confirm('确定要删除该通知吗？')){location.href='NoticeList.aspx?nid=" + Nid + "&id=" + Request.QueryString["id"] + "'}}\">删除</a>";
        }
        catch { }
        return msg;
    }
    /// <summary>
    /// 添加按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        Response.Redirect("NoticeAdd.aspx?id="+Request.QueryString["id"]);
    }
    /// <summary>
    /// 分页控件也索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadNoticeList();
    }
    /// <summary>
    /// 删除所选按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDeleteAll_Click(object sender, EventArgs e)
    {
        try
        {
            string idList = "(";
            int selectedCount = 0;
            foreach (RepeaterItem item in this.rptNoticeList.Items)
            {
                System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)item.FindControl("chkId");
                if (chk.Checked)
                {
                    idList += chk.Value + ",";
                    selectedCount++;
                }
            }
            idList = idList.TrimEnd(',') + ")";

            System.Text.StringBuilder sql = new System.Text.StringBuilder();
            sql.Append("delete from HS_GroupNotice where");
            sql.Append(" Id in ");
            sql.Append(idList);
            
            System.Collections.Hashtable hashtable=new System.Collections.Hashtable();
            hashtable.Add(sql,null);

            WinStar.DBUtility.DbHelperSQL.ExecuteSqlTran(hashtable);

            Common.alert("成功删除了" + selectedCount + "个通知！", "NoticeList.aspx?id=" + Request.QueryString["id"]);
        }
        catch { Common.alert("删除失败，请重试！"); }
    }
    /// <summary>
    /// 根据通知Id删除通知信息
    /// </summary>
    /// <param name="id">要执行删除的通知Id</param>
    /// <returns>返回bool类型值，标识是否删除成功</returns>
    protected bool DeleteNoticeById(int id)
    {
        bool result = false;
        try
        {
            new WinStar.BLL.GroupNotice().Delete(id);

            result = true;
        }
        catch { }
        return result;
    }
}