﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_NoticeEdit : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                this.InitNoticeInfo();
            }
            else 
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }

    private void InitNoticeInfo()
    {
        try
        {
            WinStar.BLL.Notice n = new WinStar.BLL.Notice();
            WinStar.Model.Notice mn = n.GetModel(int.Parse(Request["id"].ToString()));
            ViewState["Nid"] = Request["id"].ToString();
            this.title.Text = mn.Title;
            this.Summary.Value = mn.Content;
            this.banji.Text = Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(mn.ClassId)));
        }
        catch { }
    }
    
    protected void btn2_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                string title = this.title.Text;
                string content = this.Summary.Value;
                WinStar.BLL.Notice n = new WinStar.BLL.Notice();
                WinStar.Model.Notice m = n.GetModel(int.Parse(ViewState["Nid"].ToString()));
                m.Title = title;
                m.Content = content;
                n.Update(m);

                Common.alert("修改成功", "NoticesList.aspx");
            }
            catch { Common.alert("修改失败，请重试！"); }
        }      
    }
}