﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.IO;

public partial class Teacher_PicList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                if (!string.IsNullOrEmpty(Request.QueryString["pid"])) //请求的是删除图片的操作
                {
                    if (!this.DelPic()) //如果删除失败，则给出相应提示
                    {
                        Common.alert("删除失败，请重试！");
                    }
                }

                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid); //加载小组信息

                this.LoadGroupPicList(gid); //加载共享图片
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 删除图片
    /// </summary>
    /// <returns>返回bool类型值，标识是否删除成功</returns>
    private bool DelPic()
    {
        bool result = false;
        try
        {
            WinStar.BLL.GroupPic bll = new WinStar.BLL.GroupPic();
            
            WinStar.Model.GroupPic model = bll.GetModel(Convert.ToInt32(Request.QueryString["pid"]));
            bll.Delete(model.Id);
            
            result = true; //数据库数据删除成功则返回成功操作
            
            //删除实际物理文件，释放服务器空间
            if (File.Exists(Server.MapPath(model.PicUrl)))
            {
                File.Delete(Server.MapPath(model.PicUrl));
            }
        }
        catch { }
        return result;
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 加载小组共享图片列表
    /// </summary>
    /// <param name="gid">小组Id</param>
    protected void LoadGroupPicList(int gid)
    {
        try
        {
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = new WinStar.BLL.GroupPic().GetList(string.Format(" GroupId={0} order by Id Desc", gid)).Tables[0];

            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.rptPicList.DataSource = pds;
            this.rptPicList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 分页控件也索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadGroupPicList(Convert.ToInt32(Request.QueryString["id"]));
    }
}