﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_ResultsEdit : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                try
                {
                    WinStar.BLL.Results r = new WinStar.BLL.Results();
                    WinStar.Model.Results m = r.GetModel(int.Parse(Request["id"].ToString()));
                    examinfo(m.Eid.ToString());
                    ViewState["id"] = m.Id;
                    ViewState["eid"] = m.Eid;
                    this.Label1.Text = m.Num;
                    this.mark.Text = m.Mark.ToString();
                }
                catch { }
            }
        }
    }
    
    protected void examinfo(string eid)
    {
        try
        {
            WinStar.BLL.ExamInfo n = new WinStar.BLL.ExamInfo();
            WinStar.Model.ExamInfo mn = n.GetModel(int.Parse(eid));
            this.examname.Text = mn.ExamName;
        }
        catch { }
    }

    protected void btn2_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                if (!IsNumeric(this.mark.Text))
                {
                    Common.alert("分数必须为数字,且大于0小于100");
                    return;
                }
                string title = this.examname.Text;
                WinStar.BLL.Results n = new WinStar.BLL.Results();
                WinStar.Model.Results m = n.GetModel(int.Parse(ViewState["id"].ToString()));
                m.Eid = int.Parse(ViewState["eid"].ToString());
                m.Mark = decimal.Parse(this.mark.Text);
                n.Update(m);
                Common.alert("修改成功", "Resultslist.aspx?id=" + ViewState["eid"]);
            }
            catch { Common.alert("修改失败，请重试！"); }
        }
    }
    
    private bool IsNumeric(string str)
    {
        if (str == null || str.Length == 0)
            return false;
        System.Text.ASCIIEncoding ascii = new System.Text.ASCIIEncoding();
        byte[] bytestr = ascii.GetBytes(str);
        foreach (byte c in bytestr)
        {
            if ((c < 48 && c != 46) || c > 57)
            {
                return false;
            }
        }
        if (float.Parse(str) < 0 || float.Parse(str) > 100)
        {
            return false;
        }
        return true;
    }
}