﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_ResultsList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                ViewState["eid"] = Request.QueryString["id"];
                if (Request["Type"] != null && Request["Type"].ToString() == "Del")
                {
                    try
                    {
                        ResultsDel(Request.QueryString["rid"]);
                    }
                    catch { Common.alert("删除失败，请重试！"); }
                }
                else
                {                    
                    bindlist(ViewState["eid"].ToString());
                }
            }
        }
    }
    
    protected void bindlist(string eid)
    {
        try
        {
            examinfo(eid);
            string where = string.Empty;
            if (Request["cid"] != null && Request.QueryString["cid"] != "")
            {
                where = " and s.classid='" + Request.QueryString["cid"] + "' ";
            }
            string sql = "select r.*,s.classid cid,s.TrueName from HS_Student s,HS_Results r where s.num=r.num and r.eid='" + eid + "' " + where + " order by mark desc";
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;

            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.noticeList.DataSource = pds;
            this.noticeList.DataBind();
        }
        catch { }
    }
   
    protected void examinfo(string eid)
    {
        try
        {
            WinStar.BLL.ExamInfo n = new WinStar.BLL.ExamInfo();
            WinStar.Model.ExamInfo mn = n.GetModel(int.Parse(eid));
            this.examname.Text = mn.ExamName;
            this.examtime.Text = Convert.ToDateTime(mn.ExamTime.ToString()).ToShortDateString();
            this.examclass.Text = getbj(mn.ExamClass);
        }
        catch { }
    }
    
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        bindlist(ViewState["eid"].ToString());
    }
    
    protected void ResultsDel(string id)
    {
        WinStar.BLL.Results u = new WinStar.BLL.Results();
        try
        {
            if (u.Exists(int.Parse(id)))
            {
                u.Delete(int.Parse(id));
                Common.alert("删除成功", "ResultsList.aspx?id=" + ViewState["eid"].ToString());
            }
        }
        catch
        {
            Common.alert("删除失败");
        }
    }
    
    protected void btnRpt_Click(object sender, EventArgs e)
    {
        int i = 0;
        try
        {
            foreach (RepeaterItem Item in this.noticeList.Items)
            {
                System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)Item.FindControl("ckbIndex");

                if (chk.Checked)
                {
                    new WinStar.BLL.Results().Delete(int.Parse(chk.Value));
                    i++;
                }
            }
            if (i > 0)
            {
                Common.alert("删除成功", "ResultsList.aspx?id=" + ViewState["eid"].ToString());
                return;
            }
            else
            {
                Common.alert("没有选中的记录");
                return;
            }  
            
        }
        catch
        {
            Common.alert("删除出错，请重试");
        }
    }
    
    protected string getbj(string cid)
    {
        string bj2 = string.Empty;
        try
        {
            string[] sArray = cid.Split(',');
            string sql = string.Empty;
            foreach (string i in sArray)
            {
                sql = "Select g.TypeAge,g.YearIn,c.Id,c.ClassNum,c.GId From HS_Class c,HS_Grade g Where c.GId=g.Id And c.Id='" + i.ToString().TrimEnd(',') + "'";
                System.Data.DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
                if (dt.Rows.Count > 0)
                {
                    bj2 += "<a href=\"?id=" + ViewState["eid"].ToString() + "&cid=" + i.ToString().TrimEnd(',') + "\" class=\"aCss\"><div id=\"divClass" + i.ToString().TrimEnd(',') + "\">" + Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(dt.Rows[0][2]))) + "</div></a>";
                }
                this.hidClassId.Value = Request.QueryString["cid"];
            }
        }
        catch { }
        return bj2.TrimEnd(',');
    }

    protected string getbj2(string cid)
    {
        string bj2 = string.Empty;
        try
        {            
            string[] sArray = cid.Split(',');
            string sql = string.Empty;
            foreach (string i in sArray)
            {
                sql = "Select g.TypeAge,g.YearIn,c.Id,c.ClassNum,c.GId From HS_Class c,HS_Grade g Where c.GId=g.Id And c.Id='" + i.ToString().TrimEnd(',') + "'";
                System.Data.DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
                if (dt.Rows.Count>0)
                {
                    bj2 += Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(dt.Rows[0][2])));
                }
            }
        }
        catch { }
        return bj2.TrimEnd(',');
    }
}