﻿using System;
using System.Text;
using System.Collections.Generic;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.OleDb;
using System.Data;
using System.Data.SqlClient;

public partial class Teacher_ResultsallAdd : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!IsPostBack)
            {
                if (!string.IsNullOrEmpty(Request.QueryString["id"]))
                {
                    examinfo(Request["id"].ToString());
                    ViewState["eid"] = Request["id"].ToString();
                }
            }
        }
    }    
    
    protected void btn2_Click(object sender, EventArgs e)
    {
        try
        {
            if (this.FileUpload1.PostedFile != null)
            {
                string filename1 = FileUpload1.PostedFile.FileName;
                string ext = filename1.Substring(filename1.LastIndexOf(".")).ToLower();
                if (ext != ".xls")
                {
                    Common.alert("文件格式不对，请上传EXCEL文件", "");
                }
                else
                {
                    string filename2 = DateTime.Now.ToString("yyyyMMddhhmmss") + ext;
                    if (!Directory.Exists(Server.MapPath(@"excel_upload\")))
                    {
                        Directory.CreateDirectory(Server.MapPath(@"excel_upload\"));
                    }
                    string fpath = Server.MapPath(@"excel_upload\") + filename2;
                    FileUpload1.SaveAs(fpath);
                    string conn = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + fpath + ";Extended Properties=Excel 8.0";
                    string sqlin = "SELECT * FROM [Sheet1$]";
                    OleDbCommand olecommand = new OleDbCommand(sqlin, new OleDbConnection(conn));
                    OleDbDataAdapter adapterin = new OleDbDataAdapter(olecommand);
                    DataSet dsin = new DataSet();
                    adapterin.Fill(dsin);
                    DataTable d = dsin.Tables[0];//连接并读取excel数据
                    int eid = int.Parse(ViewState["eid"].ToString());
                    int i = count(1, d);
                    if (i > 0)
                    {
                        File.Delete(fpath);
                        Common.alert("导入成功!", "Resultslist.aspx?id=" + ViewState["eid"].ToString());
                    }
                    else
                    {
                        File.Delete(fpath);
                        Common.alert("数据导入错误，请检查Excel文件!");
                    }
                }
            }
        }
        catch { Common.alert("导入失败，请重试！"); }
    }

    protected void examinfo(string eid)
    {
        try
        {
            WinStar.BLL.ExamInfo n = new WinStar.BLL.ExamInfo();
            WinStar.Model.ExamInfo mn = n.GetModel(int.Parse(eid));
            this.examname.Text = mn.ExamName;
            getbj(mn.ExamClass);
        }
        catch { }
    }
    
    protected void getbj(string cid)
    {
        try
        {
            string bj2 = string.Empty;
            string[] sArray = cid.Split(',');
            string sql = string.Empty;
            this.classlist.Items.Clear();
            foreach (string i in sArray)
            {
                sql = "Select g.TypeAge,g.YearIn,c.Id,c.ClassNum,c.GId From HS_Class c,HS_Grade g Where c.GId=g.Id And c.Id='" + i.ToString().TrimEnd(',') + "'";
                System.Data.DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
                if (dt.Rows.Count > 0)
                {
                    this.classlist.Items.Add(new ListItem(Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(dt.Rows[0][2]))), i.ToString().TrimEnd(',')));
                }
            }
            this.classlist.Items.Insert(0, "请选择");
        }
        catch { }
    }    
   
    protected int count(int eid,DataTable d)
    {
        StringBuilder strSql = new StringBuilder();

        int i = 0;
        WinStar.BLL.Results r = new WinStar.BLL.Results();
        WinStar.Model.Results mr = new WinStar.Model.Results();
        try
        {
            for (i = 0; i < d.Rows.Count; i++)//将Excel文件中第一个工作表的数据导入到sql数据库 相应表中
            {
                mr.Eid = eid;
                mr.Num = d.Rows[i][0].ToString();
                mr.Mark = decimal.Parse(d.Rows[i][1].ToString());
                r.Add(mr);
            }
            return i + 1;
        }
        catch (Exception ex)
        {
            throw ex;
            //PageError("数据导入错误，请检查Excel文件!", "");
        }

    }
    
    protected void down_Click(object sender, EventArgs e)
    {
        Response.Redirect("templates.xls");
    }
}