﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_StudentComment : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request.QueryString["tid"]) && !string.IsNullOrEmpty(Request.QueryString["id"]))
        {
            int id = 0;
            int tid = 0;
            try
            {
                id = Convert.ToInt32(Request.QueryString["id"]);
                tid = Convert.ToInt32(Request.QueryString["tid"]);
            }
            catch { }
            if (id > 0 && tid > 0)
            {
                this.hidSid.Value = id + "";

                this.InitTitleMsg(tid);

                this.LoadStudentInfo(id);

                this.LoadCommentList();
            }
        }
    }
    
    protected void InitTitleMsg(int tid)
    {
        switch (tid)
        {
            case 1:
                this.ltTitleMsg.Text = "学期评语";
                break;
            case 2:
                this.ltTitleMsg.Text = "每月评语";
                break;
            case 3:
                this.ltTitleMsg.Text = "每周评语";
                break;
            case 4:
                this.ltTitleMsg.Text = "每日评语";
                break;
        }
        this.hidTypeId.Value = tid + "";
    }
    /// <summary>
    /// 加载学生信息
    /// </summary>
    /// <param name="sid">学生Id</param>
    protected void LoadStudentInfo(int sid)
    {
        try
        {
            WinStar.Model.Student model = new WinStar.BLL.Student().GetModel(sid);
            this.ltStudentInfo.Text = "<font style=\"font-weight:normal;\">" + this.GetCname(Convert.ToInt32(model.ClassId)) + "&nbsp;&nbsp;" + model.TrueName + "同学</font>";
        }
        catch { }
    }
    #region 加载班级
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        string yein = "";
        int isgrade = 0;
        WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
        int gid = Convert.ToInt32(sclass.GId);
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
        yein = grade.YearIn.ToString();
        isgrade = Convert.ToInt32(grade.TypeAge);
        return GetGradeName(yein, isgrade) + "( " + new WinStar.BLL.Class().GetModel(classID).ClassNum + " )班";
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }

    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    #endregion
    /// <summary>
    /// 加载评语列表
    /// </summary>
    protected void LoadCommentList()
    {
        try
        {
            DataTable dt = new WinStar.BLL.Comment().GetList(string.Format(" UserId={0} and typeId={1}",Request.QueryString["id"],Request.QueryString["tid"])).Tables[0];

            this.rptCommentList.DataSource = dt.DefaultView;
            this.rptCommentList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 获取教师名称
    /// </summary>
    /// <param name="id">教师Id</param>
    /// <returns></returns>
    protected object GetTeacherName(object id)
    {
        object str = "未知";
        
        try
        {
            str = new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(id)).TrueName;
        }
        catch { str = "未知"; }

        return str;
    }
}