﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_StudentHomework : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && !string.IsNullOrEmpty(Request.QueryString["classId"]))
            {
                this.LoadSubject(); //加载学科

                this.LoadHomeworkList(); //加载作业
            }
        }
    }
    /// <summary>
    /// 加载学科
    /// </summary>
    protected void LoadSubject()
    {
        try
        {
            string sql = string.Format("select ts.subjectid,s.Name from hs_teachersubject ts,hs_subject s where s.id=ts.subjectid and ts.teacherid={0} and ts.classid={1}",Session["TeacherId"],Request.QueryString["classId"]);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            foreach (DataRow dr in dt.Rows)
            {
                if (!string.IsNullOrEmpty(Request.QueryString["sid"]))
                {
                    this.hidSubjectId.Value = Request.QueryString["sid"];
                }
                else
                {
                    if (dr == dt.Rows[0])
                    {
                        this.hidSubjectId.Value = dr["subjectId"].ToString();
                    }
                }
                this.ltSubjectList.Text += "<a href=\"StudentHomework.aspx?sid=" + dr["subjectId"] + "&id=" + Request.QueryString["id"] + "&classId=" + Request.QueryString["classId"] + "\" class=\"aCss\"><div id=\"divSubject" + dr["subjectId"] + "\">" + dr["Name"] + "</div></a>";
            }
        }
        catch { }
    }
    /// <summary>
    /// 加载家庭作业列表
    /// </summary>
    protected void LoadHomeworkList()
    {
        try
        {
            string sql = string.Format("select hh.Id,hh.Content,hh.CreateTime,hh.EndTime,s.Name subjectName from hs_homework hh,hs_subject s where hh.SubjectId=s.Id and ClassId={0} and subjectId={1} order by hh.Id Desc", Request.QueryString["classId"], this.hidSubjectId.Value);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            PagedDataSource pds = new PagedDataSource();
            pds.DataSource = dt.DefaultView;

            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = this.AspNetPager1.PageSize;

            this.rptHomeworkList.DataSource = pds;
            this.rptHomeworkList.DataBind();
        }
        catch { }
    }

    protected object ConvertContent(object content)
    {
        object obj = "";
        try
        {
            content = Common.DeleteHtml(content.ToString());
            if (content.ToString().Length > 35)
                obj = content.ToString().Substring(0, 32) + "...";
            else
                obj = content;
        }
        catch { }
        return obj.ToString();
    }
    protected object GetCompleteInfo(string action,object hId)
    {
        object str = "";
        try
        {
            string sql = string.Format("select Id,CreateTime,State from hs_submitwork where HomeworkId=17 and UserId=4");
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                if (action == "qingk")
                    str = "<font color=\"green\">已完成</font>";
                if (action == "shij")
                    str = DateTime.Parse(dt.Rows[0]["CreateTime"].ToString()).ToString("yyyy年MM月dd日");
                if (action == "pigai")
                    str = dt.Rows[0]["State"].ToString() == "1" ? "未批改" : "<font color=\"green\">已批改</font>";
                if (action == "timu")
                    str = "CorrectHomework.aspx?id="+dt.Rows[0]["Id"];
            }
            else
            {
                if (action == "qingk")
                    str = "<font color=\"red\">未完成</font>";
                if (action == "shij")
                    str = "<font color=\"red\">未提交</font>";
                if (action == "pigai")
                    str = "<font color=\"red\">作业未提交</font>";
                if (action == "timu")
                    str = "HomeworkInfo.aspx?id="+hId;
            }
        }
        catch { str = "未知"; }
        return str;
    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadHomeworkList();
    }
}