﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_StudentInfo : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { }
                if (id != 0)
                {
                    this.LoadStudentInfo(id);
                }
                else
                {
                    Response.Write("<script type='text/javascript'>alert('抱歉，您访问的地址不存在！');self.close();</script>");
                }
            }
            else
            {
                Response.Write("<script type='text/javascript'>alert('抱歉，您访问的地址不存在！');self.close();</script>");
            }
        }
    }
    /// <summary>
    /// 加载学生信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadStudentInfo(int id)
    {
        try
        {
            WinStar.Model.Student model = new WinStar.BLL.Student().GetModel(id);
            object ClassNum = new WinStar.BLL.Class().GetModel(Convert.ToInt32(model.ClassId)).ClassNum;
            this.ltClassName.Text = Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(model.ClassId)));

            this.LoadComment(id);
            
            if (model.PostId.ToString() == "0")
            {
                this.ltPost.Text = "无职务";
            }
            else
            {
                this.ltPost.Text = new WinStar.BLL.StudentPost().GetModel(Convert.ToInt32(model.PostId)).Name;
            }
            this.ltSex.Text = model.Sex == true ? "男" : "女";
            this.ltStudyNum.Text = model.Num;
            this.ltTrueName.Text = model.TrueName;
            this.ltTitle.Text = this.ltClassName.Text + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + model.TrueName + "同学个人信息";
        }
        catch { }
    }
    /// <summary>
    /// 加载评语信息
    /// </summary>
    /// <param name="UserId"></param>
    protected void LoadComment(object UserId)
    {
        try
        {
            string sql = string.Format("select top 1 CreateTime,Content,TeacherId from hs_comment where [UserId]={0} order by Id Desc", UserId);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.ltCommentMsg.Text = "(<b>给予评语时间：</b>" + DateTime.Parse(dt.Rows[0]["CreateTime"].ToString()).ToString("yyyy年MM月dd日") + "&nbsp;&nbsp;<b>给予评语老师：</b>" + new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(dt.Rows[0]["TeacherId"])).TrueName + ")";
                this.ltComment.Text = dt.Rows[0]["Content"].ToString();
            }
            else
            {
                this.ltComment.Text = "<font color=\"red\">最近没有老师给予评语！</font>";
            }
        }
        catch { this.ltComment.Text = "<font color=\"red\">暂无！</font>"; }
    }
}