/**
 * define tpMoreOptions : Third Party More Options Page
 * 
 ***/
cr.define('options', function () {
  var OptionsPage = options.OptionsPage;

  function TpMoreOptions() {
    OptionsPage.call(this, 'tpMore', templateData.IDS_MORE_SETTING_DLG, 'tpMorePage');
  }

  cr.addSingletonGetter(TpMoreOptions);

  TpMoreOptions.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function () {
      OptionsPage.prototype.initializePage.call(this);
      var that = this;
      this.addEventListener('visibleChange', function (event) {
        tpGetInitOptionsData();
        tpGetInitDownloaderData();
      });

      $('SettingbossKeyBtn').onclick = function (event) {
        chrome.send('bosskeySettingDialog');
      };

      //            $('BUTTON_IDS_MORE_SETTING_DLG_SETTING').onclick = function () {
      //                OptionsPage.navigateToPage('tpMoreMouseGesture');
      //            };
      //            $('BUTTON_IDS_MORE_SETTING_DLG_CLEAR_WHEN_EXIT2_BUTTON').onclick = function () {
      //                chrome.send('tpSetClearData');
      //            };
    },
    initUIData: function () {
      var tpInitOptionsData = [
          'IDS_MORE_SETTING_DLG_OPEN_BOOKMARK',
          'IDS_MORE_SETTING_DLG_OPEN_ADDR_BOX_URL',
      //          'IDS_MORE_SETTING_DLG_NEW_TAB_ORDER',
      //          'IDS_MORE_SETTING_DLG_TABMODE_LABEL',
          'IDS_MORE_SETTING_DLG_ENABLE_MOUSE_GESTURE',
          'IDS_MORE_SETTING_DLG_ENABLE_MOUSE_GESTURE_TIPS',
          'IDS_THIRDPARTY_DOWNLOADER_SELECT_DEFAULTUSE_DOWNLOADER',
      //'IDS_THIRDPARTY_DOWNLOADER_ASK_ME_TO_SELECT_BEFOREDOWNLOAD',
          'IDS_MORE_SETTING_DLG_RIGHT_BUTTON_TO_CLOSE_TAB',
          'IDS_MORE_SETTING_DLG_ENABLE_MINIMIZE_TO_SYSTEM_TRAY',
          'IDS_MORE_SETTING_DIRECTWRITE_SUPPORT',
          'IDS_MORE_SETTING_DLG_ENABLE_GOOGLE_SYNC',
          'IDS_MORE_SETTING_DLG_ENABLE_GOOGLE_SYNC2',
      //          'IDS_MORE_SETTING_DLG_CLEAR_WHEN_EXIT2',
      //          'IDS_MORE_SETTING_DLG_CONFIRM_CLOSE_WINDOW_TITLE',
      //'IDS_MORE_SETTING_DLG_DOUBLE_CLICK_TO_CLOSE_TAB',
      //          'IDS_MORE_SETTING_DLG_DRAG_TEXT_TO_SEARCH',
      //          'IDS_MORE_SETTING_DLG_HIDE_INACTIVE_TAB_CLOSE',
      //          'IDS_MORE_SETTING_DLG_NEW_TAB_IN_FOREGROUND',
      //          'IDS_SHOW_BAR_ON_VIDEO',

          'IDS_MORE_SETTING_DLG_NEW_TAB_ORDER_EX',
          'IDS_MORE_SETTING_DLG_CLOSE_TAB',
          'IDS_MORE_SETTING_WHEEL_SWITCH_TAB',
          'IDS_MORE_SETTING_HOVER_SWITCH_TAB',
          'IDS_MORE_SETTING_MILLISECOND'
        ],
        tpOptionsData = templateData['tpOptionsInitData'];
      tpInitOptionsData.forEach(function (key) {
        var dataKey = key;
        if (/^IDS_MORE_SETTING_DLG_ENABLE_GOOGLE_SYNC/.test(key)) {
          dataKey = 'IDS_MORE_SETTING_DLG_ENABLE_GOOGLE_SYNC';
        }
        var tpOptionData = tpOptionsData[dataKey];
        if (tpOptionData) {
        var options = tpOptionData['options'];
        var value = tpOptionData['value'];
        if (key == 'IDS_MORE_SETTING_DLG_NEW_TAB_ORDER_EX') {
          var radioNewTabOrders = document.getElementsByName(key);
          for (var iTabOrder = 0; iTabOrder < radioNewTabOrders.length;
                         iTabOrder++) {
            var item = radioNewTabOrders[iTabOrder];
            item.checked = (parseInt(item.value) == value);
            item.onchange = function () {
              tpOptionData[key] = parseInt(this.value);
              tpSetOptionsData(key, tpOptionData[key]);
            }
          }
        }
        else if (key == 'IDS_MORE_SETTING_DLG_CLOSE_TAB') {
          var radioCloseTabOrders = document.getElementsByName(key);
          for (var iTabOrder = 0; iTabOrder < radioCloseTabOrders.length;
                         iTabOrder++) {
            var item = radioCloseTabOrders[iTabOrder];
            item.checked = (parseInt(item.value) == value);
            item.onchange = function () {
              tpOptionData[key] = parseInt(this.value);
              tpSetOptionsData(key, tpOptionData[key]);
            }
          }
        }
        else if (key == 'IDS_MORE_SETTING_WHEEL_SWITCH_TAB') {
          var checkboxEl = document.getElementById(key);
          checkboxEl.checked = !!value;
          checkboxEl.onchange = function () {
            tpOptionData[key] = this.checked ? 1 : 0;
            tpSetOptionsData(key, tpOptionData[key]);
          }
        }
        else if (key == 'IDS_MORE_SETTING_HOVER_SWITCH_TAB') {
          var checkboxEl = document.getElementById(key);
          checkboxEl.checked = !!value;
          checkboxEl.onchange = function () {
            var editId = 'IDS_MORE_SETTING_MILLISECOND';
            var editEl = document.getElementById(editId);
            editEl.disabled = !this.checked;
            tpOptionData[key] = this.checked ? 1 : 0;
            tpSetOptionsData(key, tpOptionData[key]);
            var timeval = parseInt(editEl.value);
            tpOptionData[editId] = timeval;
            tpSetOptionsData(editId, tpOptionData[editId]);
          }
        }
        else if (key == 'IDS_MORE_SETTING_MILLISECOND') {
          var editEl = document.getElementById(key);
          var checkboxEl = document.getElementById('IDS_MORE_SETTING_HOVER_SWITCH_TAB');
          editEl.value = String(value);
          editEl.disabled = !checkboxEl.checked;
          if (editEl.addEventListener) {
            editEl.addEventListener("keypress", filterNumber, false);
            editEl.addEventListener("textInput", filterNumber, false);
            editEl.addEventListener("textinput", filterNumber, false);
          }
          editEl.onchange = function () {
            this.value = ChangeToNumberStr(this)
            var timeval = parseInt(this.value);
            if (timeval < 50)
              timeval = 50;
            if (timeval > 2000)
              timeval = 2000;
            if (timeval != parseInt(this.value))
              this.value = String(timeval);
            tpOptionData[key] = timeval;
            tpSetOptionsData(key, tpOptionData[key]);
          }
          function ChangeToNumberStr(editCtrl) {
            var firstNoneZero = false;
            var text = "";
            for (var j = 0; j < editCtrl.value; j++) {
              var c = editCtrl.value.charAt(j);
              if (c != '0' && !firstNoneZero) {
                firstNoneZero = true;
              }
              if (firstNoneZero)
                text = text + c;
            }
            var allowed = "0123456789";
            var invalid_data = 0;
            if (text.length == 0) invalid_data = 1;
            for (var i = 0; i < (text.length && invalid_data == 0); i++) {
              var c = text.charAt(i);
              if (allowed.indexOf(c) == -1) {
                invalid_data = 1;
              }
            }
            if (invalid_data > 0) {
              text = "400";
            }
            return text;
          }
          function filterNumber(event) {
            var e = event || window.event;
            var target = e.target || e.srcElement;
            var text = null;
            var keypressing = (e.type == "keypress");
            if (!keypressing) {
              text = e.data;
            }
            else {
              var code = e.charCode || e.keyCode;
              if (code < 32 || e.charCode == 0 || e.ctrlKey || e.altKey)
                return;
              text = String.fromCharCode(code);
            }
            var allowed = "0123456789";
            var invalid_data = 0;
            for (var i = 0; i < text.length; i++) {
              var c = text.charAt(i);
              if (allowed.indexOf(c) == -1) {
                invalid_data = 1;
                break;
              }
              if (keypressing) {
                if (target.value.length == 0 && c == '0') {
                  invalid_data = 1;
                  break;
                }
              }
            }
            if (invalid_data > 0) {
              if (e.preventDefault)
                e.preventDefault();
              if (e.returnValue)
                e.returnValue = false;
              if (invalid_data == 2)
                target.value = text.substr(1, text.length - 1);
              return false;
            } else {
              if (text.length == 0)
                target.value = "400";
            }
          }
        }
        else {
          if (!options || options.length == 0) { //checkbox
            var checkboxEl = $('CHECKBOX_' + key);
            if (!checkboxEl) return;
            checkboxEl.checked = !!value;
            checkboxEl.onchange = function (e) {
              var k = this.id.replace('CHECKBOX_', '');
              var confirmed = true;
              if (/^IDS_MORE_SETTING_DLG_ENABLE_GOOGLE_SYNC/.test(k)) {
                k = 'IDS_MORE_SETTING_DLG_ENABLE_GOOGLE_SYNC';
                var text_str = $('sync-unlogined-switch-confirm-text').innerHTML;
                if (PersonalOptions && PersonalOptions.is360SyncSetupCompleted()) {
                  text_str = $('sync-logined-switch-confirm-text').innerHTML;
                }
                confirmed = window.confirm(text_str);
              }
              if (confirmed) {
                tpOptionData[k] = this.checked ? 1 : 0;
                tpSetOptionsData(k, tpOptionData[k]);
              }
              else {
                this.checked = !this.checked;
                e.preventDefault();
                e.stopPropagation();
              }
            }
          } else { //select
            var str = '', selected = '', selectEl = $('SELECT_' + key), downloadSettingPage = key == 'IDS_THIRDPARTY_DOWNLOADER_SELECT_DEFAULTUSE_DOWNLOADER';
            options.forEach(function (option, idx) {
              selected = (value == idx) ? 'selected' : '';
              str += '<option value="' + idx + '" ' + selected + '>' + templateData[option] + '</option>';
            });
            selectEl.innerHTML = str;
            if (downloadSettingPage) {
              //var style_ele = document.getElementById('downloadSettingPage').querySelectorAll('input[name="style"]'),
              //updateUIDataҲУ֪ΪʲôԭطҪд
              style_ids = ['cb_always_show_download', 'cb_turm_on_sound'],
              ids = ['cb_prompt_for_download', 'cb_always_continue_download_restart', 'cb_save_download_path', 'cb_show_downloads_panel_for_completed', 'cb_show_download_mini_task_view'],
              setStyledisabled = function (desabled) {
                for (var i = 0; i < style_ids.length; i++) {
                  if($(style_ids[i])) $(style_ids[i]).disabled = desabled;
                }
              },
              setDisabled = function (val) {
                for (var i = 0; i < ids.length; i++) {
                  $(ids[i]).disabled = (val > 0);
                }
                //for (var i = 0; i < style_ele.length; i++) {
                //  style_ele[i].disabled = (val > 0);
                //}
                if (val > 0) {
                  setStyledisabled(true);
                }else{
                  //style_ele = document.getElementsByName('style');
                  //if (style_ele[1].checked) {
                  //  setStyledisabled(true);
                  //} else {
                    setStyledisabled(false);
                  //}
                }
              };
              //style_ele[0].onchange = function () {
              //  if (this.checked) {
              //    setStyledisabled(false);
              //  }
              //}
              //style_ele[1].onchange = function () {
              //  if (this.checked) {
              //    setStyledisabled(true);
              //  }
              //}
              setDisabled(value);
            }
            selectEl.onchange = function () {
              if (downloadSettingPage) setDisabled(this.value);
              var k = this.id.replace('SELECT_', '');
              tpOptionsData[k].value = this.value;
              templateData['tpOptionsInitData'] = tpOptionsData;
              tpSetOptionsData(k, this.value);
            }
          }
        }
        }
      });

      UpdateMouseGeture();
    },
    /** added by caolong 2011-05-04 18:34:21
    * Update the Default Browsers section based on the current state.
    * @private
    * @param {string} statusString Description of the current default state.
    * @param {boolean} isDefault Whether or not the browser is currently
    *     default.
    * @param {boolean} canBeDefault Whether or not the browser can be default.
    */
    updateCurrentBossKeyState_: function (enableState, bossKeyValue) {
      var label = $('currentBossKeyState');
      //label.textContent = enableState + bossKeyValue;
      label.innerHTML = bossKeyValue ? ('(' + bossKeyValue + ')'):'';
    },
    updateUIData: function (data) {
      for (var key in data) {
        if (key == "IDS_MORE_SETTING_DLG_TABMODE_LABEL") {
          continue;
        }
        var tpOptionData = templateData['tpOptionsInitData'][key],
          options = tpOptionData['options'],
          value = tpOptionData['value'];

        if (!options || options.length == 0) {
          if ($('CHECKBOX_' + key))
            $('CHECKBOX_' + key).checked = !!value;
        } else {
          var style_ids = ['cb_always_show_download', 'cb_turm_on_sound'],
              ids = ['cb_prompt_for_download', 'cb_always_continue_download_restart'],
              setStyledisabled = function (desabled) {
                for (var i = 0; i < style_ids.length; i++) {
                  $(style_ids[i]).disabled = desabled;
                }
              },
              setDisabled = function (val) {
                for (var i = 0; i < ids.length; i++) {
                  $(ids[i]).disabled = (val > 0);
                }
                setStyledisabled(val > 0);
              };
          var str = '', selected = '', selectEl = $('SELECT_' + key);
          if(!selectEl) continue;
          options.forEach(function (option, idx) {
            selected = (value == idx) ? 'selected' : '';
            str += '<option value="' + idx + '" ' + selected + '>' + templateData[option] + '</option>';
          });
          selectEl.innerHTML = str;
        }
      }


    }
  };


  //update bosskey by caolong 2011-05-31 21:23:29
  TpMoreOptions.updateCurrentBossKeyState = function (statusString, bossKey) {
    if (!cr.isChromeOS) {
      TpMoreOptions.getInstance().updateCurrentBossKeyState_(statusString, bossKey);
    }
  };

  return {
    TpMoreOptions: TpMoreOptions
  };
});
// ǰյ  صݻ ͬ
var tpOptionsReceiveDataTypes = {dataGot: 1, dataChanged: 2}, tpOptionsReceiveDataType = null ;
function tpSetDefaultOptionsReceiveDataType(){
  tpOptionsReceiveDataType = null;
}
function tpGetOptionsData(key){
  if (!key){
    return ;
  }
  chrome.send('tpOptionGetKey', [key]);
}

function tpSetOptionsData(key, value){
  if (!key || tpOptionsReceiveDataType === tpOptionsReceiveDataTypes.dataChanged){
    return;
  }
  //console.log('tpSetOptionsData', key, value);
  if (key == 'IDS_MORE_SETTING_DLG_ENABLE_GOOGLE_SYNC'){
    templateData['tpOptionsInitData']['IDS_MORE_SETTING_DLG_ENABLE_GOOGLE_SYNC'].value = parseInt(value);
//    if (value == 1){
//      chrome.send('tpShowSyncLogoutDialog');
//    }
  }
  chrome.send('tpOptionSetKey', [key, value.toString()]);
}

var gOptionData;
function onTpOptionGetKey(data, downloaderData){
  if (!data){
    return ;
  }
  gOptionData = data;

  var initData = templateData['tpOptionsInitData'];
  if (!initData){  //define templateData.tpOptionsInitData
    initData = templateData['tpOptionsInitData'] = {};
  }

  //ص дtemplateData
  for(var key in data){
    initData[key] = data[key][0];  //Ϊ Ͷ valueṹһ£array
  }
  
  if (downloaderData) {
	  initData['IDS_THIRDPARTY_DOWNLOADER_SELECT_DEFAULTUSE_DOWNLOADER'] = downloaderData;
	  var arr_options = [];
	  for (var key in downloaderData['options']) {
		templateData[key] = downloaderData['options'][key];
		arr_options.push(key);
	  }
	  initData['IDS_THIRDPARTY_DOWNLOADER_SELECT_DEFAULTUSE_DOWNLOADER']['options'] = arr_options;
  }
  
  //build UI
  tpOptionsReceiveDataType = tpOptionsReceiveDataTypes.dataGot;
  options.TpMoreOptions.prototype.initUIData();
  tpSetDefaultOptionsReceiveDataType();
}

function onTpGetExternalDownloaderName(data, value) {
	onTpOptionGetKey(gOptionData, {options: data, value: value});
}

function onTpOptionSetKey(data){
  
}

function onTpOptionDataChanged(data){
  if (!data){
    return ;
  }

  var initData = templateData['tpOptionsInitData'];
  if (!initData){
    return ;
  }
  for(var key in data){
    initData[key] = data[key][0];
  }
  
  //  UI
  tpOptionsReceiveDataType = tpOptionsReceiveDataTypes.dataChanged;
  options.TpMoreOptions.prototype.updateUIData(data);
  tpSetDefaultOptionsReceiveDataType();
}

function tpGetInitOptionsData(){
  chrome.send('tpOptionGetKey');
}

function tpGetInitDownloaderData() {
  chrome.send('tpGetExternalDownloaderName');
}
