
(function(){
  Object.prototype.myDelegate = function(doEl, eventType, func){
    var delegateFunc = function(){
        var e = event, target = e.target;
        var isDoElChild = function(el){
          if(typeof(el.parentNode.classList) == 'undefined') return false;
          if(el.parentNode && 
              ((doEl.indexOf('.') == 0 && el.parentNode.classList && el.parentNode.classList.contains(doEl.replace('.',''))) || el.parentNode.tagName.toLowerCase() == doEl.toLowerCase())
          ){
            target = el.parentNode;
            return true;
          }else if(el.parentNode.parentNode){
            return isDoElChild(el.parentNode);
          }
          return false;
        };
        if((doEl.indexOf('.') == 0 && target.classList.contains(doEl.replace('.',''))) || target.tagName.toLowerCase() == doEl.toLowerCase() || isDoElChild(e.target)){
          func && func(target);
        }
      };
    this.addEventListener(eventType, delegateFunc, true);
  };
  
  var LastTabs = function(opt){
    window.localStrings = window.localStrings || new LocalStrings();
    //this.init(opt); 
  };
  LastTabs.prototype = {
    init: function(opt){
      if(!opt || opt.length == 0){
        opt = [{last_data:[]}, {later_data:[]}];
      }
      var defaults = {};
      defaults.last_data = opt[0].last_data;
      defaults.later_data = opt[1].later_data;
      this.delete_queue = [];
      this.lastArr = defaults.last_data;
      this.laterArr = defaults.later_data;
      this.init_el();
      this.show_last_list();
      this.show_later_list();
      this.make_button_event();
    },
    init_el: function(){
      /*this.main_ = this.create_el('div');
      this.main_.id = 'main';
      document.body.appendChild(this.main_);*/
      this.main_ = document.getElementById('main');
      this.main_.textContent = '';
      
      this.last_hd = this.create_el('h2');
      this.last_hd.textContent = localStrings.getString('last_tabs');
      this.last_hd.className = 'hd'; 
      this.main_.appendChild(this.last_hd);
      
      this.del_all_btn = this.create_el('button');
      this.del_all_btn.textContent = localStrings.getString('del_all');
      
      this.histoty_btn = this.create_el('button');
      this.histoty_btn.textContent = localStrings.getString('to_history');
      
      this.last_hd.appendChild(this.histoty_btn);
      this.last_hd.appendChild(this.del_all_btn);
      
      this.last_time = this.create_el('div');
      this.last_time.textContent = this.get_last_time_text();
      this.last_time.className = 'time';
      this.last_open_all_btn = this.create_el('button');
      this.last_open_all_btn.textContent = localStrings.getString('open_all');
      this.last_time.appendChild(this.last_open_all_btn);
      this.main_.appendChild(this.last_time);
      
      this.last_list = this.create_el('ul');
      this.last_list.className = 'list';
      this.main_.appendChild(this.last_list);
      
      this.later_hd = this.create_el('h2');
      this.later_hd.textContent = localStrings.getString('later_tabs'); http: //hao.360.cn/
      this.later_hd.className = 'hd'; 
      
      this.later_list = this.create_el('ul');
      this.later_list.className = 'list';
      
    },
    create_el: function(el_name){
      return document.createElement(el_name);
    },
    encodeURIForCSS: function(uri) {
      return uri.replace(/\(/g, "\\(").replace(/\)/g, "\\)");
    },
    get_last_time_text: function(){
      var cur_date = new Date(),
      cur_y_m_d = cur_date.getFullYear() + '-' + (cur_date.getMonth() + 1) + '-' + cur_date.getDate(),
      cur_t_s = new Date(cur_y_m_d + ' 0:0').getTime(),
      cur_t_e = new Date(cur_y_m_d + ' 23:59').getTime()
      ;
      var last_time = this.lastArr.length == 0? (new Date().getTime()) : this.lastArr[0].timestamp,
      day_t = 60*60*24*1000,
      time_text,
      last_date = new Date(last_time);
      var numArr = ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09'];
      if(last_time > cur_t_s && last_time < cur_t_e){
        time_text = localStrings.getString('today');
      }else if((last_time + day_t) > cur_t_s && (last_time + day_t) < cur_t_e){
        time_text = localStrings.getString('yestoday');
      }else{
        time_text = last_date.getFullYear() + '-' + (numArr[(last_date.getMonth() + 1)] || (last_date.getMonth() + 1)) + '-' + (numArr[last_date.getDate()]||last_date.getDate());
      }
      return time_text += ' ' + (numArr[last_date.getHours()]||last_date.getHours()) + ':' + (numArr[last_date.getMinutes()]||last_date.getMinutes());
    },
    update_all_btn: function(){
      if(!this.last_list.querySelector('li') && !this.later_list.querySelector('li')) this.del_all_btn.disabled = true;
    },
    make_li_el: function(obj){
      if(!obj.title) obj.title = obj.url;
      var li_ = this.create_el('li');
      var link_ = this.create_el('a');
      link_.href = obj.url;
      link_.title = obj.title;
      link_.setAttribute('target', '_blank');
      link_.innerHTML = '<i style="background-image:url(chrome://favicon/' + this.encodeURIForCSS(obj.url) + ')"></i>' + obj.title;
      var del_ = this.create_el('del');
      del_.time = obj.timestamp;
      li_.appendChild(link_);
      li_.appendChild(del_);
      return li_;
    },
    show_empty_info: function(){
      if(!document.getElementById('empty_info')){
        this.empty_info = this.create_el('div');
        this.empty_info.id = 'empty_info';
        this.empty_info.className = 'empty';
        this.empty_info.textContent = localStrings.getString('last_tabs_empty');
        this.last_list.appendChild(this.empty_info);
      }
      this.last_open_all_btn.disabled = true;
      this.update_all_btn();
    },
    show_last_list: function(){
      var len = this.lastArr && this.lastArr.length || 0;
      if(len == 0){
        this.show_empty_info();
        return; 
      }
      var df = document.createDocumentFragment('li');
      for(var i=0; i<len; i++){
        var li = this.make_li_el(this.lastArr[i]);
        df.appendChild(li);
        this.lastArr[i].domNode_ = li;
      }
      this.last_list.appendChild(df);
      this.make_li_delegate(this.last_list);
    },
    show_later_list: function(){
      var len = this.laterArr && this.laterArr.length || 0;
      if(len == 0){
        return; 
      }
      var df = document.createDocumentFragment('li');
      for(var i=0; i<len; i++){
        var li = this.make_li_el(this.laterArr[i]);
        df.appendChild(li);
        this.laterArr[i].domNode_ = li;
      }
      this.later_list.appendChild(df);
      this.main_.appendChild(this.later_hd);
      this.main_.appendChild(this.later_list);
      this.make_li_delegate(this.later_list);
    },
    make_li_delegate: function(list){
      var this_ = this;
      list.myDelegate('li', 'mouseover', function(e){
        if(!e.classList.contains('empty')){
          e.classList.add('hover');
          e.querySelector('del').style.display = 'block';
        }
      });
      list.myDelegate('li', 'mouseout', function(e){
        if(!e.classList.contains('empty')){
          e.classList.remove('hover');
          e.querySelector('del').style.display = 'none';
        }
      });
      list.myDelegate('del', 'click', function(e){
        this_.remove_from_list(e);
      });
    },
    make_button_event: function(){
      var this_ = this;
      this.del_all_btn.addEventListener('click', function(){
        var confirm_text = localStrings.getString('del_all_confirm_text');
        if(confirm(confirm_text)){
          this.disabled = true;
          this_.remove_all();
        }
      });
      this.last_open_all_btn.addEventListener('click', function(){
        var links = this_.last_list.querySelectorAll('a');
        for(var i=0; i<links.length; i++){
          chrome.send('navigateToUrl', [links[i].href, '_blank', 0, false, false, false, false]);
        }
      });
      this.histoty_btn.addEventListener('click', function(){
        chrome.send('navigateToUrl', ['chrome://history', '_blank', 0, false, false, false, false]);
      });
    },
    update_btns: function(){
      var last_empty = false;
      if(!this.last_list.querySelector('li')){
        this.show_empty_info();
        last_empty = true;
      }
      if(!this.later_list.querySelector('li')){
        this.later_list.style.display = 'none';
        this.later_hd.style.display = 'none';
        last_empty && this.update_all_btn();
      }
    },
    get_del_obj: function(del_el){
      if(!del_el) return null;
      var timestamp = del_el.time,
      url = del_el.previousElementSibling.href;
      for(var i=0; i<this.lastArr.length; i++){
        if(this.lastArr[i].timestamp == timestamp && this.lastArr[i].url == url) return this.lastArr[i];
      }
      for(var i=0; i<this.laterArr.length; i++){
        if(this.laterArr[i].timestamp == timestamp && this.laterArr[i].url == url) return this.laterArr[i];
      }
      return null;
    },
    remove_all: function(){
      this.remove_from_list();
    },
    remove_from_list: function(del_el){
      var delObj = this.get_del_obj(del_el);
      var this_ = this, successCallback, do_type = 'item';
      if(!delObj){
        successCallback = function() {
          var del_arr = this_.main_.querySelectorAll('del');
          for(var i=0; i<del_arr.length; i++){
            this_.fade_out(this_.get_del_obj(del_arr[i]).domNode_);
          }
        };
        do_type = 'all';
        delObj = {};
        delObj.timestamp = 0;
        delObj.url = '';
      }else{
        successCallback = function() {
          this_.fade_out(delObj.domNode_);
        };
      }
      
      this.queue_for_deletion(delObj.timestamp, [delObj.url], do_type, successCallback);
      this.delete_next_in_queue();
    },
    queue_for_deletion: function(timestamp, urls, do_type, callback){
      this.delete_queue.push({ 'timestamp': timestamp, 'urls': urls, 'do_type': do_type, 'callback': callback });
    },
    delete_next_in_queue: function(){
      if (this.delete_queue.length > 0) {
        chrome.send('delLastTabs',
                [this.delete_queue[0].timestamp, String(this.delete_queue[0].do_type)].concat(this.delete_queue[0].urls)
                );
      }
    },
    deleted_callback: function(){
      if (this.delete_queue.length > 0) {
        if (this.delete_queue[0].callback)
          this.delete_queue[0].callback.apply();
        this.delete_queue.splice(0, 1);
        this.delete_next_in_queue();
      } else {
        console.error('Received deleteComplete but queue is empty.');
      }
    },
    fade_out: function(node){
      node.classList.add('fade-out');
      var this_ = this;
      node.addEventListener('webkitTransitionEnd', function() {
        node.parentNode.removeChild(node);
        this_.update_btns();
      });
    }
  };
  window.LastTabs = LastTabs;
})();

function lastTabsInit(){
  window.last_tabs = new LastTabs();
  chrome.send('getLastTabs');
}

document.addEventListener('DOMContentLoaded', lastTabsInit);