package com.miao.charge.dao;

import java.sql.Connection;  
import java.sql.PreparedStatement;
import java.sql.ResultSet;  
import java.sql.SQLException;  
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;  
  
import javax.servlet.http.HttpServlet;  
import com.miao.charge.bean.Income;
import com.miao.charge.utils.JdbcUtil;
  
public class IncomeCrudDao extends HttpServlet{  
	
	private static List<Income> li;
	private Connection conn;
	private PreparedStatement ps;
	private ResultSet resultSet;
	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	
	public List<Income> search(){
		try {  
            //获取连接
            conn = JdbcUtil.getConnection();  
              
            //编写SQL语句，执行，拿到结果集  
            String sql = "select * from income";    
            ps = conn.prepareStatement(sql);  
            resultSet = ps.executeQuery(sql);  
              
            //把结果集的东西倒进ArrayList  
            li = new ArrayList<Income>();
            
            //如下这些杂七杂八都是为了成功展示MySQL数据库里的Datetime类型数据
            Timestamp ts;
            Date d;
            while(resultSet.next()){  
                Income i = new Income();  
                i.setId(resultSet.getInt("id"));  
                i.setIncome_amount(resultSet.getDouble("income_amount"));
                i.setIncome_description(resultSet.getString("income_description"));
                i.setIncome_type(resultSet.getString("income_type"));
                i.setCustomer_name(resultSet.getString("customer_name"));
                i.setCustomer_contact(resultSet.getString("customer_contact"));
                  
                ts = resultSet.getTimestamp("income_date");
            	d = new Date(ts.getTime());
            	i.setIncome_date(d);                	
                
            	li.add(i); 
            	
                //后台打印，试看有没有拿到  
            	//唯有这么麻烦，才能正确打印
                /*ts = resultSet.getTimestamp("income_date");
                if(ts != null){
                	d = new Date(ts.getTime());
                	income_date = sdf.format(d);                	
                }
                
                String ms = resultSet.getInt("id")+" ** "+income_date+" "+resultSet.getString("customer_name"); 
                System.out.println(ms);  */
            }  
        } catch (SQLException e) {  
            e.printStackTrace();  
        } finally{
//        	JdbcUtil.free(conn, ps, resultSet);
        	if(conn != null){
        		try {
					conn.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
        	}
        }
		return li;
    } 

	/**
	 * 结合WebUtil工具类的request2Bean_include_Date(request, T.class)方法使用，
	 * 事半功倍，且减少复写。
	 */
	public void add(Income i) {
		try {
			conn = JdbcUtil.getConnection();
			
			//m.getRegister_date()  == "Thu Feb 16 10:41:38 CST 2017"
			//这不是插入数据库表的格式，正确的插入格式为“	2017-02-16 10:41:38”，因此
			//在这里转换一下。
			String income_date = sdf.format(new Date());
			String sql = "insert into income (INCOME_DATE,INCOME_AMOUNT,INCOME_DESCRIPTION,INCOME_TYPE,CUSTOMER_NAME,CUSTOMER_CONTACT,GROUP_CODE) values('"+income_date+"','"+i.getIncome_amount()+"','"+i.getIncome_description()+"','"+i.getIncome_type()+"','"+i.getCustomer_name()+"','"+i.getCustomer_contact()+"','"+i.getGroup_code()+"')"; 
			ps = conn.prepareStatement(sql);    
            ps.executeUpdate();  
		} catch (SQLException e) {
			e.printStackTrace();
		} finally{
//			JdbcUtil.free(conn, ps);
			try {
				if(conn != null)
				conn.close();
				if(ps!=null)
				ps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 本方法是配合在doGet或者doPost方法里调用的，因为直接从request中一一取出各个数据，然后通过本方法
	 * 传送给DAO，但是有了WebUtil的request2bean方法后，本方法建议弃用，因此这会造成大量add、
	 * update方法复写。
	 */
	public void add(int id, String income_date, Double income_amount, String income_description, String income_type, String customer_name, String customer_contact){
		try {
			conn = JdbcUtil.getConnection();
			String sql = "insert into income values('"+id+"','"+income_date+"','"+income_amount+"','"+income_description+"','"+income_type+"','"+customer_name+"','"+customer_contact+"')";    
            ps = conn.prepareStatement(sql);    
            ps.executeUpdate();  
		} catch (SQLException e) {
			e.printStackTrace();
		} finally{
//			JdbcUtil.free(conn, ps);
			try {
				if(conn != null)
				conn.close();
				if(ps!=null)
				ps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * 结合WebUtil工具类的request2Bean_include_Date(request, T.class)方法使用，
	 * 事半功倍，且减少复写。
	 */
	public void update(Income i) {
		try {
			conn = JdbcUtil.getConnection();
			String income_date = sdf.format(i.getIncome_date());
			String sql = "update income set income_date = '"+income_date+"', income_amount = '"+i.getIncome_amount()+"', income_description = '"+i.getIncome_description()+"', income_type = '"+i.getIncome_type()+"', customer_name = '"+i.getCustomer_name()+"', customer_contact = '"+i.getCustomer_contact()+"' where id = " + i.getId() ;    
			ps = conn.prepareStatement(sql);    
			ps.executeUpdate();  
		} catch (SQLException e) {
			e.printStackTrace();
		} finally{
//			JdbcUtil.free(conn, ps);			
			try {
				if(conn != null)
				conn.close();
				if(ps!=null)
				ps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * 本方法是配合在doGet或者doPost方法里调用的，因为直接从request中一一取出各个数据，然后通过本方法
	 * 传送给DAO，但是有了WebUtil的request2bean方法后，本方法建议弃用，因此这会造成大量add、
	 * update方法复写。
	 */
	public void update(int id, String income_date, Double income_amount, String income_description, String income_type, String customer_name, String customer_contact){
		try {
			conn = JdbcUtil.getConnection();
			String sql = "update income set income_date = '"+income_date+"', income_amount = '"+income_amount+"', income_description = '"+income_description+"', income_type = '"+income_type+"', customer_name = '"+customer_name+"', customer_contact = '"+customer_contact+"' where id = " + id ;    
			ps = conn.prepareStatement(sql);    
			ps.executeUpdate();  
		} catch (SQLException e) {
			e.printStackTrace();
		} finally{
//			JdbcUtil.free(conn, ps);			
			try {
				if(conn != null)
				conn.close();
				if(ps!=null)
				ps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}
	
	public void delete(int id){
		try {
			conn = JdbcUtil.getConnection();
			String sql = "delete from income where id = '"+id +"'";    
			ps = conn.prepareStatement(sql);    
			ps.executeUpdate(); 
		} catch (SQLException e) {
			e.printStackTrace();
		} finally{
//			JdbcUtil.free(conn, ps);			
			try {
				if(conn != null)
				conn.close();
				if(ps!=null)
				ps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}
	
	public void showIncome(){
		System.out.println("********************************************");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
		for(Income i : li){
			String message = i.getId()+" "+sdf.format(i.getIncome_date())+" "
				+i.getIncome_amount()+" "+i.getIncome_description()+i.getIncome_type()
					+i.getCustomer_name()+i.getCustomer_contact();
			System.out.println(message);
			System.out.println();
		}
	}
	
	
	//add by ajin  通过  番号获取该群组收入列表
	public List<Income> searchbygroupcode(String groupcode){
		try {  
            //获取连接
            conn = JdbcUtil.getConnection();  
              
            //编写SQL语句，执行，拿到结果集  
            String sql = "select * from income where GROUP_CODE = '"+groupcode+"'";    
            ps = conn.prepareStatement(sql);  
            resultSet = ps.executeQuery(sql);  
              
            //把结果集的东西倒进ArrayList  
            li = new ArrayList<Income>();
            
            //如下这些杂七杂八都是为了成功展示MySQL数据库里的Datetime类型数据
            Timestamp ts;
            Date d;
            while(resultSet.next()){  
                Income i = new Income();  
                i.setId(resultSet.getInt("id"));  
                i.setIncome_amount(resultSet.getDouble("income_amount"));
                i.setIncome_description(resultSet.getString("income_description"));
                i.setIncome_type(resultSet.getString("income_type"));
                i.setCustomer_name(resultSet.getString("customer_name"));
                i.setCustomer_contact(resultSet.getString("customer_contact"));
                  
                ts = resultSet.getTimestamp("income_date");
            	d = new Date(ts.getTime());
            	i.setIncome_date(d);                	
            	i.setGroup_code(resultSet.getString("group_code"));
            	li.add(i); 
            }  
        } catch (SQLException e) {  
            e.printStackTrace();  
        } finally{
        	if(conn != null){
        		try {
					conn.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
        	}
        }
		return li;
    } 
}  