package com.miao.charge.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.miao.charge.bean.Income;
import com.miao.charge.bean.QueryResult;
import com.miao.charge.utils.JdbcUtil;

public class IncomePaginationDao{
    public QueryResult<Income> pageQuery(int startIndex,int pageSize) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        QueryResult<Income> queryResult = new QueryResult<Income>();
        try{
            conn = JdbcUtil.getConnection();
            String sql = "select * from user limit ?,?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, startIndex);
            ps.setInt(2, pageSize);
            resultSet = ps.executeQuery();
            
            Timestamp ts;
            Date d;
            List<Income> contentList = new ArrayList<Income>();
            while(resultSet.next()) {
                Income i = new Income();
                i.setId(resultSet.getInt("id"));  
                i.setIncome_amount(resultSet.getDouble("income_amount"));
                i.setIncome_description(resultSet.getString("income_description"));
                i.setIncome_type(resultSet.getString("income_type"));
                i.setCustomer_name(resultSet.getString("customer_name"));
                i.setCustomer_contact(resultSet.getString("customer_contact"));
                ts = resultSet.getTimestamp("income_date");
            	d = new Date(ts.getTime());
            	i.setIncome_date(d);                	
                
            	contentList.add(i); 
            }
            queryResult.setContentData(contentList);
            //获取了页面数据后还没结束，还得获取总记录数
            sql = "select count(*) from user";
            ps = conn.prepareStatement(sql);
            resultSet = ps.executeQuery();
            if(resultSet.next()) {
                int totalRecords = resultSet.getInt(1);  //rs.getInt("count(*)")也是可以的
                queryResult.setTotalRecords(totalRecords);
            }
            return queryResult;    
        }catch (Exception e) {
            throw new RuntimeException(e);
        }finally{
            JdbcUtil.free(conn, ps, resultSet);;
        }
    }
}