package com.miao.charge.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.miao.charge.bean.Member;
import com.miao.charge.utils.JdbcUtil;
/**
 * 登录验证的Dao类，配合LoginCheckServlet使用，开发这个类让我受益匪浅，最大的收获是
 * 仅仅定义一个对象却不初始化的话，无法使用该对象的set方法，会报空指针异常。
 * @author ZhangCheng
 */
public class LoginCheckDao {
	
	private static Connection conn;
	private static PreparedStatement ps;
	private static ResultSet rs = null;
	private static Member member = new Member();

	/**
	 * 
	 * @param m 来自LoginCheckServlet，在那里通过WebUtil类的request2bean方法
	 * 			把前台输入的登录信息封装成Member对象，并传到这里，再解析、验证。
	 * @return 一旦验证成功，就会返回该Member对象，且填充了所有的成员变量，否则返回null。
	 * @throws SQLException
	 */
	public Member check(Member m) throws SQLException{
		
		String sql = "select * from member where (group_code = '"+m.getGroup_code()+"' or mail = '"+m.getMail()+"' or phone_number = '"+m.getPhone_number()+"') and password = '"+m.getPassword()+"'";
		conn = JdbcUtil.getConnection();
		ps = conn.prepareStatement(sql);  
		rs = ps.executeQuery(sql);
		if(rs.next()){
			return getMember(rs);
		}
		return null;
	}

	/**
	 * 
	 * @param rs 该ResultSet参数是验证过的，有且只有一个元素，而且因此不用while/if(rs.next)了
	 * 			 直接拿出来使用。
	 * @return Member对象。
	 * @throws SQLException
	 */
	public static Member getMember(ResultSet rs) throws SQLException{
		member.setId(rs.getInt("id"));
		member.setGroup_code(rs.getString("group_code"));
		member.setMail(rs.getString("mail"));
		member.setPhone_number(rs.getString("phone_number"));
		member.setRegister_date(rs.getTimestamp("register_date"));
		member.setPassword(rs.getString("password"));
		member.setNickname(rs.getString("nickname"));
		member.setGroup_intro(rs.getString("group_intro"));
		member.setIs_groupleader(rs.getString("is_groupleader").charAt(0));
		return member;
	}
}
