package com.miao.charge.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.miao.charge.bean.Member;
import com.miao.charge.utils.JdbcUtil;

public class MemberCrudDao {

	private static List<Member> lm;
	private Connection conn;
	private PreparedStatement ps;
	private ResultSet rs;
	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	public List<Member> search(){
		try {  
            //获取连接
            conn = JdbcUtil.getConnection();  
              
            //编写SQL语句，执行，拿到结果集  
            String sql = "select * from member";    
            ps = conn.prepareStatement(sql);  
            rs = ps.executeQuery(sql);  
              
            //把结果集的东西倒进ArrayList  
            lm = new ArrayList<Member>();
            
            //如下这些杂七杂八都是为了成功展示MySQL数据库里的Datetime类型数据
            Timestamp ts;
            Date d;
            while(rs.next()){  
                Member m = new Member();  
                m.setId(rs.getInt("id"));  
                m.setGroup_code(rs.getString("Group_code"));
                m.setMail(rs.getString("mail"));
                m.setPhone_number(rs.getString("phone_number"));
                m.setPassword(rs.getString("password"));
                m.setNickname(rs.getString("nickname"));
                m.setGroup_intro(rs.getString("group_intro"));
                  
                ts = rs.getTimestamp("register_date");
            	d = new Date(ts.getTime());
            	m.setRegister_date(d);
                
            	lm.add(m); 
            }  
        } catch (SQLException e) {  
            e.printStackTrace();  
        } finally{
        	JdbcUtil.free(conn, ps, rs);
        }
		return lm;
    } 
	
	public void add(Member m) {
		try {
			conn = JdbcUtil.getConnection();
			
			//m.getRegister_date()  == "Thu Feb 16 10:41:38 CST 2017"
			//这不是插入数据库表的格式，正确的插入格式为“	2017-02-16 10:41:38”，因此
			//在这里转换一下。
			String register_date = sdf.format(m.getRegister_date());
			
			String sql = "insert into member (GROUP_CODE,MAIL,PHONE_NUMBER,REGISTER_DATE,PASSWORD,NICKNAME,GROUP_INTRO,IS_GROUPLEADER) values('"+m.getGroup_code()+"','"+m.getMail()+"','"+m.getPhone_number()+"','"+register_date+"','"+m.getPassword()+"','"+m.getNickname()+"','"+m.getGroup_intro()+"','"+m.getIs_groupleader()+"')";    
            ps = conn.prepareStatement(sql);    
            ps.executeUpdate();  
		} catch (SQLException e) {
			e.printStackTrace();
		} finally{
//			JdbcUtil.free(conn, ps);
			try {
				if(conn != null)
				conn.close();
				if(ps!=null)
				ps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}
	
	public void add(int id, String group_code, String mail, String phone_number, String register_date, String password,
			String nickname, String group_intro) {
		try {
			conn = JdbcUtil.getConnection();
			String sql = "insert into member values('"+id+"','"+group_code+"','"+mail+"','"+phone_number+"','"+register_date+"','"+password+"','"+nickname+"','"+group_intro+"')";    
            ps = conn.prepareStatement(sql);    
            ps.executeUpdate();  
		} catch (SQLException e) {
			e.printStackTrace();
		} finally{
//			JdbcUtil.free(conn, ps);
			try {
				if(conn != null)
				conn.close();
				if(ps!=null)
				ps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}
	
	//add by ajin 
	public List<Member> searchbygroupcode(String groupcode){
		try {  
            //获取连接
            conn = JdbcUtil.getConnection();  
              
            //编写SQL语句，执行，拿到结果集  
            String sql = "select * from member where GROUP_CODE = '"+groupcode+"'";    
            ps = conn.prepareStatement(sql);  
            rs = ps.executeQuery(sql);  
              
            //把结果集的东西倒进ArrayList  
            lm = new ArrayList<Member>();
            
            //如下这些杂七杂八都是为了成功展示MySQL数据库里的Datetime类型数据
            Timestamp ts;
            Date d;
            while(rs.next()){  
                Member m = new Member();  
                m.setId(rs.getInt("id"));  
                m.setGroup_code(rs.getString("Group_code"));
                m.setMail(rs.getString("mail"));
                m.setPhone_number(rs.getString("phone_number"));
                m.setPassword(rs.getString("password"));
                m.setNickname(rs.getString("nickname"));
                m.setGroup_intro(rs.getString("group_intro"));
                  
                ts = rs.getTimestamp("register_date");
            	d = new Date(ts.getTime());
            	m.setRegister_date(d);
                
            	lm.add(m); 
            }  
        } catch (SQLException e) {  
            e.printStackTrace();  
        } finally{
//        	JdbcUtil.free(conn, ps, rs);
        	try {
				if(conn != null)
				conn.close();
				if(ps!=null)
				ps.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
        	
        }
		return lm;
    } 
}
