package com.miao.charge.dao;

import java.sql.Connection;  
import java.sql.PreparedStatement;
import java.sql.ResultSet;  
import java.sql.SQLException;  
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;  
  
import javax.servlet.http.HttpServlet;  
import com.miao.charge.bean.Payment;
import com.miao.charge.utils.JdbcUtil;
  
public class PaymentCrudDao extends HttpServlet{  
	
	private static List<Payment> lp;
	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	
	public List<Payment> search(){
		try {  
			//获取连接
			Connection conn = JdbcUtil.getConnection();  
			
			//编写SQL语句，执行，拿到结果集  
			String sql = "select * from payment";    
			Statement statement = conn.createStatement();  
			ResultSet resultSet = statement.executeQuery(sql);  
			
			//把结果集的东西倒进ArrayList  
			lp = new ArrayList<Payment>();
			
			//如下这些杂七杂八都是为了成功展示MySQL数据库里的Datetime类型数据
			Timestamp ts;
			Date d;
			
			while(resultSet.next()){ 
				Payment p = new Payment();
				p.setId(resultSet.getInt("id"));
				p.setPayment_amount(resultSet.getDouble("payment_amount"));
				p.setPayment_purpose(resultSet.getString("payment_purpose"));
				p.setPay_by_who(resultSet.getString("pay_by_who"));
				
				ts = resultSet.getTimestamp("payment_date");
				d = new Date(ts.getTime());
				p.setPayment_date(d);              	
				
				lp.add(p);
			}  
			JdbcUtil.free(conn, statement, resultSet);
		} catch (SQLException e) {  
			e.printStackTrace();  
		} 
		return lp;
	} 

	/**
	 * 结合WebUtil工具类的request2Bean_include_Date(request, T.class)方法使用，
	 * 事半功倍，且减少复写。
	 */
	public void add(Payment p) {
		try {
			Connection conn = JdbcUtil.getConnection();
			String payment_date = sdf.format(new Date());
			String sql = "insert into payment (PAYMENT_DATE,PAYMENT_AMOUNT,PAYMENT_PURPOSE,PAY_BY_WHO,GROUP_CODE) values('"+payment_date+"','"+p.getPayment_amount()+"','"+p.getPayment_purpose()+"','"+p.getPay_by_who()+"','"+p.getGroup_code()+"')";    
            PreparedStatement ps = conn.prepareStatement(sql);    
            ps.executeUpdate();  
            JdbcUtil.free(conn, ps);
		} catch (SQLException e) {
			e.printStackTrace();
		} 
	}
	
	/**
	 * 本方法是配合在doGet或者doPost方法里调用的，因为直接从request中一一取出各个数据，然后通过本方法
	 * 传送给DAO，但是有了WebUtil的request2bean方法后，本方法建议弃用，因此这会造成大量add、
	 * update方法复写。
	 */
	public void add(int id, String payment_date, Double payment_amount, String payment_purpose, String pay_by_who){
		try {
			Connection conn = JdbcUtil.getConnection();
			String sql = "insert into payment values('"+id+"','"+payment_date+"','"+payment_amount+"','"+payment_purpose+"','"+pay_by_who+"')";    
            PreparedStatement ps = conn.prepareStatement(sql);    
            ps.executeUpdate();  
            JdbcUtil.free(conn, ps);
		} catch (SQLException e) {
			e.printStackTrace();
		} 
	}
	
	/**
	 * 结合WebUtil工具类的request2Bean_include_Date(request, T.class)方法使用，
	 * 事半功倍，且减少复写。
	 */
	public void update(Payment p){
		try {
			Connection conn = JdbcUtil.getConnection();
			String payment_date = sdf.format(p.getPayment_date());
			String sql = "update payment set payment_date = '"+payment_date+"', payment_amount = '"+p.getPayment_amount()+"', payment_purpose = '"+p.getPayment_purpose()+"', pay_by_who = '"+p.getPay_by_who()+"' where id = " + p.getId() ;    
			PreparedStatement ps = conn.prepareStatement(sql);    
			ps.executeUpdate();  
			JdbcUtil.free(conn, ps);
		} catch (SQLException e) {
			e.printStackTrace();
		} 
	}

	/**
	 * 本方法是配合在doGet或者doPost方法里调用的，因为直接从request中一一取出各个数据，然后通过本方法
	 * 传送给DAO，但是有了WebUtil的request2bean方法后，本方法建议弃用，因此这会造成大量add、
	 * update方法复写。
	 */
	public void update(int id, String payment_date, Double payment_amount, String payment_purpose, String pay_by_who){
		try {
			Connection conn = JdbcUtil.getConnection();
			String sql = "update payment set payment_date = '"+payment_date+"', payment_amount = '"+payment_amount+"', payment_purpose = '"+payment_purpose+"', pay_by_who = '"+pay_by_who+"' where id = " + id ;    
			PreparedStatement ps = conn.prepareStatement(sql);    
			ps.executeUpdate();  
			JdbcUtil.free(conn, ps);
		} catch (SQLException e) {
			e.printStackTrace();
		} 
	}
	
	public void delete(int id){
		try {
			Connection conn = JdbcUtil.getConnection();
			String sql = "delete from payment where id = "+id;    
			PreparedStatement ps = conn.prepareStatement(sql);    
			ps.executeUpdate(); 
			JdbcUtil.free(conn, ps);
		} catch (SQLException e) {
			e.printStackTrace();
		} 
	}
	
	public void showPayment(){
		System.out.println("********************************************");
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
		for(Payment p : lp){
			String message = p.getId()+" "+sdf.format(p.getPayment_date())+" "
					+p.getPayment_amount()+" "+p.getPayment_purpose()+p.getPay_by_who();
			System.out.println(message);
			System.out.println();
		}
	}
	
	//
	public List<Payment> searchbygroupcode(String groupcode){
		try {  
			//获取连接
			Connection conn = JdbcUtil.getConnection();  
			
			//编写SQL语句，执行，拿到结果集  
			String sql = "select * from payment where GROUP_CODE = '"+groupcode+"'";    
			Statement statement = conn.createStatement();  
			ResultSet resultSet = statement.executeQuery(sql);  
			
			//把结果集的东西倒进ArrayList  
			lp = new ArrayList<Payment>();
			
			//如下这些杂七杂八都是为了成功展示MySQL数据库里的Datetime类型数据
			Timestamp ts;
			Date d;
			
			while(resultSet.next()){ 
				Payment p = new Payment();
				p.setId(resultSet.getInt("id"));
				p.setPayment_amount(resultSet.getDouble("payment_amount"));
				p.setPayment_purpose(resultSet.getString("payment_purpose"));
				p.setPay_by_who(resultSet.getString("pay_by_who"));
				
				ts = resultSet.getTimestamp("payment_date");
				d = new Date(ts.getTime());
				p.setPayment_date(d);              	
				p.setGroup_code(resultSet.getString("group_code"));
				lp.add(p);
			}  
			JdbcUtil.free(conn, statement, resultSet);
		} catch (SQLException e) {  
			e.printStackTrace();  
		} 
		return lp;
	} 
}  