package com.miao.charge.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.miao.charge.bean.Income;
import com.miao.charge.dao.IncomeCrudDao;

/**
 * 收入 类别 展示
 * @author Administrator
 *
 */
@SuppressWarnings("serial")
@WebServlet(name="incomelistservlet",urlPatterns="/incomeListServlet")
public class IncomeListServlet extends HttpServlet{

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doPost(req, resp);
		
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		
		IncomeCrudDao icd = new IncomeCrudDao();
		
		String groupcode = req.getParameter("groupcode");
		
		groupcode = new String(groupcode.trim().getBytes("ISO-8859-1"),"UTF-8");
		
		List<Income> incomes = icd.searchbygroupcode(groupcode);
		
		req.setAttribute("incomes", incomes);
		
		req.getRequestDispatcher("WEB-INF/pages/income/index.jsp").forward(req, resp);  
	}
	
	

}
