package com.miao.charge.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.miao.charge.bean.Member;
import com.miao.charge.dao.MemberCrudDao;

/**
 *跳转首页
 * @author ajin
 */
@SuppressWarnings("serial")
@WebServlet(name="indexservlet",urlPatterns={"/indexServlet",""})
public class IndexServlet extends HttpServlet{

	MemberCrudDao memberCrudDao = new MemberCrudDao();
	
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doPost(req, resp);
		
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		System.out.println("------------------------------");
		System.out.println("进入IndexServlet doPost方法......");
		//获取该群组下所有成员
		Member member = (Member) req.getSession().getAttribute("membersession");
		if(member !=null){
			List<Member> members = memberCrudDao.searchbygroupcode(member.getGroup_code());
			System.out.println("------------------------------");
			System.out.println(member.getGroup_code()+"所有成员个数："+members.size());
			System.out.println("------------------------------");
			req.setAttribute("members",members);
		}
		
		req.getRequestDispatcher("index.jsp").forward(req, resp);
		
	}

	@Override
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	
}
