package com.miao.charge.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.miao.charge.bean.Member;
import com.miao.charge.dao.LoginCheckDao;
import com.miao.charge.utils.WebUtil;



public class LoginCheckServlet extends HttpServlet{
	
	LoginCheckDao lcd = new LoginCheckDao();
	String checkResult = "";
	HttpSession session;
	Member member;
	
	//重写doGet方法
	@Override
	protected void doGet(HttpServletRequest request,  
        HttpServletResponse response) throws ServletException, IOException {  
		
		Member m = WebUtil.request2Bean_include_Date(request, Member.class);
		
		try {
			member = lcd.check(m);
			if(member != null){
				
				HttpSession session = request.getSession();
				session.setAttribute("membersession", member);
				request.getRequestDispatcher("indexServlet").forward(request, response);
//				request.getRequestDispatcher("WEB-INF/pages/loginCheckTest/welcome.jsp")    
//			    .forward(request, response); 
			}else {
				request.setAttribute("errormsg", "登录失败,请重新登录！");
				request.getRequestDispatcher("indexServlet").forward(request, response);
//				request.getRequestDispatcher("WEB-INF/pages/loginCheckTest/error.jsp")    
//			    .forward(request, response);  
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
    }  
  
    @Override
	protected void doPost(HttpServletRequest request,  
            HttpServletResponse response) throws ServletException, IOException {  
        doGet(request, response);  
    }  
}
