package com.miao.charge.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.miao.charge.bean.Income;
import com.miao.charge.bean.Payment;
import com.miao.charge.dao.IncomeCrudDao;
import com.miao.charge.dao.PaymentCrudDao;

@SuppressWarnings("serial")
@WebServlet(name="paymentlistservlet",urlPatterns="/paymentListServlet")
public class PaymentListServlet extends HttpServlet{

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doPost(req, resp);
		
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		
		PaymentCrudDao  paymentCrudDao = new PaymentCrudDao();
		
		String groupcode = req.getParameter("groupcode");
		
		groupcode = new String(groupcode.trim().getBytes("ISO-8859-1"),"UTF-8");
		
		List<Payment> payments = paymentCrudDao.searchbygroupcode(groupcode);
		
		req.setAttribute("payments", payments);
		
		req.getRequestDispatcher("WEB-INF/pages/expend/index.jsp").forward(req, resp); 
		
	}

	
	
}
