package com.miao.charge.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.miao.charge.bean.Member;
import com.miao.charge.dao.MemberCrudDao;

@WebServlet(urlPatterns={"/sm"})

public class SearchMemberServlet extends HttpServlet{
	
	MemberCrudDao mcd = new MemberCrudDao();
	
	//重写doGet方法
	@Override
	protected void doGet(HttpServletRequest request,  
        HttpServletResponse response) throws ServletException, IOException {  
		List<Member> lm = mcd.search();
		request.setAttribute("lm", lm);
		
		request.getRequestDispatcher("WEB-INF/pages/member/searchMember.jsp")    
        .forward(request, response);  
    }  
  
    @Override
	protected void doPost(HttpServletRequest request,  
            HttpServletResponse response) throws ServletException, IOException {  
        doGet(request, response);  
    }  
}
