package com.miao.charge.servlet;

import java.io.IOException;

import javax.jws.WebService;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.miao.charge.dao.IncomeCrudDao;


@WebServlet(urlPatterns={"/switchjsp"})
public class SwitchJspServlet extends HttpServlet{
	
	IncomeCrudDao sd = new IncomeCrudDao();
	
	//重写doGet方法
	@Override
	protected void doGet(HttpServletRequest request,  
        HttpServletResponse response) throws ServletException, IOException {  
		
		String goal = request.getParameter("goal");
		if(goal == null){
			System.out.println("goal的值为空，不知道意欲何为，统一返回查询页");
			response.sendRedirect("searchIncomeServlet"); 
		}else if(goal.equals("addIncome")){
			request.getRequestDispatcher("WEB-INF/pages/income/addIncome.jsp")    
	        .forward(request, response);  
		}else if(goal.equals("updateIncome")){
			request.getRequestDispatcher("WEB-INF/pages/income/updateIncome.jsp")    
	        .forward(request, response);  
		}else if(goal.equals("addPayment")){
			request.getRequestDispatcher("WEB-INF/pages/expend/addPayment.jsp")    
			.forward(request, response);  
		}else if(goal.equals("updatePayment")){
			request.getRequestDispatcher("WEB-INF/pages/expend/updatePayment.jsp")    
			.forward(request, response);  
		}else if(goal.equals("addMember")){
			request.getRequestDispatcher("WEB-INF/pages/member/addMember.jsp")    
			.forward(request, response); 
		}else if(goal.equals("loginCheck")){
			request.getRequestDispatcher("WEB-INF/pages/loginCheckTest/loginCheck.jsp")    
			.forward(request, response); 
		}else{
			System.out.println("无法识别goal的值："+goal+"，不知道意欲何为，统一返回查询页");
			response.sendRedirect("searchIncomeServlet");
		}
    }  
  
    @Override
	protected void doPost(HttpServletRequest request,  
            HttpServletResponse response) throws ServletException, IOException {  
        doGet(request, response);  
    }  
}
