package com.miao.charge.utils;

import java.sql.Connection;  
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;  
import java.sql.SQLException;  
import java.sql.Statement;  
   
/** 
 * jdbc工具类 
 *  
 * @author WANGYAN 
 *  
 */  
public final class JdbcUtil {  
   
    //数据库连接信息
    private static String url ;  
    private static String username ;  
    private static String password;  
    private static String driver;  
    static {  
           
    	DbConfig config=new DbConfig();  
    	driver = config.getDriver();
    	url = config.getUrl();
    	username = config.getUsername();
    	password = config.getPassword();
    	
        try {  
            Class.forName(driver);  
        } catch (ClassNotFoundException e) {  
            throw new ExceptionInInitializerError(e);  
        }  
    }  
   
    /** 
     * 建立数据库连接 
     *  
     * @return 
     * @throws SQLException 
     */  
    public static Connection getConnection() throws SQLException {  
        Connection conn = null;  
        conn = DriverManager.getConnection(url, username, password);  
        return conn;  
    }  
   
    /** 
     * 释放连接 
     * @param conn 
     */  
    private static void freeConnection(Connection conn) {  
        try {  
            conn.close();  
        } catch (SQLException e) {  
            // TODO Auto-generated catch block  
            e.printStackTrace();  
        }  
    }  
   
    /** 
     * 释放statement 
     * @param statement 
     */  
    private static void freeStatement(Statement statement) {  
        try {  
            statement.close();  
        } catch (SQLException e) {  
            e.printStackTrace();  
        }  
    }  
    
    /** 
     * 释放PreparedStatement 
     * @param preparedStatement 
     */  
    private static void freePreparedStatement(PreparedStatement preparedStatement) {  
    	try {  
    		preparedStatement.close();  
    	} catch (SQLException e) {  
    		e.printStackTrace();  
    	}  
    }  
   
    /** 
     * 释放resultset 
     * @param rs 
     */  
    private static void freeResultSet(ResultSet rs) {  
        try {  
            rs.close();  
        } catch (SQLException e) {  
            // TODO Auto-generated catch block  
            e.printStackTrace();  
        }  
    }  
   
    /** 
     * 释放资源 
     *  
     * @param conn 
     * @param statement 
     * @param rs 
     */  
    public static void free(Connection conn, Statement statement, ResultSet rs) {  
        if (rs != null) {  
            freeResultSet(rs);  
        }  
        if (statement != null) {  
            freeStatement(statement);  
        }  
        if (conn != null) {  
            freeConnection(conn);  
        }  
    }  
    
    /** 
     * 释放资源 
     *  
     * @param conn 
     * @param preparedStatement 
     * @param rs 
     */  
    public static void free(Connection conn, PreparedStatement preparedStatement, ResultSet rs) {  
    	if (rs != null) {  
    		freeResultSet(rs);  
    	}  
    	if (preparedStatement != null) {  
    		freePreparedStatement(preparedStatement);  
    	}  
    	if (conn != null) {  
    		freeConnection(conn);  
    	}  
    }  

	public static void free(Connection conn, PreparedStatement preparedStatement) {
		if (preparedStatement != null) {  
			freePreparedStatement(preparedStatement);  
    	}  
    	if (conn != null) {  
    		freeConnection(conn);  
    	} 
	}
   
}  