package com.miao.charge.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
/**
 * 特别强调：要使用BeanUtils的populate方法，Map集合的key值必须要和对象中的属性名一致才行！
 * special warning：To use BeanUitls' populate() method, you MUST make sure
 * that the keys from the Map must be SAME with the variables of the bean class!!
 * 
 * @author Zhang Cheng
 *
 */
public class WebUtil {   
	
	/**
	 * 只能填充8大基本数据类型。不能填充Date，Calendar，或者自己定义的Animal、Student类。
	 * @param request
	 * @param beanClass
	 * @return T
	 */
	public static <T> T request2Bean(HttpServletRequest request, Class<T> beanClass) {
        try{
            T bean = beanClass.newInstance();
            Map paramMap = request.getParameterMap();
            BeanUtils.populate(bean, paramMap);
            return bean;
            
        }catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
	
	/**
	 * 这个方法包括了request2Bean()的功能，并增加了填充Date类型的扩展
	 * @param request
	 * @param beanClass
	 * @return T
	 */
    public static <T> T request2Bean_include_Date(HttpServletRequest request, Class<T> beanClass) {
        try{
            T bean = beanClass.newInstance();
            Map paramMap = request.getParameterMap();
            
            //BeanUtils的populate只能填充8大基本类型，不能填充日期Date类
            //这一步正是为增加填充日期功能
            ConvertUtils.register(new Converter() {    
                @Override
                public <T> T convert(Class<T> type, Object value) {
                    if(value == null) {
                        return null;
                    }
                    String dateStr = (String) value;
                    if(dateStr.trim().equals("")) {
                        return null;
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        Date date = sdf.parse(dateStr);
                        return (T) date;
                    } catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, Date.class);
            
            /*这样就可以愉快地输入表示日期的字符串了
            Person p = new Person();
            BeanUtils.setProperty(p, "birthday", "1991-7-1 12:10:59");
            System.out.println(p.getBirthday());
                                 输出：Thu Feb 16 10:41:38 CST 2017 */
            
            
            BeanUtils.populate(bean, paramMap);
            return bean;
            
        }catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}