<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport"
	content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta name="applicable-device" content="pc,mobile">
<link rel='shortcut icon' type='image/x-icon' href='favicon.ico' />
<link href="//cdn.bootcss.com/bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet">
<script src="//cdn.bootcss.com/jquery/1.12.3/jquery.min.js"></script>
<script src="//cdn.bootcss.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
<link href="//cdn.bootcss.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
<script src="//cdn.bootcss.com/jquery-validate/1.15.1/jquery.validate.min.js"></script>
<script src="//cdn.bootcss.com/jquery-validate/1.15.1/additional-methods.min.js"></script>
<script src="//cdn.bootcss.com/jquery-validate/1.15.1/localization/messages_zh.min.js"></script>
<title>查看支出列表界面</title>
</head>
<body>
<div class="container">
	<h3 class="text-center"><b class="text-danger">${membersession.group_code}</b>支出列表</h3>
	<h4 class="text-right">
		<a href="indexServlet" class="btn btn-primary"><i class="fa fa-home">首页</i></a>
	</h4>
	<div class = "table-responsive">
		   <table class="table">
		      <caption class="text-center"><b>支出列表</b></caption>
		      <thead>
		         <tr>
		            <th><i class="fa fa-clock-o fa-fw"></i>&nbsp;支出时间</th>
		            <th><i class="fa fa-rmb fa-fw"></i>&nbsp;支出金额(RMB)</th>
		            <th><i class="fa fa-newspaper-o fa-fw"></i>&nbsp;用途说明</th>
		            <th><i class="fa fa-user fa-fw"></i>&nbsp;支出人</th>
		         </tr>
		      </thead>
		      <tbody>
		      	<c:forEach var="payment" items="${payments}">
			         <tr>
			            <td>
			            	<fmt:formatDate value="${payment.payment_date}" pattern="yyyy-MM-dd hh:mm:ss"/>
			            </td>
			            <td>${payment.payment_amount}</td>
			            <td>${payment.payment_purpose}</td>
			            <td>${payment.pay_by_who}</td>
			         </tr>
		      	</c:forEach>
		      </tbody>
		   </table>
	</div>  	
</div>
</body>
</html>