<%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="context/mytags.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
<%-- <base href="<%=basePath %>" /> --%>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport"
	content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta name="applicable-device" content="pc,mobile">
<link rel='shortcut icon' type='image/x-icon' href='favicon.ico' />
<link href="//cdn.bootcss.com/bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet">
<script src="//cdn.bootcss.com/jquery/1.12.3/jquery.min.js"></script>
<script src="//cdn.bootcss.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
<link href="//cdn.bootcss.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
<script src="//cdn.bootcss.com/jquery-validate/1.15.1/jquery.validate.min.js"></script>
<script src="//cdn.bootcss.com/jquery-validate/1.15.1/additional-methods.min.js"></script>
<script src="//cdn.bootcss.com/jquery-validate/1.15.1/localization/messages_zh.min.js"></script>
<link rel="stylesheet" href="https://jqueryvalidation.org/files/demo/site-demos.css">
<link rel="stylesheet" href="resources/css/modalscroll.css">

<title>树根收支平台--上海喵喵科技出品</title>
</head>
<body>
	<div class="container">
		<img alt="收支平台Logo  高130 宽270" src="resources/img/miaomiao_incexp_logo.png" class="center-block"
			style="border:0px solid green; height: 130px; width: 270px;">
		<h3 class="text-center text-success">
			==树根收支平台--<small class="text-info">上海喵喵科技出品</small> ==
			<h4 class="text-right">当前用户昵称：<b>${membersession.nickname}</b> ！ 群组番号：<b>${membersession.group_code}</b> ！</h4>
			<h4 class="text-right">群组介绍：<b>${membersession.group_intro}</b></h4>
			<a href="removeSessionServlet" class="btn btn-danger"><i class="fa fa-sign-out"></i>注销</a>
		</h3>
	</div>
	<hr>
	<div class="container">
		<c:if test="${not empty successmsg}">
			<div class = "alert alert-success alert-dismissable">
			   <button type = "button" class = "close" data-dismiss = "alert" aria-hidden = "true">
			      &times;
			   </button>
			   ${successmsg}
			</div>
		</c:if>
		<h4>常用功能组</h4>
		<c:if test="${membersession.is_groupleader == 49 }">
			<div class="btn-group">
				<button type="button" id="btn_income_add" class="btn btn-default">
					<i class=" fa fa-plus fa-fw"></i>&nbsp;新增收入项
				</button>
				<button type="button" id="btn_expend_add" class="btn btn-default">
					<i class=" fa fa-plus fa-fw"></i>&nbsp;新增支出项
				</button>
			</div>
			<div class="clearfix visible-xs" style="height: 15px;"></div>
			<div class="btn-group">
				<button type="button" id="btn_teamate_add" class="btn btn-default">
					<i class=" fa fa-user-plus fa-fw"></i>&nbsp;新增组员
				</button>
				<button type="button" id="btn_teamate_manage" class="btn btn-default">
					<i class=" fa fa-recycle fa-fw"></i>&nbsp;管理组员
				</button>
			</div>
		</c:if>
		<div class="clearfix visible-xs" style="height: 15px;"></div>
		<div class="btn-group">
			<a href="incomeListServlet?groupcode=${membersession.group_code}" id="btn_income_list"
			 class="btn btn-default"> <i class=" fa fa-eye fa-fw"></i>&nbsp;查看收入列表
			</a>
			<a href="paymentListServlet?groupcode=${membersession.group_code}" id="btn_expend_list" 
			class="btn btn-default"> <i class=" fa fa-eye fa-fw"></i>&nbsp;查看支出列表
			</a>
		</div>
	</div>
	<hr>
	<!-- 登录弹出框 begin -->
	<c:if test="${empty membersession}">
		<div class="modal fade" id="div_modal_teamleader">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-head">
						<!-- <button type="button" class="close" data-dismiss="modal">&times;</button> -->
						<h5 class="text-danger"><b>==登录树根收支平台</b><small>[上海喵喵科技有限公司出品]</small></h5>
					</div>
					<div class="modal-body">
						<c:if test="${not empty errormsg}">
							<div class = "alert alert-danger alert-dismissable">
							   <button type = "button" class = "close" data-dismiss = "alert" aria-hidden = "true">
							      &times;
							   </button>
							   ${errormsg}
							</div>
						</c:if>
						<form id="form-login" action="loginCheckServlet"  method="post" class="form-horizontal" autocomplete="off">
							<div class="form-group">
								<label for="firstname" class="col-sm-3 control-label text-danger">说明</label>
								<div class="col-sm-9">
									<p class="form-control-static text-danger">番号/手机号/邮箱/昵称  任选其一</p>
								</div>
							</div>
							<div class="form-group">
								<label for="group_code" class="col-sm-4 control-label">群组番号(推荐)</label>
								<div class="col-sm-8">
									<input type="text" class="form-control phone-group" name="group_code" id="group_code" placeholder="请输入群组番号 eg 喵喵科技...">
								</div>
							</div>
							<div class="form-group">
								<label for="phone_number" class="col-sm-4 control-label">手机号</label>
								<div class="col-sm-8">
									<input type="text" class="form-control phone-group" name="phone_number" id="phone_number" placeholder="请输入手机号...">
								</div>
							</div>
							<div class="form-group hide">
								<label for="mail" class="col-sm-4 control-label">邮箱</label>
								<div class="col-sm-8">
									<input type="text" class="form-control phone-group" name="mail" id="mail" placeholder="请输入邮箱...">
								</div>
							</div>
							<div class="form-group hide">
								<label for="nickname" class="col-sm-4 control-label">昵称</label>
								<div class="col-sm-8">
									<input type="text" class="form-control phone-group" name="nickname" id="nickname" placeholder="请输入昵称...">
								</div>
							</div>
							<div class="form-group">
								<label for="password" class="col-sm-4 control-label">密码</label>
								<div class="col-sm-8">
									<input type="password" class="form-control" name="password" id="password" placeholder="请输入密码...">
								</div>
							</div>
					</div>
					<div class="modal-footer">
						<a id="a_register" class="btn btn-link" href="javascript:;">我要注册</a>
						<button id="btn_login_submit" type="submit" class="btn btn-primary">确认</button>
					</div>
				</form>
				</div>
			</div>
		</div>
	</c:if>
	<!--=== end ===-->
	<!-- 注册模态框 begin -->
	<div class="modal fade" id="div_modal_register_teamleader">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-head">
					<!-- <button type="button" class="close" data-dismiss="modal">&times;</button> -->
					<h5 class="text-danger"><b>==注册树根收支平台</b><small>[上海喵喵科技有限公司出品]</small></h5>
				</div>
				<div class="modal-body">
					<form id="form-register" method="post" action="addMemberServlet" class="form-horizontal" autocomplete="off">
						<input type="hidden" name="is_groupleader" value="1">
						<div class="form-group">
							<label for="group_code" class="col-sm-3 control-label">群组番号</label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="group_code" id="group_code" placeholder="请输入群组番号 例如:喵喵科技 ...">
							</div>
						</div>
						<div class="form-group">
							<label for="group_intro" class="col-sm-3 control-label">群组介绍</label>
							<div class="col-sm-9">
								<textarea class="form-control" rows="2" cols="40" name="group_intro" id="group_intro" placeholder="一家提供互联网解决方案的团队 ..."></textarea>
							</div>
						</div>
						<div class="form-group">
							<label for="mail" class="col-sm-3 control-label">邮箱</label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="mail" id="mail" placeholder="请输入常用邮箱...">
							</div>
						</div>
						<div class="form-group">
							<label for="nickname" class="col-sm-3 control-label">昵称</label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="nickname" id="nickname" placeholder="eg：大猫，白猫...">
							</div>
						</div>
						<div class="form-group">
							<label for="phone_number" class="col-sm-3 control-label">手机号</label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="phone_number" id="phone_number" placeholder="请输入常用手机号...">
							</div>
						</div>
						<div class="form-group">
							<label for="password" class="col-sm-3 control-label">密码</label>
							<div class="col-sm-9">
								<input type="password" class="form-control" name="password" id="aapassword" placeholder="请输入密码...">
							</div>
						</div>
						<div class="form-group">
							<label for="confirm_password" class="col-sm-3 control-label">确认密码</label>
							<div class="col-sm-9">
								<input type="password" class="form-control" name="confirm_password" id="confirm_password" placeholder="请输入确认密码...">
							</div>
						</div>
				</div>
				<div class="modal-footer">
					<a id="a_login" class="btn btn-link" href="javascript:;">我要登录</a>
					<button type="submit" id="btn_register_submit" class="btn btn-primary">确认</button>
				</div>
			</form>
			</div>
		</div>
	</div>	
	<!--=== end ===-->
	<!-- 新增收入项模态框 begin -->
	<div class="modal fade" id="div_modal_income_add">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-head">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h5 class="text-danger"><b>==新增收入项</b></h5>
				</div>
				<div class="modal-body">
					<form action="addIncomeServlet" id="form_income_add" method="post" class="form-horizontal">
						<input type="hidden" value="${membersession.group_code}" name="group_code">
						<div class="form-group">
							<label for="income_amount" class="col-sm-3 control-label">收入金额/元	<i class="text-danger fa fa-asterisk"></i></label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="income_amount" id="income_amount" placeholder="请输入收入金额...">
							</div>
						</div>
						<div class="form-group">
							<label for="income_description" class="col-sm-3 control-label">收入说明	<i class="text-danger fa fa-asterisk"></i></label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="income_description" id="income_description" placeholder="请输入收入说明...">
							</div>
						</div>
						<div class="form-group">
							<label for="customer_name" class="col-sm-3 control-label">客户称呼	<i class="text-danger fa fa-asterisk"></i></label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="customer_name" id="customer_name" placeholder="请输入客户称呼...">
							</div>
						</div>
						<div class="form-group">
							<label for="customer_contact" class="col-sm-3 control-label">客户手机号</label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="customer_contact" id="customer_contact" placeholder="请输入客户手机号...">
							</div>
						</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default"  data-dismiss="modal">关闭</button>
					<button type="submit" class="btn btn-primary">确认</button>
				</div>
			</form>
			</div>
		</div>
	</div>	
	<!--=== end ===-->
	<!-- 新增支出项模态框 begin -->
	<div class="modal fade" id="div_modal_expend_add">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-head">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h5 class="text-danger"><b>==新增支出项</b></h5>
				</div>
				<div class="modal-body">
				<form id="form_payment_add" action="addPaymentServlet" method="post" autocomplete="off" class="form-horizontal">
					<input type="hidden" value="${membersession.group_code}" name="group_code">
						<div class="form-group">
							<label for="payment_amount" class="col-sm-3 control-label">支出金额	<i class="text-danger fa fa-asterisk"></i></label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="payment_amount" id="payment_amount" placeholder="请输入支出金额...">
							</div>
						</div>
						<div class="form-group">
							<label for="payment_purpose" class="col-sm-3 control-label">用途说明	<i class="text-danger fa fa-asterisk"></i></label>
							<div class="col-sm-9">
								<input type="text" class="form-control" name="payment_purpose" id="payment_purpose" placeholder="请输入支出说明...">
							</div>
						</div>
						<div class="form-group">
							<label for="pay_by_who" class="col-sm-3 control-label">支出人	<i class="text-danger fa fa-asterisk"></i></label>
							<div class="col-sm-9">
								<select name="pay_by_who" id="pay_by_who" class="form-control">
									<c:forEach var="member" items="${members}">
										<option value="${member.nickname}">
											${member.nickname}
										</option>
									</c:forEach>
								</select>
							</div>
						</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">关闭</button>
					<button type="submit" class="btn btn-primary">确认</button>
				</div>
			</form>
			</div>
		</div>
	</div>	
	<!--=== end ===-->
	<!-- 新增组员模态框 begin -->
	<div class="modal fade" id="div_modal_teamate_add">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-head">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h5 class="text-danger"><b>==新增组员</b></h5>
				</div>
				<div class="modal-body">
				<form id="form_add_submember" action="addMemberByLeaderServlet" method="post" autocomplete="off" class="form-horizontal">
					<input type="hidden" value="${membersession.group_code}" name="group_code">
					<input type="hidden" value="${membersession.group_intro}" name="group_intro">
					<input type="hidden" value="2" name="is_groupleader">
						<div class="form-group">
							<label for="groupmenpass" class="col-sm-4 control-label">组员隶属番号</label>
							<div class="col-sm-8">
								<p class="form-control-static">${membersession.group_code}</p>
							</div>
						</div>
						<div class="form-group">
							<label for="nickname" class="col-sm-4 control-label">组员昵称</label>
							<div class="col-sm-8">
								<input type="text" class="form-control" name="nickname" id="nickname" placeholder="请输入组员昵称...">
							</div>
						</div>
						<div class="form-group">
							<label for="phone_number" class="col-sm-4 control-label">组员手机号</label>
							<div class="col-sm-8">
								<input type="text" class="form-control" name="phone_number" id="phone_number" placeholder="请输入组员联系方式...">
							</div>
						</div>
						<div class="form-group">
							<label for="password" class="col-sm-4 control-label">组员登录口令</label>
							<div class="col-sm-8">
								<input type="password" class="form-control" name="password" id="password" placeholder="请输入组员登录口令...">
							</div>
						</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">关闭</button>
					<button type="submit" class="btn btn-primary">确认</button>
				</div>
			</form>
			</div>
		</div>
	</div>	
	<script type="text/javascript" src="resources/js/index.js"></script>
</body>
</html>
