local assets = { -- list your assets here
	Asset("ANIM", "anim/teddy.zip"), -- this is what it looks like on the ground
  Asset("ANIM", "anim/swap_teddy.zip"), -- this is what it looks like in your hand
	
	Asset("ATLAS", "images/inventoryimages/teddybear.xml"), -- this is it in your inventory
  Asset("IMAGE", "images/inventoryimages/teddybear.tex"),
}

prefabs = {} -- unneeded just here as a reminder

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner)
  owner.AnimState:OverrideSymbol("swap_object", "swap_teddy", "swap_teddy")
  owner.AnimState:Show("ARM_carry") 
  owner.AnimState:Hide("ARM_normal")
  
  inst.components.fueled:StartConsuming()        

end

local function onunequip(inst, owner)
  owner.AnimState:Hide("ARM_carry") 
  owner.AnimState:Show("ARM_normal")
  
  inst.components.fueled:StopConsuming()
end

local function fn() -- this function is called every time one of these things is created
  local inst = CreateEntity() -- create the bare bones
  local trans = inst.entity:AddTransform()
  local anim = inst.entity:AddAnimState()
  MakeInventoryPhysics(inst) -- make it go in your inventory
  
  anim:SetBank("teddy") -- this is the name of the scml file
  anim:SetBuild("teddy") -- this is the name of the character in the file
  anim:PlayAnimation("idle") -- this is the name of the animation in the character
	
  inst:AddComponent("dapperness")
  inst.components.dapperness.dapperness = TUNING.DAPPERNESS_MED
  
  inst:AddComponent("fueled")
  inst.components.fueled.fueltype = "USAGE"
  inst.components.fueled:InitializeFuelLevel(TUNING.TOPHAT_PERISHTIME)
  inst.components.fueled:SetDepletedFn(onfinished)
  
  inst:AddComponent("equippable")
  inst.components.equippable:SetOnEquip( onequip )
  inst.components.equippable:SetOnUnequip( onunequip )

  
  inst:AddComponent("inspectable") -- allow the player to inspect the item

  inst:AddComponent("inventoryitem") -- make it an inventory item
  inst.components.inventoryitem.imagename = "teddybear"
  inst.components.inventoryitem.atlasname = "images/inventoryimages/teddybear.xml" -- what it looks like in the inventory

  return inst
end

--      What kind of item is this? The function to call. This is the assets and prefabs from the top
return  Prefab("common/inventory/teddybear", fn, assets, prefabs) -- send the prefab to the game				