var scaleText;

function addUrl(url) {
  if (!url || url.length <= 4) { return; }

  url = url.replace(/\[.*?\]/g, function (str) {
    var out = "";
    str = str.toLowerCase();
    if      (str === "[timestamp]")   { out = Math.floor(new Date().getTime() / 1000); }
    else if (str === "[timestampms]") { out = new Date().getTime(); }
    else if (str === "[axel]")        { out = Math.random() * 10000000000000000; }
    return out;
  });
  var img = new Image();
  img.src = url;
  img.width = 1;
  img.height = 1;
  document.body.appendChild(img);
}

(function (win, doc) {
  var store_box_ratio;

  scaleText = win.onload = win.onresize = function () {
    var i;
    
    // Scale any text that needs to be scaled.
    var text_scale = doc.getElementsByClassName("text-scale");
    if(text_scale && text_scale.length) {
      for(i=0; i<text_scale.length; i++) {
        var elem = text_scale[i];
        var mode = elem.getAttribute("data-scale-type");
        var percent = parseFloat(elem.getAttribute("data-scale-percent"));
        elem.style.fontSize = "100%";
        elem.style.fontSize = elem[mode] * (percent / 100) + "px";
      }
    }
  };
})(window, document);