var vue1 = new Vue({
    el: '#condition',
    data: {
        types: [
            {desc: '战斗状态', name: 'combat', type: '1'},
            {desc: '非战斗状态', name: 'nocombat', type: '1'},
            {desc: '潜行', name: 'stealth', type: '2'},
            {desc: '非潜行', name: 'nostealth', type: '2'},
            {desc: '房间内', name: 'indoors', type: '3'},
            {desc: '房间外', name: 'outdoors', type: '3'},
            {desc: '可以飞行', name: 'flyable', type: '4'},
            {desc: '不可飞行', name: 'noflyable', type: '4'},
            {desc: '游泳中', name: 'swimming', type: '5'},
            {desc: '非游泳中', name: 'noswimming', type: '5'},
            {desc: 'shift按键', name: 'mod:shift', type: '6'},
            {desc: 'ctrl按键', name: 'mod:ctrl', type: '6'},
            {desc: 'alt按键', name: 'mod:alt', type: '6'},
            {desc: '无mod状态', name: 'nomod', type: '6'},
            {desc: '目标：友方', name: 'help', type: '7'},
            {desc: '目标：敌方', name: 'harm', type: '7'},
            {desc: '目标：存活', name: 'nodead', type: '8'},
            {desc: '目标：存在', name: 'exists', type: '9'},
            {desc: '以自己为目标', name: '@player', type: '10'},
            {desc: '以焦点为目标', name: '@focus', type: '10'},
            {desc: '以鼠标指向为目标', name: '@mouseover', type: '10'},
            {desc: '在鼠标位置施放', name: '@cursor', type: '10'},
            {desc: '当前目标', name: '@target', type: '10'},
            {desc: '以目标的目标为目标', name: '@targettarget', type: '10'},
            {desc: '以宠物为目标', name: '@pet', type: '10'},
            {desc: '变形形态:1', name: 'stance:1', type: '11'},
            {desc: '变形形态:2', name: 'stance:2', type: '11'},
            {desc: '变形形态:3', name: 'stance:3', type: '11'},
            {desc: '变形形态:4', name: 'stance:3', type: '11'},
            {desc: '变形形态:5', name: 'stance:3', type: '11'},

        ],
        select_item: '',
        select_array: [],
        select_string: '',
        selectTypeArray: []
    },
    methods: {
        add: function(){
            if(!this.select_item){
                alert('未选择判断条件！');
                return false;
            }
            if(!vue2.skill_name){
                alert('未选择命令！');
                return false;
            }
            var items = this.select_item.split('-');

            var l = this.selectTypeArray.length;
            for(var j=0; j<l; j++){
                if(this.selectTypeArray[j] == items[1]){
                    alert("已选择同类型条件！");
                    return false;
                }
            }
            this.selectTypeArray.push(items[1]);
            this.select_array.push(items[0]);
            vue3.skillChange();
        },
        clear: function(){
            this.select_array = [];
            this.select_item = '';
            this.selectTypeArray = [];
            this.select_string =  '';
            vue2.select_skill = '';
            vue2.skill_name = '';
            vue2.skill_type = '';
            vue3.skillName = '';
            vue3.hong_line = '';
        },
    },
    computed: {
        select_string: function(){
            var string = '';
            if(vue2.skill_name == '/castsequence'){
                string = "reset=" + this.select_array.join(",") + " ";
            }else if(vue2.skill_type == '1'){
                string = "[" + this.select_array.join(",") + "]";
            }else{
                string = '';
            }

            if(vue2.select_skill){
                return vue2.skill_name + " " + string;
            }
            return string;
        }
    }
});