﻿--[[
Name: Babble-Boss-2.0
Revision: $Rev: 14230 $
Author(s): ckknight (ckknight@gmail.com)
Website: http://ckknight.wowinterface.com/
Documentation: http://wiki.wowace.com/index.php/Babble-Boss-2.0
SVN: http://svn.wowace.com/root/trunk/BabbleLib/Babble-Boss-2.0
Description: A library to provide localizations for bosses.
Dependencies: AceLibrary, AceLocale-2.0
]]

local MAJOR_VERSION = "Babble-Boss-2.0"
local MINOR_VERSION = tonumber(string.sub("$Revision: 14230 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end

if not AceLibrary:HasInstance("AceLocale-2.0") then error(MAJOR_VERSION .. " requires AceLocale-2.0") end

local _, x = AceLibrary("AceLocale-2.0"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleBoss = AceLibrary("AceLocale-2.0"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleBoss:EnableDebugging()

BabbleBoss:RegisterTranslations("enUS", function()
	return {
		["Avalanchion"] = true,
		["The Windreaver"] = true,
		["Baron Charr"] = true,
		["Princess Tempestria"] = true,
		["Grethok the Controller"] = true,
		["Patchwerk"] = true,
		["Grobbulus"] = true,
		["Gluth"] = true,
		["Feugen"] = true,
		["Stalagg"] = true,
		["Thaddius"] = true,
		["Anub'Rekhan"] = true,
		["Grand Widow Faerlina"] = true,
		["Maexxna"] = true,
		["Instructor Razuvious"] = true,
		["Deathknight Understudy"] = true,
		["Gothik the Harvester"] = true,
		["Highlord Mograine"] = true,
		["Thane Korth'azz"] = true,
		["Lady Blaumeux"] = true,
		["Sir Zeliek"] = true,
		["The Four Horsemen"] = true,
		["Noth the Plaguebringer"] = true,
		["Heigan the Unclean"] = true,
		["Loatheb"] = true,
		["Sapphiron"] = true,
		["Kel'Thuzad"] = true,
		["Lord Victor Nefarius"] = true,
		["Nefarian"] = true,
		["Vaelastrasz the Corrupt"] = true,
		["Razorgore the Untamed"] = true,
		["Broodlord Lashlayer"] = true,
		["Chromaggus"] = true,
		["Ebonroc"] = true,
		["Firemaw"] = true,
		["Flamegor"] = true,
		["Majordomo Executus"] = true,
		["Ragnaros"] = true,
		["Baron Geddon"] = true,
		["Golemagg the Incinerator"] = true,
		["Garr"] = true,
		["Sulfuron Harbinger"] = true,
		["Shazzrah"] = true,
		["Lucifron"] = true,
		["Gehennas"] = true,
		["Magmadar"] = true,
		["Onyxia"] = true,
		["Azuregos"] = true,
		["Lord Kazzak"] = true,
		["Ysondre"] = true,
		["Emeriss"] = true,
		["Taerar"] = true,
		["Lethon"] = true,
		["High Priestess Jeklik"] = true,
		["High Priest Venoxis"] = true,
		["High Priest Thekal"] = true,
		["High Priestess Arlokk"] = true,
		["High Priestess Mar'li"] = true,
		["Jin'do the Hexxer"] = true,
		["Bloodlord Mandokir"] = true,
		["Gahz'ranka"] = true,
		["Gri'lek"] = true,
		["Hazza'rah"] = true,
		["Renataki"] = true,
		["Wushoolay"] = true,
		["Hakkar"] = true,
		["Ayamiss the Hunter"] = true,
		["Buru the Gorger"] = true,
		["General Rajaxx"] = true,
		["Lieutenant General Andorov"] = true,
		["Moam"] = true,
		["Anubisath Guardian"] = true,
		["Ossirian the Unscarred"] = true,
		["Lord Kri"] = true,
		["Princess Yauj"] = true,
		["Vem"] = true,
		["The Bug Family"] = true,
		["Eye of C'Thun"] = true,
		["C'Thun"] = true,
		["Anubisath Defender"] = true,
		["Fankriss the Unyielding"] = true,
		["Princess Huhuran"] = true,
		["Ouro"] = true,
		["Battleguard Sartura"] = true,
		["The Prophet Skeram"] = true,
		["Emperor Vek'lor"] = true,
		["Emperor Vek'nilash"] = true,
		["The Twin Emperors"] = true,
		["Viscidus"] = true,
		["Alzzin the Wildshaper"] = true,
		["Ambassador Flamelash"] = true,
		["Anger'rel"] = true,
		["Archivist Galford"] = true,
		["Atal'alarion"] = true,
		["Avatar of Hakkar"] = true,
		["Bael'Gar"] = true,
		["Balnazzar"] = true,
		["Baroness Anastari"] = true,
		["Baron Rivendare"] = true,
		["Cannon Master Willey"] = true,
		["Captain Kromcrush"] = true,
		["Celebras the Cursed"] = true,
		["Crystal Fang"] = true,
		["Darkmaster Gandling"] = true,
		["Doctor Theolen Krastinov"] = true,
		["Doom'rel"] = true,
		["Dope'rel"] = true,
		["Dreamscythe"] = true,
		["Emperor Dagran Thaurissan"] = true,
		["Fineous Darkvire"] = true,
		["Gasher"] = true,
		["General Angerforge"] = true,
		["General Drakkisath"] = true,
		["Gloom'rel"] = true,
		["Golem Lord Argelmach"] = true,
		["Goraluk Anvilcrack"] = true,
		["Guard Fengus"] = true,
		["Guard Mol'dar"] = true,
		["Guard Slip'kik"] = true,
		["Gyth"] = true,
		["Halycon"] = true,
		["Hate'rel"] = true,
		["Hazzas"] = true,
		["Hearthsinger Forresten"] = true,
		["High Interrogator Gerstahn"] = true,
		["Highlord Omokk"] = true,
		["Hukku"] = true,
		["Hurley Blackbreath"] = true,
		["Hydrospawn"] = true,
		["Illyanna Ravenoak"] = true,
		["Immol'thar"] = true,
		["Instructor Malicia"] = true,
		["Jammal'an the Prophet"] = true,
		["Jandice Barov"] = true,
		["King Gordok"] = true,
		["Kirtonos the Herald"] = true,
		["Lady Illucia Barov"] = true,
		["Landslide"] = true,
		["Lethtendris"] = true,
		["Lord Alexei Barov"] = true,
		["Lord Incendius"] = true,
		["Lord Vyletongue"] = true,
		["Lorekeeper Polkelt"] = true,
		["Loro"] = true,
		["Magister Kalendris"] = true,
		["Magistrate Barthilas"] = true,
		["Magmus"] = true,
		["Maleki the Pallid"] = true,
		["Marduk Blackpool"] = true,
		["Meshlok the Harvester"] = true,
		["Mijan"] = true,
		["Morphaz"] = true,
		["Mother Smolderweb"] = true,
		["Nerub'enkan"] = true,
		["Noxxion"] = true,
		["Ogom the Wretched"] = true,
		["Overlord Wyrmthalak"] = true,
		["Phalanx"] = true,
		["Plugger Spazzring"] = true,
		["Postmaster Malown"] = true,
		["Princess Moira Bronzebeard"] = true,
		["Princess Theradras"] = true,
		["Prince Tortheldrin"] = true,
		["Pusillin"] = true,
		["Pyroguard Emberseer"] = true,
		["Ramstein the Gorger"] = true,
		["Ras Frostwhisper"] = true,
		["Rattlegore"] = true,
		["Razorlash"] = true,
		["Warchief Rend Blackhand"] = true,
		["Ribbly Screwspigot"] = true,
		["Rotgrip"] = true,
		["Seeth'rel"] = true,
		["Shade of Eranikus"] = true,
		["Shadow Hunter Vosh'gajin"] = true,
		["Solakar Flamewreath"] = true,
		["Stomper Kreeg"] = true,
		["Tendris Warpwood"] = true,
		["The Beast"] = true,
		["The Ravenian"] = true,
		["Timmy the Cruel"] = true,
		["Tinkerer Gizlock"] = true,
		["Tsu'zee"] = true,
		["Vectus"] = true,
		["Vile'rel"] = true,
		["War Master Voone"] = true,
		["Weaver"] = true,
		["Zevrim Thornhoof"] = true,
		["Zolo"] = true,
		["Zul'Lor"] = true,
		
		-- From Mendeleev
		["Cho'Rush the Observer"] = true,
		["Lord Hel'nurath"] = true,
		["Pimgib"] = true,
		["Knot Thimblejack's Cache"] = true,
		["Cannonmaster Willey"] = true,
		["Emperor Dagran Thaurissian"] = true,
		["Archmage Arugal"] = true,
		["Archmage Arugal's Voidwalker"] = true,
		["Baron Silverlaine"] = true,
		["Commander Springvale"] = true,
		["Deathsworn Captain"] = true,
		["Fenrus the Devourer"] = true,
		["Odo the Blindwatcher"] = true,
		["Razorclaw the Butcher"] = true,
		["Wolf Master Nandos"] = true,
		["Rend Blackhand"] = true,
		["Kurinnaxx"] = true,
	}
end)

BabbleBoss:RegisterTranslations("deDE", function()
	return {
		["Avalanchion"] = "Avalanchion",
		["The Windreaver"] = "Der Windpl\195\188nderer",
		["Baron Charr"] = "Baron Charr",
		["Princess Tempestria"] = "Prinzessin Tempestria",
		["Grethok the Controller"] = "Grethok der Aufseher",
		["Patchwerk"] = "Flickwerk",
		["Grobbulus"] = "Grobbulus",
		["Gluth"] = "Gluth",
		["Thaddius"] = "Thaddius",
		["Feugen"] = "Feugen",
		["Stalagg"] = "Stalagg",
		["Anub'Rekhan"] = "Anub'Rekhan",
		["Grand Widow Faerlina"] = "Großwitwe Faerlina",
		["Maexxna"] = "Maexxna",
		["Instructor Razuvious"] = "Instrukteur Razuvious",
		["Deathknight Understudy"] = "Reservist der Todesritter",
		["Gothik the Harvester"] = "Gothik der Seelenjäger",
		["Highlord Mograine"] = "Hochlord Mograine",
		["Thane Korth'azz"] = "Thane Korth'azz",
		["Lady Blaumeux"] = "Lady Blaumeux",
		["Sir Zeliek"] = "Sire Zeliek",
		["The Four Horsemen"]= "Die Vier Reiter",
		["Noth the Plaguebringer"] = "Noth der Seuchenfürst",
		["Heigan the Unclean"] = "Heigan der Unreine",
		["Loatheb"] = "Loatheb",
		["Sapphiron"] = "Saphiron",
		["Kel'Thuzad"] = "Kel'Thuzad",
		["Lord Victor Nefarius"] = "Lord Victor Nefarius",
		["Nefarian"] = "Nefarian",
		["Vaelastrasz the Corrupt"] = "Vaelastrasz der Verdorbene",
		["Razorgore the Untamed"] = "Razorgore der Ungezähmte",
		["Broodlord Lashlayer"] = "Brutwächter Dreschbringer",
		["Chromaggus"] = "Chromaggus",
		["Ebonroc"] = "Schattenschwinge",
		["Firemaw"] = "Feuerschwinge",
		["Flamegor"] = "Flammenmaul",
		["Majordomo Executus"] = "Majordomus Exekutus",
		["Ragnaros"] = "Ragnaros",
		["Baron Geddon"] = "Baron Geddon",
		["Golemagg the Incinerator"] = "Golemagg der Verbrenner",
		["Garr"] = "Garr",
		["Sulfuron Harbinger"] = "Sulfuronherold",
		["Shazzrah"] = "Shazzrah",
		["Lucifron"] = "Lucifron",
		["Gehennas"] = "Gehennas",
		["Magmadar"] = "Magmadar",
		["Onyxia"] = "Onyxia",
		["Azuregos"] = "Azuregos",
		["Emeriss"] = "Smariss",
		["Taerar"] = "Taerar",
		["Lethon"] = "Lethon",
		["Jin'do the Hexxer"] = "Jin'do der Verhexer",
		["Bloodlord Mandokir"] = "Blutfürst Mandokir",
		["Hakkar"] = "Hakkar",
		["Lord Kazzak"] = "Lord Kazzak",
		["Ysondre"] = "Ysondre",
		["High Priestess Jeklik"] = "Hohepriesterin Jeklik",
		["High Priest Venoxis"] = "Hohepriester Venoxis",
		["High Priest Thekal"] = "Hohepriester Thekal",
		["High Priestess Arlokk"] = "Hohepriesterin Arlokk",
		["High Priestess Mar'li"] = "Hohepriesterin Mar'li",
		["Gahz'ranka"] = "Gahz'ranka",
		["Gri'lek"] = "Gri'lek",
		["Hazza'rah"] = "Hazza'rah",
		["Renataki"] = "Renataki",
		["Wushoolay"] = "Wushoolay",
		["Ayamiss the Hunter"] = "Ayamiss der Jäger",
		["Buru the Gorger"] = "Buru der Verschlinger",
		["General Rajaxx"] = "General Rajaxx",
		["Lieutenant General Andorov"] = "Generallieutenant Andorov",
		["Moam"] = "Moam",
		["Anubisath Guardian"] = "Beschützer des Anubisath",
		["Ossirian the Unscarred"] = "Ossirian der Narbenlose",
		["Lord Kri"] = "Lord Kri",
		["Princess Yauj"] = "Prinzessin Yauj",
		["Vem"] = "Vem",
		["The Bug Family"] = "Die Käferfamilie",
		["Eye of C'Thun"] = "Auge von C'Thun",
		["C'Thun"] = "C'Thun",
		["Anubisath Defender"] = "Verteidiger des Anubisath",
		["Fankriss the Unyielding"] = "Fankriss der Unnachgiebige",
		["Princess Huhuran"] = "Prinzessin Huhuran",
		["Ouro"] = "Ouro",
		["Battleguard Sartura"] = "Schlachtwache Sartura",
		["The Prophet Skeram"] = "Der Prophet Skeram",
		["Emperor Vek'lor"] = "Imperator Vek'lor",
		["Emperor Vek'nilash"] = "Imperator Vek'nilash",
		["The Twin Emperors"] = "Die Zwillings-Imperatoren",
		["Viscidus"] = "Viscidus",
		["Alzzin the Wildshaper"] = "Alzzin der Wildformer",
		["Ambassador Flamelash"] = "Botschafter Flamelash",
		["Anger'rel"] = "Anger'rel",
		["Archivist Galford"] = "Archivar Galford",
		["Atal'alarion"] = "Atal'alarion",
		["Avatar of Hakkar"] = "Avatar von Hakkar",
		["Bael'Gar"] = "Bael'Gar",
		["Balnazzar"] = "Balnazzar",
		["Baroness Anastari"] = "Baroness Anastari",
		["Baron Rivendare"] = "Baron Rivendare",
		["Captain Kromcrush"] = "Captain Kromcrush",
		["Celebras the Cursed"] = "Celebras der Verfluchte",
		["Crystal Fang"] = "Kristallfangzahn",
		["Darkmaster Gandling"] = "Dunkelmeister Gandling",
		["Doctor Theolen Krastinov"] = "Doktor Theolen Krastinov",
		["Doom'rel"] = "Un'rel",
		["Dope'rel"] = "Trott'rel",
		["Dreamscythe"] = "Traumsense",
		["Fineous Darkvire"] = "Fineous Darkvire",
		["Gasher"] = "Gasher",
		["General Angerforge"] = "General Angerforge",
		["General Drakkisath"] = "General Drakkisath",
		["Gloom'rel"] = "Dunk'rel",
		["Golem Lord Argelmach"] = "Golemlord Argelmach",
		["Goraluk Anvilcrack"] = "Goraluk Anvilcrack",
		["Gyth"] = "Gyth",
		["Halycon"] = "Halycon",
		["Hate'rel"] = "Hass'rel",
		["Hazzas"] = "Hazzas",
		["Hearthsinger Forresten"] = "Herdsinger Forresten",
		["Highlord Omokk"] = "Hochlord Omokk",
		["Hukku"] = "Hukku",
		["Hurley Blackbreath"] = "Hurley Blackbreath",
		["Hydrospawn"] = "Hydrobrut",
		["Illyanna Ravenoak"] = "Illyanna Ravenoak",
		["Immol'thar"] = "Immol'thar",
		["Instructor Malicia"] = "Instrukteurin Malicia",
		["Jammal'an the Prophet"] = "Jammal'an der Prophet",
		["Jandice Barov"] = "Jandice Barov",
		["Kirtonos the Herald"] = "Kirtonos der Herold",
		["Lady Illucia Barov"] = "Lady Illucia Barov",
		["Landslide"] = "Erdrutsch",
		["Lethtendris"] = "Lethtendris",
		["Lorekeeper Polkelt"] = "Hüter des Wissens Polkelt",
		["Loro"] = "Loro",
		["Magister Kalendris"] = "Magister Kalendris",
		["Magistrate Barthilas"] = "Magistrat Barthilas",
		["Magmus"] = "Magmus",
		["Maleki the Pallid"] = "Maleki der Leichenblasse",
		["Marduk Blackpool"] = "Marduk Blackpool",
		["Meshlok the Harvester"] = "Meshlok der Ernter",
		["Mijan"] = "Mijan",
		["Morphaz"] = "Morphaz",
		["Mother Smolderweb"] = "Mutter Glimmernetz",
		["Nerub'enkan"] = "Nerub'enkan",
		["Noxxion"] = "Noxxion",
		["Ogom the Wretched"] = "Ogom der Elende",
		["Overlord Wyrmthalak"] = "Oberanführer Wyrmthalak",
		["Phalanx"] = "Phalanx",
		["Plugger Spazzring"] = "Plugger Spazzring",
		["Postmaster Malown"] = "Postmeister Malown",
		["Princess Moira Bronzebeard"] = "Prinzessin Moira Bronzebeard",
		["Princess Theradras"] = "Prinzessin Theradras",
		["Prince Tortheldrin"] = "Prinz Tortheldrin",
		["Pusillin"] = "Pusillin",
		["Pyroguard Emberseer"] = "Feuerwache Glutseher",
		["Ramstein the Gorger"] = "Ramstein der Verschlinger",
		["Rattlegore"] = "Blutrippe",
		["Razorlash"] = "Schlingwurzler",
		["Ribbly Screwspigot"] = "Ribbly Screwspigot",
		["Rotgrip"] = "Faulschnapper",
		["Seeth'rel"] = "Wut'rel",
		["Shade of Eranikus"] = "Eranikus' Schemen",
		["Solakar Flamewreath"] = "Solakar Feuerkrone",
		["Stomper Kreeg"] = "Stampfer Kreeg",
		["Tendris Warpwood"] = "Tendris Wucherborke",
		["Timmy the Cruel"] = "Timmy der Grausame",
		["Tinkerer Gizlock"] = "Tüftler Gizlock",
		["Tsu'zee"] = "Tsu'zee",
		["Vectus"] = "Vectus",
		["Vile'rel"] = "Bös'rel",
		["Weaver"] = "Wirker",
		["Zevrim Thornhoof"] = "Zevrim Thornhoof",
		["Zolo"] = "Zolo",
		["Zul'Lor"] = "Zul'Lor",
		["Cannon Master Willey"] = "Kanonenmeister Willey",
		["Emperor Dagran Thaurissan"] = "Imperator Dagran Thaurissan",
		["Guard Fengus"] = "Wache Fengus",
		["Guard Mol'dar"] = "Wache Mol'dar",
		["Guard Slip'kik"] = "Wache Slip'kik",
		["High Interrogator Gerstahn"] = "Verhörmeisterin Gerstahn",
		["King Gordok"] = "König Gordok",
		["Lord Alexei Barov"] = "Lord Alexei Barov",
		["Lord Incendius"] = "Lord Incendius",
		["Lord Vyletongue"] = "Lord Schlangenzunge",
		["Ras Frostwhisper"] = "Ras Frostraunen",
		["Warchief Rend Blackhand"] = "Kriegshäuptling Rend Blackhand",
		["Shadow Hunter Vosh'gajin"] = "Schattenjägerin Vosh'gajin",
		["The Beast"] = "Die Bestie",
		["The Ravenian"] = "Der Ravenier",
		["War Master Voone"] = "Kriegsmeister Voone",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "Cho'Rush der Beobachter",
		["Lord Hel'nurath"] = "Lord Hel'nurath",
		["Pimgib"] = "Pimgib",
		["Knot Thimblejack's Cache"] = "Knot Thimblejack's True",
		["Cannonmaster Willey"] = "Kanonnenmeister Willey",
		["Emperor Dagran Thaurissian"] = "Imperator Dagran Thaurissian",
		["Archmage Arugal"] = "Erzmagier Arugal",
		["Archmage Arugal's Voidwalker"] = "Erzmagier Arugal's Leerwanderer",
		["Baron Silverlaine"] = "Baron Silberleine",
		["Commander Springvale"] = "Kommander Frühlingvale",
		["Deathsworn Captain"] = "Todeswachen Captain",
		["Fenrus the Devourer"] = "Fenrus der Fresser",
		["Odo the Blindwatcher"] = "Odo der Blindwächter",
		["Razorclaw the Butcher"] = "Rasiermesserklaue der Metzger",
		["Wolf Master Nandos"] = "Wolfmeister Nados",
		["Rend Blackhand"] = "Rend Blackhand",
		["Kurinnaxx"] = "Kurinnaxx",
	}
end)

BabbleBoss:RegisterTranslations("frFR", function()
	return {
		["Avalanchion"] = "Avalanchion",
		["The Windreaver"] = "Ouraganien",
		["Baron Charr"] = "Baron Charr",
		["Princess Tempestria"] = "Princesse Tempestria",
		["Grethok the Controller"] = "Grethok le Contr\195\180leur",
		["Patchwerk"] = "Le Recousu", -- CHECK
		["Grobbulus"] = "Grobbulus", -- CHECK
		["Gluth"] = "Gluth", -- CHECK
		["Thaddius"] = "Thaddius", -- CHECK
		["Feugen"] = "Feugen", -- CHECK
		["Stalagg"] = "Stalagg", -- CHECK
		["Anub'Rekhan"] = "Anub'Rekhan", -- CHECK
		["Grand Widow Faerlina"] = "Grande veuve Faerlina", -- CHECK
		["Maexxna"] = "Maexxna", -- CHECK
		["Instructor Razuvious"] = "Instructeur Razuvious", -- CHECK
		["Deathknight Understudy"] = "Doublure de chevalier de la mort", -- CHECK
		["Gothik the Harvester"] = "Gothik le Moissonneur", -- CHECK
		["Highlord Mograine"] = "Grand Seigneur Mograine", -- CHECK
		["Thane Korth'azz"] = "Thane Korth'azz", -- CHECK
		["Lady Blaumeux"] = "Dame Blaumeux", -- CHECK
		["Sir Zeliek"] = "Sir Zeliek ", -- CHECK
		["The Four Horsemen"] = "Les 4 Cavaliers", -- CHECK
		["Noth the Plaguebringer"] ="Noth le Porte-peste", -- CHECK
		["Heigan the Unclean"] = "Heigan l'Impur", -- CHECK
		["Loatheb"] = "Horreb",
		["Sapphiron"] = "Sapphiron", -- CHECK
		["Kel'Thuzad"] = "Kel'Thuzad", -- CHECK
		["Lord Victor Nefarius"] = "Seigneur Victor Nefarius", -- CHECK
		["Nefarian"] = "Nefarian",
		["Vaelastrasz the Corrupt"] = "Vaelastrasz le Corrompu",
		["Razorgore the Untamed"] = "Tranchetripe l'Indompt\195\169",
		["Broodlord Lashlayer"] = "Seigneur des couv\195\169es Lashlayer",
		["Chromaggus"] = "Chromaggus",
		["Ebonroc"] = "Roch\195\169b\195\168ne", -- CHECK
		["Firemaw"] = "Gueule-de-feu",
		["Flamegor"] = "Flamegor",
		["Majordomo Executus"] = "Chambellan Executus",
		["Ragnaros"] = "Ragnaros",
		["Baron Geddon"] = "Baron Geddon",
		["Golemagg the Incinerator"] = "Golemagg l'Incin\195\169rateur",
		["Garr"] = "Garr",
		["Sulfuron Harbinger"] = "Messager de Sulfuron",
		["Shazzrah"] = "Shazzrah",
		["Lucifron"] = "Lucifron",
		["Gehennas"] = "Gehennas",
		["Magmadar"] = "Magmadar",
		["Onyxia"] = "Onyxia",
		["Azuregos"] = "Azuregos",
		["Emeriss"] = "Emeriss",
		["Taerar"] = "Taerar",
		["Lethon"] = "L\195\169thon",
		["Jin'do the Hexxer"] = "Jin'do le Mal\195\169ficieur",
		["Bloodlord Mandokir"] = "Seigneur sanglant Mandokir",
		["Hakkar"] = "Hakkar",
		["Lord Kazzak"] = "Seigneur Kazzak",
		["Ysondre"] = "Ysondre",
		["High Priestess Jeklik"] = "Grande pr\195\170tresse Jeklik",
		["High Priest Venoxis"] = "Grand-pr\195\170tre Venoxis",
		["High Priest Thekal"] = "Grand pr\195\170tre Thekal",
		["High Priestess Arlokk"] = "Grande pr\195\170tresse Arlokk",
		["High Priestess Mar'li"] = "Grande pr\195\170tresse Mar'li",
		["Gahz'ranka"] = "Gahz'ranka",
		["Gri'lek"] = "Gri'lek",
		["Hazza'rah"] = "Hazza'rah",
		["Renataki"] = "Renataki",
		["Wushoolay"] = "Wushoolay",
		["Ayamiss the Hunter"] = "Ayamiss le Chasseur",
		["Buru the Gorger"] = "Buru Grandgosier",
		["General Rajaxx"] = "G\195\169n\195\169ral Rajaxx", -- CHECK
		["Lieutenant General Andorov"] = "Lieutenant-G\195\169n\195\169ral Andorov", -- CHECK
		["Moam"] = "Moam", -- CHECK
		["Anubisath Guardian"] = "Gardien Anubisath", -- CHECK
		["Ossirian the Unscarred"] = "Ossirian l'Intouch\195\169", -- CHECK
		["Lord Kri"] = "Seigneur Kri", -- CHECK
		["Princess Yauj"] = "Princesse Yauj", -- CHECK
		["Vem"] = "Vem", -- CHECK
		["The Bug Family"] = "La famille insecte", -- CHECK
		["Eye of C'Thun"] = "Oeil de C'Thun", -- CHECK
		["C'Thun"] = "C'Thun", -- CHECK
		["Anubisath Defender"] = "D\195\169fenseur Anubisath", -- CHECK
		["Fankriss the Unyielding"] = "Fankriss l'Inflexible", -- CHECK
		["Princess Huhuran"] = "Princesse Huhuran", -- CHECK
		["Ouro"] = "Ouro", -- CHECK
		["Battleguard Sartura"] = "Garde de guerre Sartura", -- CHECK
		["The Prophet Skeram"] = "Le Proph\195\168te Skeram", -- CHECK
		["Emperor Vek'lor"] = "Empereur Vek'lor", -- CHECK
		["Emperor Vek'nilash"] = "Empereur Vek'nilash", -- CHECK
		["The Twin Emperors"] = "Les Empereurs Jumeaux", -- CHECK
		["Viscidus"] = "Viscidus", -- CHECK
		["Alzzin the Wildshaper"] = "Alzzin le Modeleur",
		["Ambassador Flamelash"] = "Ambassadeur Flamelash",
		["Anger'rel"] = "Anger'rel",
		["Archivist Galford"] = "Archiviste Galford",
		["Atal'alarion"] = "Atal'alarion",
		["Avatar of Hakkar"] = "Avatar d'Hakkar",
		["Bael'Gar"] = "Bael'Gar",
		["Balnazzar"] = "Balnazzar",
		["Baroness Anastari"] = "Baronne Anastari",
		["Baron Rivendare"] = "Baron Rivendare",
		["Captain Kromcrush"] = "Capitaine Kromcrush",
		["Celebras the Cursed"] = "Celebras le Maudit",
		["Crystal Fang"] = "Croc cristallin",
		["Darkmaster Gandling"] = "Sombre Ma\195\174tre Gandling",
		["Doctor Theolen Krastinov"] = "Docteur Theolen Krastinov",
		["Doom'rel"] = "Doom'rel",
		["Dope'rel"] = "Dope'rel",
		["Dreamscythe"] = "Fauche-r\195\170ve",
		["Fineous Darkvire"] = "Fineous Darkvire",
		["Gasher"] = "Gasher",
		["General Angerforge"] = "G\195\169n\195\169ral Angerforge",
		["General Drakkisath"] = "G\195\169n\195\169ral Drakkisath",
		["Gloom'rel"] = "Gloom'rel",
		["Golem Lord Argelmach"] = "Seigneur golem Argelmach",
		["Goraluk Anvilcrack"] = "Goraluk Anvilcrack",
		["Gyth"] = "Gyth",
		["Halycon"] = "Halycon",
		["Hate'rel"] = "Hate'rel",
		["Hazzas"] = "Hazzas",
		["Hearthsinger Forresten"] = "Hearthsinger Forresten",
		["Highlord Omokk"] = "G\195\169n\195\169ralissime Omokk",
		["Hukku"] = "Hukku",
		["Hurley Blackbreath"] = "Hurley Blackbreath",
		["Hydrospawn"] = "Hydrospawn",
		["Illyanna Ravenoak"] = "Illyanna Ravenoak",
		["Immol'thar"] = "Immol'thar",
		["Instructor Malicia"] = "Instructeur Malicia",
		["Jammal'an the Prophet"] = "Jammal'an le proph\195\168te",
		["Jandice Barov"] = "Jandice Barov",
		["Kirtonos the Herald"] = "Kirtonos le H\195\169raut",
		["Lady Illucia Barov"] = "Dame Illucia Barov",
		["Landslide"] = "Glissement de terrain",
		["Lethtendris"] = "Lethtendris",
		["Lorekeeper Polkelt"] = "Gardien du savoir Polkelt",
		["Loro"] = "Loro",
		["Magister Kalendris"] = "Magist\195\168re Kalendris",
		["Magistrate Barthilas"] = "Magistrat Barthilas",
		["Magmus"] = "Magmus",
		["Maleki the Pallid"] = "Maleki le Blafard",
		["Marduk Blackpool"] = "Marduk Blackpool",
		["Meshlok the Harvester"] = "Meshlok le Collecteur",
		["Mijan"] = "Mijan",
		["Morphaz"] = "Morphaz",
		["Mother Smolderweb"] = "Matriarche Couveuse",
		["Nerub'enkan"] = "Nerub'enkan",
		["Noxxion"] = "Noxxion",
		["Ogom the Wretched"] = "Ogom le Corrompu",
		["Overlord Wyrmthalak"] = "Seigneur Wyrmthalak",
		["Phalanx"] = "Phalange",
		["Plugger Spazzring"] = "Plugger Spazzring",
		["Postmaster Malown"] = "Postier Malown",
		["Princess Moira Bronzebeard"] = "Princesse Moira Bronzebeard",
		["Princess Theradras"] = "Princesse Theradras",
		["Prince Tortheldrin"] = "Prince Tortheldrin",
		["Pusillin"] = "Pusillin",
		["Pyroguard Emberseer"] = "Pyrogarde Proph\195\168te ardent",
		["Ramstein the Gorger"] = "Ramstein Grandgosier",
		["Rattlegore"] = "Rattlegore",
		["Razorlash"] = "Razorlash",
		["Ribbly Screwspigot"] = "Ribbly Screwspigot",
		["Rotgrip"] = "Grippe-charogne",
		["Seeth'rel"] = "Seeth'rel",
		["Shade of Eranikus"] = "Ombre d'Eranikus",
		["Solakar Flamewreath"] = "Solakar Flamewreath",
		["Stomper Kreeg"] = "Kreeg le Marteleur",
		["Tendris Warpwood"] = "Tendris Crochebois",
		["Timmy the Cruel"] = "Timmy le Cruel",
		["Tinkerer Gizlock"] = "Artisan Gizlock",
		["Tsu'zee"] = "Tsu'zee",
		["Vectus"] = "Vectus",
		["Vile'rel"] = "Vile'rel",
		["Weaver"] = "Tisserand",
		["Zevrim Thornhoof"] = "Zevrim Thornhoof",
		["Zolo"] = "Zolo",
		["Zul'Lor"] = "Zul'Lor",
		["Cannon Master Willey"] = "Ma\195\174tre canonnier Willey",
		["Emperor Dagran Thaurissan"] = "Empereur Dagran Thaurissan",
		["Guard Fengus"] = "Garde Fengus",
		["Guard Mol'dar"] = "Garde Mol'dar",
		["Guard Slip'kik"] = "Garde Slip'kik",
		["High Interrogator Gerstahn"] = "Grand Interrogateur Gerstahn",
		["King Gordok"] = "Roi Gordok",
		["Lord Alexei Barov"] = "Seigneur Alexei Barov",
		["Lord Incendius"] = "Seigneur Incendius",
		["Lord Vyletongue"] = "Seigneur Vyletongue",
		["Ras Frostwhisper"] = "Ras Frostwhisper",
		["Warchief Rend Blackhand"] = "Chef de guerre Rend Blackhand",
		["Shadow Hunter Vosh'gajin"] = "Chasseur des ombres Vosh'gajin",
		["The Beast"] = "La B\195\170te",
		["The Ravenian"] = "Le Voracien",
		["War Master Voone"] = "Ma\195\174tre de guerre Voone",
		
		-- From Mendeleev
		["Cho'Rush the Observer"] = "Cho'Rush l'Observateur",
		["Lord Hel'nurath"] = "Seigneur Hel'nurath",
		["Pimgib"] = "Pimgib",
		["Knot Thimblejack's Cache"] = "Cachette de Knot Thimblejack",
		["Cannonmaster Willey"] = "Ma\195\174tre canonnier Willey",
		["Emperor Dagran Thaurissian"] = "Empereur Dagran Thaurissan",
		["Archmage Arugal"] = "Archimage Arugal",
		["Archmage Arugal's Voidwalker"] = "Marcheur du Vide d'Arugal",
		["Baron Silverlaine"] = "Baron Silverlaine",
		["Commander Springvale"] = "Commandant Springvale",
		["Deathsworn Captain"] = "Capitaine Deathsworn",
		["Fenrus the Devourer"] = "Fenrus le D\195\169voreur",
		["Odo the Blindwatcher"] = "Odo the Blindwatcher",
		["Razorclaw the Butcher"] = "Razorclaw le Boucher",
		["Wolf Master Nandos"] = " Ma\195\174tre-loup Nandos",
		["Rend Blackhand"] = "Rend Blackhand",
		["Kurinnaxx"] = "Kurinnaxx",
	
	}
end)


BabbleBoss:RegisterTranslations("zhCN", function()
	return {
		["Grethok the Controller"] = "黑翼控制者",
		["Patchwerk"] = "帕奇维克",
		["Grobbulus"] = "格罗布鲁斯",
		["Gluth"] = "格拉斯",
		["Thaddius"] = "塔迪乌斯",
		["Feugen"] = "费尔根",
		["Stalagg"] = "斯塔拉格",
		["Anub'Rekhan"] = "阿努布雷坎",
		["Grand Widow Faerlina"] = "黑女巫法琳娜",
		["Maexxna"] = "迈克斯纳",
		["Instructor Razuvious"] = "教官拉苏维奥斯",
		["Deathknight Understudy"] = "见习死亡骑士",
		["Gothik the Harvester"] = "收割者戈提克",
		["Highlord Mograine"] = "大领主莫格莱尼",
		["Thane Korth'azz"] = "库尔塔兹领主",
		["Lady Blaumeux"] = "女公爵布劳缪克丝",
		["Sir Zeliek"] = "瑟里耶克爵士",
		["The Four Horsemen"] = "四骑士",
		["Noth the Plaguebringer"] ="瘟疫使者诺斯",
		["Heigan the Unclean"] = "肮脏的希尔盖",
		["Loatheb"] = "洛欧塞布",
		["Sapphiron"] = "萨菲隆",
		["Kel'Thuzad"] = "克尔苏加德",
		["Lord Victor Nefarius"] = "维克多·奈法里奥斯",
		["Nefarian"] = "奈法利安",
		["Vaelastrasz the Corrupt"] = "堕落的瓦拉斯塔兹",
		["Razorgore the Untamed"] = "狂野的拉佐格尔",
		["Broodlord Lashlayer"] = "勒什雷尔",
		["Chromaggus"] = "克洛玛古斯",
		["Ebonroc"] = "埃博诺克",
		["Firemaw"] = "费尔默",
		["Flamegor"] = "弗莱格尔",
		["Majordomo Executus"] = "管理者埃克索图斯",
		["Ragnaros"] = "拉格纳罗斯",
		["Baron Geddon"] = "迦顿男爵",
		["Golemagg the Incinerator"] = "焚化者古雷曼格",
		["Garr"] = "加尔",
		["Sulfuron Harbinger"] = "萨弗隆先驱者",
		["Shazzrah"] = "沙斯拉尔",
		["Lucifron"] = "鲁西弗隆",
		["Gehennas"] = "基赫纳斯",
		["Magmadar"] = "玛格曼达",
		["Onyxia"] = "奥妮克希亚",
		["Azuregos"] = "艾索雷葛斯",
		["Lord Kazzak"] = "卡扎克",
		["Ysondre"] = "伊森德雷",
		["Emeriss"] = "艾莫莉丝",
		["Taerar"] = "泰拉尔",
		["Lethon"] = "莱索恩",
		["High Priestess Jeklik"] = "高阶祭司耶克里克",
		["High Priest Venoxis"] = "高阶祭司温诺希斯",
		["High Priest Thekal"] = "高阶祭司塞卡尔",
		["High Priestess Arlokk"] = "高阶祭司娅尔罗",
		["High Priestess Mar'li"] = "高阶祭司玛尔里",
		["Jin'do the Hexxer"] = "妖术师金度",
		["Bloodlord Mandokir"] = "血领主曼多基尔",
		["Gahz'ranka"] = "加兹兰卡",
		["Gri'lek"] = "格里雷克",
		["Hazza'rah"] = "哈扎拉尔",
		["Renataki"] = "雷纳塔基",
		["Wushoolay"] = "乌苏雷",
		["Hakkar"] = "哈卡",
		["Ayamiss the Hunter"] = "狩猎者阿亚米斯",
		["Buru the Gorger"] = "吞咽者布鲁",
		["General Rajaxx"] = "拉贾克斯将军",
		["Lieutenant General Andorov"] = "安多洛夫中将",
		["Moam"] = "莫阿姆",
		["Anubisath Guardian"] = "阿努比萨斯守卫者",
		["Ossirian the Unscarred"] = "无疤者奥斯里安",
		["Lord Kri"] = "克里勋爵",
		["Princess Yauj"] = "亚尔基公主",
		["Vem"] = "维姆",
		["The Bug Family"] = "虫子一家",
		["Eye of C'Thun"] = "克苏恩之眼",
		["C'Thun"] = "克苏恩",
		["Anubisath Defender"] = "阿努比萨斯防御者",
		["Fankriss the Unyielding"] = "顽强的范克瑞斯",
		["Princess Huhuran"] = "哈霍兰公主",
		["Ouro"] = "奥罗",
		["Battleguard Sartura"] = "沙尔图拉",
		["The Prophet Skeram"] = "预言者斯克拉姆",
		["Emperor Vek'lor"] = "维克洛尔大帝",
		["Emperor Vek'nilash"] = "维克尼拉斯大帝",
		["The Twin Emperors"] = "双子皇帝",
		["Viscidus"] = "维希度斯",
		["Alzzin the Wildshaper"] = "奥兹恩",
		["Ambassador Flamelash"] = "弗莱拉斯大使",
		["Anger'rel"] = "安格雷尔",
		["Archivist Galford"] = "案管理员加尔福特",
		["Atal'alarion"] = "阿塔拉利恩",
		["Avatar of Hakkar"] = "哈卡的化身",
		["Bael'Gar"] = "贝尔加",
		["Balnazzar"] = "巴纳扎尔",
		["Baroness Anastari"] = "安娜丝塔丽男爵夫人",
		["Baron Rivendare"] = "瑞文戴尔男爵",
		["Cannon Master Willey"] = "炮手威利",
		["Captain Kromcrush"] = "克罗卡斯",
		["Celebras the Cursed"] = "被诅咒的塞雷布拉斯",
		["Crystal Fang"] = "水晶之牙",
		["Darkmaster Gandling"] = "黑暗院长加丁",
		["Doctor Theolen Krastinov"] = "瑟尔林·卡斯迪诺夫教授",
		["Doom'rel"] = "杜姆雷尔",
		["Dope'rel"] = "多普雷尔",
		["Dreamscythe"] = "德姆塞卡尔",
		["Emperor Dagran Thaurissan"] = "达格兰·索瑞森大帝",
		["Fineous Darkvire"] = "弗诺斯·达克维尔",
		["Gasher"] = "加什尔",
		["General Angerforge"] = "安格弗将军",
		["General Drakkisath"] = "达基萨斯将军",
		["Gloom'rel"] = "格鲁雷尔",
		["Golem Lord Argelmach"] = "傀儡统帅阿格曼奇",
		["Goraluk Anvilcrack"] = "古拉鲁克",
		["Guard Fengus"] = "卫兵芬古斯",
		["Guard Mol'dar"] = "卫兵摩尔达",
		["Guard Slip'kik"] = "卫兵斯里基克",
		["Gyth"] = "盖斯",
		["Halycon"] = "哈雷肯",
		["Hate'rel"] = "黑特雷尔",
		["Hazzas"] = "哈扎斯",
		["Hearthsinger Forresten"] = "弗雷斯特恩",
		["High Interrogator Gerstahn"] = "审讯官格斯塔恩",
		["Highlord Omokk"] = "欧莫克大王",
		["Hukku"] = "胡库",
		["Hurley Blackbreath"] = "霍尔雷·黑须",
		["Hydrospawn"] = "海多斯博恩",
		["Illyanna Ravenoak"] = "伊琳娜·暗木",
		["Immol'thar"] = "伊莫塔尔",
		["Instructor Malicia"] = "讲师玛丽希亚",
		["Jammal'an the Prophet"] = "预言者迦玛兰",
		["Jandice Barov"] = "詹迪斯·巴罗夫",
		["King Gordok"] = "戈多克大王",
		["Kirtonos the Herald"] = "传令官基尔图诺斯",
		["Lady Illucia Barov"] = "伊露希亚·巴罗夫",
		["Landslide"] = "兰斯利德",
		["Lethtendris"] = "蕾瑟塔蒂丝",
		["Lord Alexei Barov"] = "阿雷克斯·巴罗夫",
		["Lord Incendius"] = "伊森迪奥斯",
		["Lord Vyletongue"] = "维利塔恩",
		["Lorekeeper Polkelt"] = "博学者普克尔特",
		["Loro"] = "洛若尔",
		["Magister Kalendris"] = "卡雷迪斯镇长",
		["Magistrate Barthilas"] = "巴瑟拉斯镇长",
		["Magmus"] = "玛格姆斯",
		["Maleki the Pallid"] = "苍白的玛勒基",
		["Marduk Blackpool"] = "马杜克·布莱克波尔",
		["Meshlok the Harvester"] = "收割者麦什洛克",
		["Mijan"] = "米杉",
		["Morphaz"] = "摩弗拉斯",
		["Mother Smolderweb"] = "烟网蛛后",
		["Nerub'enkan"] = "奈鲁布恩坎",
		["Noxxion"] = "诺克赛恩",
		["Ogom the Wretched"] = "可悲的奥戈姆",
		["Overlord Wyrmthalak"] = "维姆萨拉克",
		["Phalanx"] = "法拉克斯",
		["Plugger Spazzring"] = "普拉格",
		["Postmaster Malown"] = "邮差马龙",
		["Princess Moira Bronzebeard"] = "铁炉堡公主茉艾拉·铜须",
		["Princess Theradras"] = "瑟莱德丝公主",
		["Prince Tortheldrin"] = "托塞德林王子",
		["Pusillin"] = "普希林",
		["Pyroguard Emberseer"] = "烈焰卫士艾博希尔",
		["Ramstein the Gorger"] = "吞咽者拉姆斯登",
		["Ras Frostwhisper"] = "莱斯·霜语",
		["Rattlegore"] = "血骨傀儡",
		["Razorlash"] = "锐刺鞭笞者",
		["Warchief Rend Blackhand"] = "雷德·黑手",
		["Ribbly Screwspigot"] = "雷布里·斯库比格特",
		["Rotgrip"] = "洛特格里普",
		["Seeth'rel"] = "西斯雷尔",
		["Shade of Eranikus"] = "伊兰尼库斯的阴影",
		["Shadow Hunter Vosh'gajin"] = "暗影猎手沃什加斯",
		["Solakar Flamewreath"] = "索拉卡·火冠",
		["Stomper Kreeg"] = "践踏者克雷格",
		["Tendris Warpwood"] = "特迪斯·扭木",
		["The Beast"] = "比斯巨兽",
		["The Ravenian"] = "拉文尼亚",
		["Timmy the Cruel"] = "悲惨的提米",
		["Tinkerer Gizlock"] = "工匠吉兹洛克",
		["Tsu'zee"] = "苏斯",
		["Vectus"] = "维克图斯",
		["Vile'rel"] = "瓦勒雷尔",
		["War Master Voone"] = "指挥官沃恩",
		["Weaver"] = "德拉维沃尔",
		["Zevrim Thornhoof"] = "塔罗·刺蹄",
		["Zolo"] = "祖罗",
		["Zul'Lor"] = "祖罗尔",
	}
end)

BabbleBoss:RegisterTranslations("zhTW", function()
	return {
		["Avalanchion"] = "阿瓦蘭奇奧",
		["The Windreaver"] = "烈風掠奪者",
		["Baron Charr"] = "火焰男爵查爾",
		["Princess Tempestria"] = "泰比斯蒂亞公主",
		["Grethok the Controller"] = "黑翼控制者",
		["Patchwerk"] = "縫補者",
		["Grobbulus"] = "葛羅巴斯",
		["Gluth"] = "古魯斯",
		["Thaddius"] = "泰迪斯",
		["Feugen"] = "費爾根",
		["Stalagg"] = "斯塔拉格",
		["Anub'Rekhan"] = "阿努比瑞克漢",
		["Grand Widow Faerlina"] = "大寡婦費琳娜",
		["Maexxna"] = "梅克絲娜",
		["Instructor Razuvious"] = "講師拉祖維斯",
		["Deathknight Understudy"] = "死亡騎士實習者",
		["Gothik the Harvester"] = "收割者高希",
		["Highlord Mograine"] = "莫格萊尼公爵",
		["Thane Korth'azz"] = "寇斯艾茲族長",
		["Lady Blaumeux"] = "布洛莫斯爵士",
		["Sir Zeliek"] = "札里克爵士",
		["The Four Horsemen"] = "四騎士",
		["Noth the Plaguebringer"] ="瘟疫者諾斯",
		["Heigan the Unclean"] = "骯髒者海根",
		["Loatheb"] = "洛斯伯",
		["Sapphiron"] = "薩菲隆",
		["Kel'Thuzad"] = "科爾蘇加德",
		["Lord Victor Nefarius"] = "奈法利斯",
		["Nefarian"] = "奈法利安",
		["Vaelastrasz the Corrupt"] = "墮落的瓦拉斯塔茲",
		["Razorgore the Untamed"] = "狂野的拉佐格爾",
		["Broodlord Lashlayer"] = "勒西雷爾",
		["Chromaggus"] = "克洛瑪古斯",
		["Ebonroc"] = "埃博諾克",
		["Firemaw"] = "費爾默",
		["Flamegor"] = "弗萊格爾",
		["Majordomo Executus"] = "管理者埃克索圖斯",
		["Ragnaros"] = "拉格納羅斯",
		["Baron Geddon"] = "迦頓男爵",
		["Golemagg the Incinerator"] = "焚化者古雷曼格",
		["Garr"] = "加爾",
		["Sulfuron Harbinger"] = "薩弗隆先驅者",
		["Shazzrah"] = "沙斯拉爾",
		["Lucifron"] = "魯西弗隆",
		["Gehennas"] = "基赫納斯",
		["Magmadar"] = "瑪格曼達",
		["Onyxia"] = "奧妮克希亞",
		["Azuregos"] = "艾索雷葛斯",
		["Lord Kazzak"] = "卡札克",
		["Ysondre"] = "伊索德雷",
		["Emeriss"] = "艾莫莉絲",
		["Taerar"] = "泰拉爾",
		["Lethon"] = "雷索",
		["High Priestess Jeklik"] = "高階祭司耶克里克",
		["High Priest Venoxis"] = "高階祭司溫諾希斯",
		["High Priest Thekal"] = "高階祭司塞卡爾",
		["High Priestess Arlokk"] = "高階祭司婭爾羅",
		["High Priestess Mar'li"] = "高階祭司瑪爾羅",
		["Jin'do the Hexxer"] = "妖術師金度",
		["Bloodlord Mandokir"] = "血領主曼多基爾",
		["Gahz'ranka"] = "加茲蘭卡",
		["Gri'lek"] = "格里雷克",
		["Hazza'rah"] = "哈札拉爾",
		["Renataki"] = "雷納塔基",
		["Wushoolay"] = "烏蘇雷",
		["Hakkar"] = "哈卡",
		["Ayamiss the Hunter"] = "狩獵者阿亞米斯",
		["Buru the Gorger"] = "吞咽者布魯",
		["General Rajaxx"] = "拉賈克斯將軍",
		["Lieutenant General Andorov"] = "安多洛夫中將",
		["Moam"] = "莫阿姆",
		["Anubisath Guardian"] = "阿努比薩斯守衛者",
		["Ossirian the Unscarred"] = "無疤者奧斯里安",
		["Lord Kri"] = "克里勳爵",
		["Princess Yauj"] = "亞爾基公主",
		["Vem"] = "維姆",
		["The Bug Family"] = "蟲蟲家族",
		["Eye of C'Thun"] = "克蘇恩之眼",
		["C'Thun"] = "克蘇恩",
		["Anubisath Defender"] = "阿努比薩斯防禦者",
		["Fankriss the Unyielding"] = "頑強的范克里斯",
		["Princess Huhuran"] = "哈霍蘭公主",
		["Ouro"] = "奧羅",
		["Battleguard Sartura"] = "沙爾圖拉",
		["The Prophet Skeram"] = "預言者斯克拉姆",
		["Emperor Vek'lor"] = "維克洛爾大帝",
		["Emperor Vek'nilash"] = "維克尼拉斯大帝",
		["The Twin Emperors"] = "雙子皇帝",
		["Viscidus"] = "維希度斯",
		["Alzzin the Wildshaper"] = "奧茲恩",
		["Ambassador Flamelash"] = "弗萊拉斯大使",
		["Anger'rel"] = "安格雷爾",
		["Archivist Galford"] = "檔案管理員加爾福特",
		["Atal'alarion"] = "阿塔拉利恩",
		["Avatar of Hakkar"] = "哈卡的化身",
		["Bael'Gar"] = "貝爾加",
		["Balnazzar"] = "巴納札爾",
		["Baroness Anastari"] = "安娜絲塔麗男爵夫人",
		["Baron Rivendare"] = "瑞文戴爾男爵",
		["Cannon Master Willey"] = "炮手威利",
		["Captain Kromcrush"] = "克羅卡斯",
		["Celebras the Cursed"] = "被詛咒的塞雷布拉斯",
		["Crystal Fang"] = "水晶之牙",
		["Darkmaster Gandling"] = "黑暗院長加丁",
		["Doctor Theolen Krastinov"] = "瑟爾林‧卡斯迪諾夫教授",
		["Doom'rel"] = "杜姆雷爾",
		["Dope'rel"] = "多普雷爾",
		["Dreamscythe"] = "德姆塞卡爾",
		["Emperor Dagran Thaurissan"] = "達格蘭‧索瑞森大帝",
		["Fineous Darkvire"] = "弗諾斯‧達克維爾",
		["Gasher"] = "加什爾",
		["General Angerforge"] = "安格弗將軍",
		["General Drakkisath"] = "達基薩斯將軍",
		["Gloom'rel"] = "格魯雷爾",
		["Golem Lord Argelmach"] = "傀儡統帥阿格曼奇",
		["Goraluk Anvilcrack"] = "古拉魯克",
		["Guard Fengus"] = "衛兵芬古斯",
		["Guard Mol'dar"] = "衛兵摩爾達",
		["Guard Slip'kik"] = "衛兵斯里基克",
		["Gyth"] = "蓋斯",
		["Halycon"] = "哈雷肯",
		["Hate'rel"] = "黑特雷爾",
		["Hazzas"] = "哈扎斯",
		["Hearthsinger Forresten"] = "弗雷斯特恩",
		["High Interrogator Gerstahn"] = "審訊官格斯塔恩",
		["Highlord Omokk"] = "歐莫克大王",
		["Hukku"] = "胡庫",
		["Hurley Blackbreath"] = "霍爾雷‧黑鬚",
		["Hydrospawn"] = "海多斯博恩",
		["Illyanna Ravenoak"] = "伊琳娜‧暗木",
		["Immol'thar"] = "伊莫塔爾",
		["Instructor Malicia"] = "講師瑪麗希亞",
		["Jammal'an the Prophet"] = "預言者迦瑪蘭",
		["Jandice Barov"] = "詹迪斯‧巴羅夫",
		["King Gordok"] = "戈多克大王",
		["Kirtonos the Herald"] = "傳令官基爾圖諾斯",
		["Lady Illucia Barov"] = "伊露希亞‧巴羅夫",
		["Landslide"] = "蘭斯利德",
		["Lethtendris"] = "蕾瑟塔蒂絲",
		["Lord Alexei Barov"] = "阿萊克斯‧巴羅夫",
		["Lord Incendius"] = "伊森迪奥斯",
		["Lord Vyletongue"] = "維利塔恩",
		["Lorekeeper Polkelt"] = "博學者普克爾特",
		["Loro"] = "洛若爾",
		["Magister Kalendris"] = "卡雷迪斯鎮長",
		["Magistrate Barthilas"] = "巴瑟拉斯鎮長",
		["Magmus"] = "瑪格姆斯",
		["Maleki the Pallid"] = "蒼白的瑪勒基",
		["Marduk Blackpool"] = "馬杜克‧布萊克波爾",
		["Meshlok the Harvester"] = "收割者麥什洛克",
		["Mijan"] = "米杉",
		["Morphaz"] = "摩弗拉斯",
		["Mother Smolderweb"] = "煙網蛛后",
		["Nerub'enkan"] = "奈魯布恩坎",
		["Noxxion"] = "諾克賽恩",
		["Ogom the Wretched"] = "可悲的奧戈姆",
		["Overlord Wyrmthalak"] = "維姆薩拉克",
		["Phalanx"] = "法拉克斯",
		["Plugger Spazzring"] = "普拉格",
		["Postmaster Malown"] = "郵差瑪羅恩",
		["Princess Moira Bronzebeard"] = "鐵爐堡公主茉艾拉‧銅鬚 ",
		["Princess Theradras"] = "瑟萊德絲公主",
		["Prince Tortheldrin"] = "托塞德林王子",
		["Pusillin"] = "普希林",
		["Pyroguard Emberseer"] = "烈焰衛士艾博希爾",
		["Ramstein the Gorger"] = "吞咽者拉姆斯登",
		["Ras Frostwhisper"] = "萊斯‧霜語",
		["Rattlegore"] = "血骨傀儡",
		["Razorlash"] = "銳刺鞭笞者",
		["Warchief Rend Blackhand"] = "大酋長雷德‧黑手",
		["Ribbly Screwspigot"] = "雷布里‧斯庫比格特",
		["Rotgrip"] = "洛特格里普",
		["Seeth'rel"] = "西斯雷爾",
		["Shade of Eranikus"] = "伊蘭尼庫斯的陰影",
		["Shadow Hunter Vosh'gajin"] = "暗影獵手沃許加斯",
		["Solakar Flamewreath"] = "索拉卡‧火冠",
		["Stomper Kreeg"] = "踐踏者克雷格",
		["Tendris Warpwood"] = "特迪斯‧扭木",
		["The Beast"] = "比斯巨獸",
		["The Ravenian"] = "拉文尼亞",
		["Timmy the Cruel"] = "悲慘的提米",
		["Tinkerer Gizlock"] = "工匠吉茲洛克",
		["Tsu'zee"] = "蘇斯",
		["Vectus"] = "維克圖斯",
		["Vile'rel"] = "瓦勒雷爾",
		["War Master Voone"] = "指揮官沃恩",
		["Weaver"] = "德拉維沃爾",
		["Zevrim Thornhoof"] = "瑟雷姆‧刺蹄",
		["Zolo"] = "祖羅",
		["Zul'Lor"] = "祖羅爾",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "觀察者克魯什",
		["Lord Hel'nurath"] = "赫爾努拉斯",
		["Pimgib"] = "匹姆吉布",
		["Knot Thimblejack's Cache"] = "諾特‧希姆加克的箱子",
		["Cannonmaster Willey"] = "炮手威利",
		["Archmage Arugal"] = "大法師阿魯高",
		["Archmage Arugal's Voidwalker"] = "大法師阿魯高的虛空行者",
		["Baron Silverlaine"] = "席瓦萊恩男爵",
		["Commander Springvale"] = "指揮官斯普林瓦爾",
		["Deathsworn Captain"] = "Deathsworn Captain",
		["Fenrus the Devourer"] = "吞噬者芬魯斯",
		["Odo the Blindwatcher"] = "盲眼守衛奧杜",
		["Razorclaw the Butcher"] = "屠夫拉佐克勞",
		["Wolf Master Nandos"] = "狼王南杜斯",
		["Rend Blackhand"] = "大酋長雷德‧黑手",
		["Kurinnaxx"] = "庫林納克斯",
	}
end)

BabbleBoss:RegisterTranslations("koKR", function()
	return {
		["Avalanchion"] = "아발란치온", -- by turtl
		["The Windreaver"] = "칼날바람", -- by turtl
		["Baron Charr"] = "남작 차르", -- by turtl
		["Princess Tempestria"] = "공주 템페스트리아", -- by turtl
		["Grethok the Controller"] = "감시자 그레토크",
		["Patchwerk"] = "패치워크",
		["Grobbulus"] = "그라불루스",
		["Gluth"] = "글루스",
		["Feugen"] = "퓨진",
		["Stalagg"] = "스탈라그",
		["Thaddius"] = "타디우스",
		["Anub'Rekhan"] = "아눕레칸",
		["Grand Widow Faerlina"] = "귀부인 팰리나",
		["Maexxna"] = "맥스나",
		["Instructor Razuvious"] = "훈련교관 라주비어스",
		["Deathknight Understudy"] = "죽음의 기사 수습생", -- CHECK
		["Gothik the Harvester"] = "영혼의 착취자 고딕",
		["Highlord Mograine"] = "대영주 모그레인",
		["Thane Korth'azz"] = "영주 코스아즈",
		["Lady Blaumeux"] = "여군주 블라미우스",
		["Sir Zeliek"] = "젤리에크 경",
		["The Four Horsemen"] = "4인의 기병대",
		["Noth the Plaguebringer"] ="역병술사 노스",
		["Heigan the Unclean"] = "부정의 헤이건",
		["Loatheb"] = "로데브",
		["Sapphiron"] = "사피론",
		["Kel'Thuzad"] = "켈투자드",
		["Lord Victor Nefarius"] = "군주 빅터 네파리우스",
		["Nefarian"] = "네파리안",
		["Vaelastrasz the Corrupt"] = "타락한 밸라스트라즈",
		["Razorgore the Untamed"] = "폭군 서슬송곳니",
		["Broodlord Lashlayer"] = "용기대장 래쉬레이어",
		["Chromaggus"] = "크로마구스",
		["Ebonroc"] = "에본로크",
		["Firemaw"] = "화염아귀",
		["Flamegor"] = "플레임고르",
		["Majordomo Executus"] = "청지기 이그젝큐투스",
		["Ragnaros"] = "라그나로스",
		["Baron Geddon"] = "남작 게돈",
		["Golemagg the Incinerator"] = "초열의 골레마그",
		["Garr"] = "가르",
		["Sulfuron Harbinger"] = "설퍼론 사자",
		["Shazzrah"] = "샤즈라",
		["Lucifron"] = "루시프론",
		["Gehennas"] = "게헨나스",
		["Magmadar"] = "마그마다르",
		["Onyxia"] = "오닉시아",
		["Azuregos"] = "아주어고스",
		["Lord Kazzak"] = "군주 카자크",
		["Ysondre"] = "이손드레",
		["Emeriss"] = "에메리스",
		["Taerar"] = "타에라",
		["Lethon"] = "레손",
		["High Priestess Jeklik"] = "대여사제 제클릭",
		["High Priest Venoxis"] = "대사제 베녹시스",
		["High Priest Thekal"] = "대사제 데칼",
		["High Priestess Arlokk"] = "대여사제 알로크",
		["High Priestess Mar'li"] = "대여사제 말리",
		["Jin'do the Hexxer"] = "주술사 진도",
		["Bloodlord Mandokir"] = "혈군주 만도키르",
		["Gahz'ranka"] = "가즈란카",
		["Gri'lek"] = "그리렉", -- By turtl
		["Hazza'rah"] = "하자라", -- By turtl
		["Renataki"] = "레나타키", -- By turtl
		["Wushoolay"] = "우슬레이", -- By turtl
		["Hakkar"] = "학카르",
		["Ayamiss the Hunter"] = "사냥꾼 아야미스",
		["Buru the Gorger"] = "먹보 부루",
		["General Rajaxx"] = "장군 라작스",
		["Lieutenant General Andorov"] = "사령관 안도로브", -- by turtl
		["Moam"] = "모암",
		["Anubisath Guardian"] = "아누비사스 감시자",
		["Ossirian the Unscarred"] = "무적의 오시리안",
		["Lord Kri"] = "군주 크리",
		["Princess Yauj"] = "공주 야우즈",
		["Vem"] = "벰",
		["The Bug Family"] = "벌레 무리",
		["Eye of C'Thun"] = "쑨의 눈",
		["C'Thun"] = "쑨",
		["Anubisath Defender"] = "아누비사스 문지기",
		["Fankriss the Unyielding"] = "불굴의 판크리스",
		["Princess Huhuran"] = "공주 후후란",
		["Ouro"] = "아우로",
		["Battleguard Sartura"] = "전투감시병 살투라",
		["The Prophet Skeram"] = "예언자 스케람",
		["Emperor Vek'lor"] = "제왕 베클로어",
		["Emperor Vek'nilash"] = "제왕 베크닐라쉬",
		["The Twin Emperors"] = "쌍둥이 제왕",
		["Viscidus"] = "비시디우스",
		["Alzzin the Wildshaper"] = "칼날바람 알진",
		["Ambassador Flamelash"] = "사자 화염채찍",
		["Anger'rel"] = "Anger'rel",
		["Archivist Galford"] = "기록관 갈포드",
		["Atal'alarion"] = "아탈알라리온",
		["Avatar of Hakkar"] = "학카르의 화신",
		["Bael'Gar"] = "벨가르",
		["Balnazzar"] = "발나자르",
		["Baroness Anastari"] = "남작부인 아나스타리",
		["Baron Rivendare"] = "남작 리븐데어",
		["Cannon Master Willey"] = "포병대장 윌리",
		["Captain Kromcrush"] = "대장 크롬크러쉬",
		["Celebras the Cursed"] = "저주받은 셀레브라스",
		["Crystal Fang"] = "수정 맹독 거미",
		["Darkmaster Gandling"] = "암흑스승 간틀링",
		["Doctor Theolen Krastinov"] = "학자 테올린 크라스티노브",
		["Doom'rel"] = "운명의 문지기",
		["Dope'rel"] = "최면의 문지기",
		["Dreamscythe"] = "드림사이드",
		["Emperor Dagran Thaurissan"] = "제왕 다그란 타우릿산",
		["Fineous Darkvire"] = "파이너스 다크바이어",
		["Gasher"] = "게이셔",
		["General Angerforge"] = "사령관 앵거포지",
		["General Drakkisath"] = "사령관 드라키사스",
		["Gloom'rel"] = "그늘의 문지기",
		["Golem Lord Argelmach"] = "골렘군주 아젤마크",
		["Goraluk Anvilcrack"] = "고랄루크 앤빌크랙",
		["Guard Fengus"] = "경비병 펜구스",
		["Guard Mol'dar"] = "경비병 몰다르",
		["Guard Slip'kik"] = "경기병 슬립킥",
		["Gyth"] = "기스",
		["Halycon"] = "할리콘",
		["Hate'rel"] = "증오의 문지기",
		["Hazzas"] = "하자스",
		["Hearthsinger Forresten"] = "하스싱어 포레스턴",
		["High Interrogator Gerstahn"] = "대심문관 게르스탄",
		["Highlord Omokk"] = "대군주 오모크",
		["Hukku"] = "후쿠",
		["Hurley Blackbreath"] = "헐레이 블랙브레스",
		["Hydrospawn"] = "히드로스폰",
		["Illyanna Ravenoak"] = "일샨나 레이븐호크",
		["Immol'thar"] = "이몰타르",
		["Instructor Malicia"] = "조교 말리시아",
		["Jammal'an the Prophet"] = "예언자 잠말란",
		["Jandice Barov"] = "잔다이스 바로브",
		["King Gordok"] = "왕 고르독",
		["Kirtonos the Herald"] = "사자 키르토노스",
		["Lady Illucia Barov"] = "여군주 일루시아 바로브",
		["Landslide"] = "산사태",
		["Lethtendris"] = "레스텐드리스",
		["Lord Alexei Barov"] = "군주 알렉세이 바로브",
		["Lord Incendius"] = "군주 인센디우스",
		["Lord Vyletongue"] = "군주 바일텅",
		["Lorekeeper Polkelt"] = "현자 폴켈트",
		["Loro"] = "로로",
		["Magister Kalendris"] = "마법사 칼렌드리스",
		["Magistrate Barthilas"] = "집정관 바실라스",
		["Magmus"] = "마그무스",
		["Maleki the Pallid"] = "냉혈한 말레키",
		["Marduk Blackpool"] = "마르두크 블랙풀",
		["Meshlok the Harvester"] = "정원사 메슬로크",
		["Mijan"] = "마이잔",
		["Morphaz"] = "몰파즈",
		["Mother Smolderweb"] = "여왕 불그물거미",
		["Nerub'enkan"] = "네룹엔칸",
		["Noxxion"] = "녹시온",
		["Ogom the Wretched"] = "비운의 오그옴",
		["Overlord Wyrmthalak"] = "대군주 윔타라크",
		["Phalanx"] = "팔란스",
		["Plugger Spazzring"] = "플러거스파즈링",
		["Postmaster Malown"] = "우체국장 말로운",
		["Princess Moira Bronzebeard"] = "공주 모이라 브론즈비어드",
		["Princess Theradras"] = "공주 테라드라스",
		["Prince Tortheldrin"] = "왕자 토르텔드린",
		["Pusillin"] = "푸실린",
		["Pyroguard Emberseer"] = "불의 수호자 엠버시어",
		["Ramstein the Gorger"] = "먹보 람스타인",
		["Ras Frostwhisper"] = "라스 프로스트위스퍼",
		["Rattlegore"] = "들창어금니",
		["Razorlash"] = "칼날채찍",
		["Warchief Rend Blackhand"] = "대족장 랜드 블랜핸드",
		["Ribbly Screwspigot"] = "리블리 스크류스피곳",
		["Rotgrip"] = "썩은 아귀",
		["Seeth'rel"] = "불안의 문지기",
		["Shade of Eranikus"] = "에라니쿠스의 사령",
		["Shadow Hunter Vosh'gajin"] = "어둠사냥꾼 보쉬가진",
		["Solakar Flamewreath"] = "화염고리 솔라카르",
		["Stomper Kreeg"] = "천둥발 크리그",
		["Tendris Warpwood"] = "굽이나무 텐드리스",
		["The Beast"] = "괴수",
		["The Ravenian"] = "라베니안",
		["Timmy the Cruel"] = "잔혹한 티미",
		["Tinkerer Gizlock"] = "땜장이 기즐록",
		["Tsu'zee"] = "츄지",
		["Vectus"] = "벡투스",
		["Vile'rel"] = "타락의 문지기",
		["War Master Voone"] = "대장군 부네",
		["Weaver"] = "위버",
		["Zevrim Thornhoof"] = "제브림 쏜후프",
		["Zolo"] = "졸로",
		["Zul'Lor"] = "줄로",
		
		-- From Mendeleev
		["Cho'Rush the Observer"] = "정찰병 초루쉬", -- By turtl
		["Lord Hel'nurath"] = "군주 헬누라스", -- By turtl
		["Pimgib"] = "핌기브", -- By turtl
		["Knot Thimblejack's Cache"] = "노트 팀블젝의 Cache", -- check
		["Cannonmaster Willey"] = "포병대장 윌리", -- By turtl
		["Emperor Dagran Thaurissian"] = "제왕 다그란 타우릿산", -- By turtl
		["Archmage Arugal"] = "대마법사 아루갈", -- By turtl
		["Archmage Arugal's Voidwalker"] = "아루갈의 보이드워커", -- By turtl
		["Baron Silverlaine"] = "남작 실버레인", -- By turtl
		["Commander Springvale"] = "사령관 스프링베일", -- By turtl
		["Deathsworn Captain"] = "Deathsworn Captain", -- check
		["Fenrus the Devourer"] = "파멸의 펜루스", -- By turtl
		["Odo the Blindwatcher"] = "눈먼감시자 오도", -- By turtl
		["Razorclaw the Butcher"] = "Razorclaw the Butcher", -- check
		["Wolf Master Nandos"] = "늑대왕 난도스", -- By turtl
		["Rend Blackhand"] = "대족장 렌드 블랙핸드", -- By turtl
		["Kurinnaxx"] = "쿠린낙스",
	}
end)

BabbleBoss:Debug()
BabbleBoss:SetStrictness(true)

AceLibrary:Register(BabbleBoss, MAJOR_VERSION, MINOR_VERSION)
BabbleBoss = nil
