
-------------------------------------------------------
-- BigFootPatch.lua
-- AndyXiao@BigFoot
-- 本文件是用来修正一些来自WoW本身Interface的问题
-------------------------------------------------------

-- 修正中文WoW中的命令/rw的缺失问题
SLASH_RAID_WARNING1 = "/rw";
SLASH_RAID_WARNING2 = "/rw";

-- 修正当目标玩家距离太远，不能弹出右键菜单的问题
function UnitCanCooperate(unit1, unit2)
	if (unit1 == "player" and UnitIsPlayer(unit2) and UnitIsFriend(unit1, unit2)) then
		return 1;
	elseif (unit2 == "player" and UnitIsPlayer(unit1) and UnitIsFriend(unit2, unit1)) then
		return 1;
	end
end

-- 修正战斗窗口频繁消失的问题
originalFloatingChatFrame_Update = FloatingChatFrame_Update;
function FloatingChatFrame_Update(...)
	if (not WorldMapFrame:IsVisible()) then
		originalFloatingChatFrame_Update(unpack(arg));
	end
end

WOWBOARD1 = "<HTML><BODY><BR/><H1 align=\"CENTER\">免费密码保护卡服务全面推出</H1><BR/><P>当您购买价值30元的实物点卡时，如果卡正面注有：“特有密码保护功能”，背面有一个8*10的涂层。恭喜您，这张实物卡除了普通充值功能，还附带|cffff0000密码保护卡|r。</P><BR/><P>密码保护卡是第九城市推出的|cffff0000免费|r帐号安全保护服务，卡上的8*10矩阵包含80个不重复的两位数，且每张卡的数字排列都是独一无二的。</P><BR/><P>使用密码保护卡登陆游戏，输入帐号密码之后，系统会|cffff0000随机询问|r您3个坐标对应的数字，准确输入后即可进入游戏。这样每次登陆游戏都需要输入不同的密码，而这一切尽在您手中小小的密码保护卡中。</P><BR/><P>同时使用密码保护卡用户的随机密码输入界面采用|cffff0000独特设置|r，斩断伸向您帐号的黑手！</P><BR/><P>要使用密码保护卡，只需在官方网站登陆您的帐号，选择|cffff0000绑定密码保护卡|r，输入您手中卡上的序列号和三位坐标对应数字即可进行绑定。如果您之前开通了安全保护锁，绑定时需要输入安全保护锁。绑定成功后可以开通使用密码保护卡登陆游戏服务！</P><BR/><P>使用密码保护卡后，您可以将此卡放在皮夹或交通卡套内，也可以通过手机拍摄，复印，随身携带。</P><BR/><P>同时您还可以通过换卡，挂失，定期换卡可以提高您的帐号安全。</P><BR/></BODY></HTML>";

WOWBOARD2 = "<HTML><BODY><BR/><P>密码保护卡是|cffff0000全免费服务|r，您只需在|cffff0000购买点卡时要求购买具有密码保护功能的实物点卡|r即可|cffff0000免费获得|r。</P><BR/><P>绝不重复的数万密码组合，随机指定的动态密码，银行级别的安全措施，独特的密码输入界面，立刻购买，绑定，开通！为您的艾泽拉斯之旅保驾护航！</P><BR/><P>请访问www.wowchina.com密保卡专题了解详情。</P><BR/><BR/><BR/><P align=\"RIGHT\">第九城市 魔兽世界运营团队</P></BODY></HTML>";

WOWBOARD3 = "<HTML><BODY><BR/><H1 align=\"CENTER\">双重密码与安全锁正式分离</H1><BR/><P>为了进一步提高用户帐号的安全性，现在开始，双重密码和安全锁已经正式分离，它们将不再共享密码。|cffff0000双重密码保护使用 PIN 码登录游戏，安全锁则使用安全锁密钥进行锁定和解锁操作。|r</P><BR/><P>我们呼吁广大玩家朋友们全面提高安全意识，充分使用现有的帐号安全保护措施。我们强烈建议您同时开启开启双重密码和安全锁功能，并分别设置不同的密码，这将大大提高您帐号的安全性。</P><BR/><P>要开启双重密码功能，您只需登录九城通行证，进入安全中心，选择“申请开通双重密码”，初始设置 PIN 码后，您就成功地开通了双重密码功能。</P><BR/><H2>|HUrl:http://www.wowchina.com/pin|h|cff00ff00[第九城市通行证安全中心地址]|r|h</H2><BR/><P>要开启帐号安全锁功能，您只需登录九城通行证，进入安全中心，点击“申请开通安全锁”，初始设置好安全锁密钥后，您就可以使用安全锁服务。</P><BR/><H3>注意：为了保证您帐号的安全，|cffff0000我们强烈建议您设置的 PIN 码不要与安全锁密钥相同|r。</H3><BR/><BR/><P align=\"RIGHT\">第九城市 魔兽世界运营团队</P></BODY></HTML>";

WOWBOARD4 = "<HTML><BODY><BR/><H1 align=\"CENTER\">双重密码全面开通</H1><BR/><P>|cffffb019双重密码|r是第九城市推出的一项旨在最大限度保护《魔兽世界》用户账号的|cffff0000安全服务|r，是PIN码继安全锁之后，提供的又一项账号安全服务。</P><BR/><P>双重密码是把设定的PIN码作为第二道密码在游戏中通过软键盘输入。软键盘的输入需要使用鼠标点击进行，而且|cffffb019数字排列完全随机|r。</P><BR/><P>开通PIN码是使用双重密码的前提，申请开通PIN码后，您只需选择开启双重密码，就能享受双重密码给您账号带来的安全保障，就是如此方便。</P><BR/><H2>|HUrl:http://passport.the9.com/login.php|h|cff00ff00[点击开通PING码]|r|h</H2><BR/><P>无论是PIN码，安全锁还是双重密码，我们|cffff0000不收取用户任何费用|r，我们仅希望您在享受游戏快乐的同时，不用再为账号安全所担心。</P><BR/><BR/><H3>注意：为了保证双重密码的安全，一旦开启双重密码功能将不能关闭。</H3></BODY></HTML>";

StaticPopupDialogs["TWINPASSWORD_URL"] = {
	text = "请使用Ctrl+C键复制下面的内容，然后粘贴到网页浏览器的地址栏。",
	button1 = TEXT(ACCEPT),
	button2 = TEXT(CANCEL),
	hasEditBox = 1,
	maxLetters = 128,
	hasWideEditBox = 1,
	OnAccept = function(renameID)
		this:GetParent():Hide();
	end,
	OnShow = function()
		getglobal(this:GetName().."WideEditBox"):SetText(StaticPopupDialogs["TWINPASSWORD_URL"].url);
		getglobal(this:GetName().."WideEditBox"):SetFocus();
		getglobal(this:GetName().."WideEditBox"):HighlightText();
		this:SetWidth(460);
	end,
	EditBoxOnEnterPressed = function()
		this:GetParent():Hide();
	end,
	EditBoxOnEscapePressed = function ()
		this:GetParent():Hide();
	end,
	timeout = 0,
	exclusive = 1,
	whileDead = 1,
	hideOnEscape = 1
};

TwinPassword = {
	OnEvent = function ()
		if (event == "VARIABLES_LOADED") then
			if (not BigFoot_Config.pinAlert) then
				BigFoot_Config.pinAlert = 1;
				BigFoot_DelayCall("BigFootReader_ShowBook", 10, "安全提示");
			end
		end
	end,
	OnLoad = function ()
		local font1 = {};
		font1.inherits = MasterFont;
		font1.path = "Fonts\\FZXHLJW.TTF";
		font1.height = 15;
		font1.color = {r = 0.8828125, g = 0.84765625, b = 0.6875};

		local font2 = {};
		font2.inherits = MasterFont;
		font2.path = "Fonts\\FZXHLJW.TTF";
		font2.height = 18;
		font2.color = {r = 1.0, g = 0.82, b = 0.09765625};

		local font3 = {};
		font3.inherits = MasterFont;
		font3.path = "Fonts\\FZXHLJW.TTF";
		font3.height = 18;
		font3.color = {r = 0.0, g = 1.0, b = 0.0};

		local font4 = {};
		font4.inherits = MasterFont;
		font4.path = "Fonts\FZLBJW.TTF";
		font4.height = 15;
		font4.color = {r = 1.0, g = 0.82, b = 0.09765625};

		local callbacks = {};
		callbacks.OnLinkClick = function(linkType, linkContent)
			-- Hide reader without sound
			BigFootReader_Hide(1);

			StaticPopupDialogs["TWINPASSWORD_URL"].url = linkContent;
			StaticPopup_Show("TWINPASSWORD_URL");
		end

		BigFootReader_RegisterBook("安全提示", "WOWBOARD", false, font1, font2, font3, font4, callbacks);
	end,
};

local frameTwinPassword = CreateFrame("Frame");
TwinPassword.OnLoad();
frameTwinPassword:RegisterEvent("VARIABLES_LOADED");
frameTwinPassword:SetScript("OnEvent",TwinPassword.OnEvent);

if (GetLocale() == "zhCN") then
	BIGFOOT_PATCH_TEXT_CONFIRM_SEND_MONEY = "确定要将 |c0000FF00%s|r 发送给 |c00FFFF00%s|r 吗？";
	BIGFOOT_PATCH_TEXT_GOLD_COIN = "金";
	BIGFOOT_PATCH_TEXT_SILVER_COIN = "银";
	BIGFOOT_PATCH_TEXT_COPPER_COIN = "铜";
elseif (GetLocale() == "zhTW") then
	BIGFOOT_PATCH_TEXT_CONFIRM_SEND_MONEY = "確定要將 |c0000FF00%s|r 發送給 |c00FFFF00%s|r 嗎？";
	BIGFOOT_PATCH_TEXT_GOLD_COIN = "金";
	BIGFOOT_PATCH_TEXT_SILVER_COIN = "銀";
	BIGFOOT_PATCH_TEXT_COPPER_COIN = "銅";
else
	BIGFOOT_PATCH_TEXT_CONFIRM_SEND_MONEY = "Are you sure you want to send |c0000FF00%s|r to |c00FFFF00%s|r ?";
	BIGFOOT_PATCH_TEXT_GOLD_COIN = "gold";
	BIGFOOT_PATCH_TEXT_SILVER_COIN = "silver";
	BIGFOOT_PATCH_TEXT_COPPER_COIN = "copper";
end

-- 当玩家发邮件的时候
StaticPopupDialogs["MFW_CONFIRM_SENDMAIL"] = {
   text = TEXT(BIGFOOT_PATCH_TEXT_CONFIRM_SEND_MONEY),
   button1 = TEXT(ACCEPT),
   button2 = TEXT(CANCEL),
   whileDead = 1,
   OnAccept = function()
      MFWData.MFW_Pre_SendMail(MFWData.Target, MFWData.Subject, MFWData.Body);
   end,
   OnCancel = function()
      SetSendMailMoney(0);
      SendMailMailButton:Enable();
   end,
   OnShow = function()
      MoneyFrame_Update(this:GetName().."MoneyFrame", MFWData.Money);
   end,
   hasMoneyFrame = 1,
   timeout = 0,
};

MFWData = {};
function MFWData.formatMoneyString(gold, silver, copper)
	local moneyString = "";
	if (gold and gold > 0) then
		moneyString = moneyString .. gold ..BIGFOOT_PATCH_TEXT_GOLD_COIN;
	end
	if (silver and silver > 0) then
		moneyString = moneyString .. silver .. BIGFOOT_PATCH_TEXT_SILVER_COIN;
	end
	if (copper and copper > 0) then
		moneyString = moneyString .. copper .. BIGFOOT_PATCH_TEXT_COPPER_COIN;
	end

	return moneyString;
end

function MFW_SendMail(Target, Subject, Body)
   MFWData.Target = Target;
   MFWData.Subject = Subject;
   MFWData.Body = Body;
   local Money = GetSendMailMoney();
   MFWData.Money = Money;
   if(Money == 0) then
      MFWData.MFW_Pre_SendMail(MFWData.Target, MFWData.Subject, MFWData.Body);
   else
      local gold = floor(Money / (COPPER_PER_GOLD));
      local silver = floor((Money - (gold * COPPER_PER_GOLD)) / COPPER_PER_SILVER);
      local copper = mod(Money, COPPER_PER_SILVER);
      StaticPopup_Show("MFW_CONFIRM_SENDMAIL", MFWData.formatMoneyString(gold, silver, copper), Target);
   end
end

MFWData.MFW_Pre_SendMail = SendMail;
SendMail = MFW_SendMail;
