tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Majordomo_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_BaronGeddon_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Magmadar_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Gehennas_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Ragnaros_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Shazzrah_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Lucifron_OnLoad");

-- Majordomo
function CT_RABoss_Majordomo_OnLoad()
	-- This adds the mod to the listing. The first parameter is the mod name, the second is the description, and the third is the initial status (nil for off, 1 for on).
	-- The fourth parameter is for the zone, which is used to sort the mods into categories in the Boss Mods menu.
	CT_RABoss_AddMod("管理者埃克索图斯", CT_RABOSS_DOMO_INFO, 1, CT_RABOSS_LOCATIONS_MOLTENCORE);
	
	-- This adds an event to the mod. The second parameter is obviously the event, and the third is the function which should be called when the event is called.
	CT_RABoss_AddEvent("管理者埃克索图斯", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Majordomo_EventHandler);
	CT_RABoss_AddEvent("管理者埃克索图斯", "CHAT_MSG_SPELL_AURA_GONE_OTHER", CT_RABoss_Majordomo_EventHandler);
	
	-- This adds a dropdown button when you right-click the mod in the boss mod listing.
	-- The second parameter is either 1) a table, where the first index is the title of the button, and the second the tooltip description, or 2) just the title as a string.
	-- The third parameter is a function or variable which is called to check if the button should be checked or not. Look up the function "CT_RABoss_ModInfo" for info on how that works. If it's a variable, it will just check that value (nil/false = unchecked, other = checked)
	-- The fourth parameter is the parameter which is sent as the second parameter to the third parameter in case it is a function, and to the fifth parameter as the second parameter too.
	-- The fifth parameter is the function called when you press the button. The parameters passed to this function is the same as the third parameter (in case that is a function), #1 being modName and #2 being the optional third parameter (below "announce").
	CT_RABoss_AddDropDownButton("管理者埃克索图斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("管理者埃克索图斯", { CT_RABOSS_DOMO_HIDE_5SEC, CT_RABOSS_DOMO_HIDE_5SEC_INFO }, "CT_RABoss_ModInfo", "priorWarning", "CT_RABoss_SetInfo");
end

function CT_RABoss_Majordomo_EventHandler(event)
	if ( not CT_RABoss_Mods["管理者埃克索图斯"] or not CT_RABoss_Mods["管理者埃克索图斯"]["status"] or not CT_RABoss_Mods["管理者埃克索图斯"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" ) then
		if ( string.find(arg1, CT_RABOSS_DOMO_REFLECT_GAIN) and not CT_RABoss_Mods["管理者埃克索图斯"]["AurasUp"] ) then
			CT_RABoss_Mods["管理者埃克索图斯"]["AurasUp"] = 1;
			CT_RABoss_Announce(CT_RABOSS_DOMO_REFLECTWARN, CT_RABoss_Mods["管理者埃克索图斯"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Schedule("CT_RABoss_Majordomo_EventHandler", 25, "priorWarning");
			CT_RABoss_VisualTimer.addTimer("MajordomoReflect", 30, CT_RABOSS_DOMO_SHIELD_TIMER);
			
		elseif ( string.find(arg1, CT_RABOSS_DOMO_DMGSHIELD_GAIN) and not CT_RABoss_Mods["管理者埃克索图斯"]["AurasUp"] ) then
			CT_RABoss_Mods["管理者埃克索图斯"]["AurasUp"] = 2;
			CT_RABoss_Announce(CT_RABOSS_DOMO_DMGSHIELDWARN, CT_RABoss_Mods["管理者埃克索图斯"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Schedule("CT_RABoss_Majordomo_EventHandler", 25, "priorWarning");
			CT_RABoss_VisualTimer.addTimer("MajordomoReflect", 30, CT_RABOSS_DOMO_SHIELD_TIMER);
		end
		
	elseif ( event == "CHAT_MSG_SPELL_AURA_GONE_OTHER" and CT_RABoss_Mods["管理者埃克索图斯"]["AurasUp"] ) then
		if ( string.find(arg1, CT_RABOSS_DOMO_REFLECT_FADE) or string.find(arg1, CT_RABOSS_DOMO_DMGSHIELD_FADE) )  then
			CT_RABoss_Announce("*** " .. CT_RABOSS_DOMO_SHIELDS[CT_RABoss_Mods["管理者埃克索图斯"]["AurasUp"]] .. CT_RABOSS_DOMO_SHIELD_DOWN, CT_RABoss_Mods["管理者埃克索图斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Mods["管理者埃克索图斯"]["AurasUp"] = nil;
		end
		
	elseif ( event == "priorWarning" and not CT_RABoss_Mods["管理者埃克索图斯"]["priorWarning"] ) then
		CT_RABoss_Announce(CT_RABOSS_DOMO_5SECWARN, CT_RABoss_Mods["管理者埃克索图斯"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end


-- Baron Geddon
function CT_RABoss_BaronGeddon_OnLoad()
	CT_RABoss_AddMod("迦顿男爵", CT_RABOSS_BARON_INFO, 1, CT_RABOSS_LOCATIONS_MOLTENCORE);

	CT_RABoss_AddEvent("迦顿男爵", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_BaronGeddon_EventHandler);
	CT_RABoss_AddEvent("迦顿男爵", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_BaronGeddon_EventHandler);
	CT_RABoss_AddEvent("迦顿男爵", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_BaronGeddon_EventHandler);
	CT_RABoss_AddEvent("迦顿男爵", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_BaronGeddon_EventHandler);
	
	CT_RABoss_AddDropDownButton("迦顿男爵", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");	
	CT_RABoss_AddDropDownButton("迦顿男爵", { CT_RABOSS_BARON_ALERT_NEARBY, CT_RABOSS_BARON_ALERT_NEARBY_INFO }, "CT_RABoss_ModInfo", "alertNearby", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("迦顿男爵", { CT_RABOSS_BARON_TELL_TARGET, CT_RABOSS_BARON_TELL_TARGET_INFO }, "CT_RABoss_ModInfo", "sendTell", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("迦顿男爵", { CT_RABOSS_BARON_INFERNO, CT_RABOSS_BARON_INFERNO_INFO }, "CT_RABoss_ModInfo", "inferno", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("迦顿男爵", "alertNearby", 1);
end

function CT_RABoss_BaronGeddon_EventHandler(event)
	if ( not CT_RABoss_Mods["迦顿男爵"] or not CT_RABoss_Mods["迦顿男爵"]["status"] or not CT_RABoss_Mods["迦顿男爵"].enabled ) then
		return;
	end
	if ( event == "preInferno" and CT_RABoss_Mods["迦顿男爵"]["inferno"] ) then
		CT_RABoss_Mods["迦顿男爵"]["infernoTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_BARON_INFERNO_PREWARN, CT_RABoss_Mods["迦顿男爵"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" and arg1 == CT_RABOSS_BARON_INFERNO_DETECT and CT_RABoss_Mods["迦顿男爵"]["inferno"] and not CT_RABoss_Mods["迦顿男爵"]["infernoTrip"] ) then
		CT_RABoss_Mods["迦顿男爵"]["infernoTrip"] = true;
		CT_RABoss_Announce(CT_RABOSS_BARON_INFERNO_WARN, CT_RABoss_Mods["迦顿男爵"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_BaronGeddon_EventHandler", 19, "preInferno");
		CT_RABoss_VisualTimer.addTimer("GeddonInferno", 25, CT_RABOSS_BARON_INFERNO_TIMER);

	end
	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) then
		local _, _, sPlayer, sType = string.find(arg1, CT_RABOSS_BARON_AFFLICT_BOMB);
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				CT_RABoss_Announce(CT_RABOSS_BARON_BOMBWARNYOU);
				CT_RABoss_Announce(CT_RABOSS_BARON_BOMBWARNYOU);
				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["迦顿男爵"]["announce"] ) then
					CT_RA_AddMessage("MS *** " .. UnitName("player") .. CT_RABOSS_BARON_BOMBWARNRAID);
				end
				CT_RABoss_PlaySound(2);
				
			else
				if ( CT_RABoss_Mods["迦顿男爵"]["sendTell"] and CT_RA_Level >= 1 ) then
					SendChatMessage(CT_RABOSS_BARON_BOMBWARNTELL, "WHISPER", nil, sPlayer);
				end
				if ( CT_RABoss_Mods["迦顿男爵"]["alertNearby"] ) then
					CT_RABoss_Announce("*** " .. sPlayer .. CT_RABOSS_BARON_BOMBWARNRAID, CT_RABoss_Mods["迦顿男爵"]["announce"]);
					CT_RABoss_PlaySound(2);
				end
			end
		end
	end
end


-- Magmadar
function CT_RABoss_Magmadar_OnLoad()
	CT_RABoss_AddMod("玛格曼达", CT_RABOSS_MAGMADAR_INFO, 1, CT_RABOSS_LOCATIONS_MOLTENCORE);

	CT_RABoss_AddEvent("玛格曼达", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Magmadar_EventHandler);				-- Frenzy
	CT_RABoss_AddEvent("玛格曼达", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Magmadar_EventHandler);		-- Fear
	CT_RABoss_AddEvent("玛格曼达", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Magmadar_EventHandler);			-- Fear
	CT_RABoss_AddEvent("玛格曼达", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Magmadar_EventHandler);	-- Fear

	CT_RABoss_AddDropDownButton("玛格曼达", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("玛格曼达", { CT_RABOSS_MAGMADAR_FA, CT_RABOSS_MAGMADAR_FA_INFO }, "CT_RABoss_ModInfo", "frenzyAlert", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("玛格曼达", { CT_RABOSS_MAGMADAR_FEAR, CT_RABOSS_MAGMADAR_FEAR_INFO }, "CT_RABoss_ModInfo", "AEFear", "CT_RABoss_SetInfo");
end

function CT_RABoss_Magmadar_EventHandler(event)
	if ( not CT_RABoss_Mods["玛格曼达"] or not CT_RABoss_Mods["玛格曼达"]["status"] or not CT_RABoss_Mods["玛格曼达"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_MONSTER_EMOTE" and string.find(arg1, CT_RABOSS_MAGMADAR_FRENZY) and CT_RABoss_Mods["玛格曼达"]["frenzyAlert"] ) then
		CT_RABoss_Announce(CT_RABOSS_MAGMADAR_TRANQSHOT, CT_RABoss_Mods["玛格曼达"]["announce"]);
		CT_RABoss_PlaySound(2);
		
	elseif ( event == "preFearWarning" ) then
		CT_RABoss_Mods["玛格曼达"]["FearTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_MAGMADAR_5SECWARN, CT_RABoss_Mods["玛格曼达"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( string.find(arg1, CT_RABOSS_MAGMADAR_PANIC) and not CT_RABoss_Mods["玛格曼达"]["FearTrip"] and CT_RABoss_Mods["玛格曼达"]["AEFear"] ) then
		CT_RABoss_Mods["玛格曼达"]["FearTrip"] = true;
		CT_RABoss_Announce(CT_RABOSS_MAGMADAR_30SECWARN, CT_RABoss_Mods["玛格曼达"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Magmadar_EventHandler", 25, "preFearWarning");
		CT_RABoss_VisualTimer.addTimer("MagmadarFear", 30, CT_RABOSS_MAGMADAR_FEAR_TIMER);
	end
end


-- Gehennas
function CT_RABoss_Gehennas_OnLoad()
	CT_RABoss_AddMod("基赫纳斯", CT_RABOSS_GEHENNAS_INFO, 1, CT_RABOSS_LOCATIONS_MOLTENCORE);

	CT_RABoss_AddEvent("基赫纳斯", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Gehennas_EventHandler);
	CT_RABoss_AddEvent("基赫纳斯", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Gehennas_EventHandler);
	CT_RABoss_AddEvent("基赫纳斯", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Gehennas_EventHandler);

	CT_RABoss_AddDropDownButton("基赫纳斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_Gehennas_EventHandler(event)
	if ( not CT_RABoss_Mods["基赫纳斯"] or not CT_RABoss_Mods["基赫纳斯"]["status"] or not CT_RABoss_Mods["基赫纳斯"].enabled ) then
		return;
	end
	if ( event == "preCurseWarning" ) then
		CT_RABoss_Mods["基赫纳斯"]["CurseTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_GEHENNAS_5SECWARN, CT_RABoss_Mods["基赫纳斯"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( (string.find(arg1, CT_RABOSS_GEHENNAS_CURSE)) and not CT_RABoss_Mods["基赫纳斯"]["CurseTrip"] ) then
		CT_RABoss_Mods["基赫纳斯"]["CurseTrip"] = true;
		CT_RABoss_Announce(CT_RABOSS_GEHENNAS_30SECWARN, CT_RABoss_Mods["基赫纳斯"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Gehennas_EventHandler", 25, "preCurseWarning");
		CT_RABoss_VisualTimer.addTimer("GehennasCurse", 30, CT_RABOSS_GEHENNAS_CURSE_TIMER);
	end
end


-- Ragnaros
function CT_RABoss_Ragnaros_OnLoad()
	CT_RABoss_AddMod("拉格纳罗斯", CT_RABOSS_RAGNAROS_INFO, 1, CT_RABOSS_LOCATIONS_MOLTENCORE);

	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Ragnaros_EventHandler);

	-- For detection of non-first attempts and if all sons die before 15 second warning
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_MISSES", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_COMBAT_CREATURE_VS_SELF_MISSES", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_COMBAT_PARTY_HITS", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_COMBAT_PARTY_MISSES", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_COMBAT_SELF_HITS", CT_RABoss_Ragnaros_EventHandler);
	CT_RABoss_AddEvent("拉格纳罗斯", "CHAT_MSG_COMBAT_SELF_MISSES", CT_RABoss_Ragnaros_EventHandler);

	CT_RABoss_AddDropDownButton("拉格纳罗斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("拉格纳罗斯", "WaitStart", 0);

	CT_RA_RegisterSlashCmd("/ragstart", CT_RABOSS_CMD_RAGSTART, 30, "RAGSTART", function()
		CT_RABoss_UnSchedule("CT_RABoss_Ragnaros_EventHandler");
		CT_RABoss_SetVar("拉格纳罗斯", "WaitStart", 1);
	end, "/ragstart");
end

function CT_RABoss_Ragnaros_EventHandler(event)
	if ( not CT_RABoss_Mods["拉格纳罗斯"] or not CT_RABoss_Mods["拉格纳罗斯"]["status"] or not CT_RABoss_Mods["拉格纳罗斯"].enabled ) then
		return;
	end
	-- Rag Emerge
	if ( event == "RagUp" or ( (event == "CHAT_MSG_MONSTER_YELL") and (string.find(arg1, CT_RABOSS_RAGNAROS_START)) ) ) then
		CT_RABoss_SetVar("拉格纳罗斯", "WaitStart", 0);
		CT_RABoss_Announce(CT_RABOSS_RAGNAROS_EMERGE, CT_RABoss_Mods["拉格纳罗斯"]["announce"]);
		CT_RABoss_PlaySound(1);
		CT_RABoss_UnSchedule("CT_RABoss_Ragnaros_EventHandler");  -- Remove outstanding RagUpWarn if all sons die before 15 second warning
		CT_RABoss_Schedule("CT_RABoss_Ragnaros_EventHandler", 120, "RagWarn1");
		CT_RABoss_Schedule("CT_RABoss_Ragnaros_EventHandler", 160, "RagWarn2");
		CT_RABoss_VisualTimer.addTimer("RagnarosSons", 180, CT_RABOSS_RAGNAROS_SONS_TIMER);
	
	elseif ( CT_RABoss_Mods["拉格纳罗斯"]["WaitStart"] == 1 and string.find(arg1, "拉格纳罗斯") and UnitName("target") == "拉格纳罗斯" and ( (event == "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS") or (event == "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_MISSES") or (event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS") or (event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_MISSES") or (event == "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE") or (event == "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE") or (event == "CHAT_MSG_COMBAT_PARTY_HITS") or (event == "CHAT_MSG_COMBAT_PARTY_MISSES") or (event == "CHAT_MSG_COMBAT_SELF_HITS") or (event == "CHAT_MSG_COMBAT_SELF_MISSES") ) ) then
		CT_RABoss_SetVar("拉格纳罗斯", "WaitStart", 0);
		CT_RABoss_UnSchedule("CT_RABoss_Ragnaros_EventHandler"); -- Remove outstanding RagUpWarn if all sons die before 15 second warning
		CT_RABoss_UnSchedule("CT_RABoss_Ragnaros_EventHandler"); -- Remove outstanding RagUp if all sons die before 15 second warning
		CT_RABoss_Announce(CT_RABOSS_RAGNAROS_EMERGE, CT_RABoss_Mods["拉格纳罗斯"]["announce"]);
		CT_RABoss_PlaySound(1);
		CT_RABoss_Schedule("CT_RABoss_Ragnaros_EventHandler", 120, "RagWarn1");
		CT_RABoss_Schedule("CT_RABoss_Ragnaros_EventHandler", 160, "RagWarn2");
		CT_RABoss_VisualTimer.removeTimer("RagnarosUp");
		CT_RABoss_VisualTimer.addTimer("RagnarosSons", 180, CT_RABOSS_RAGNAROS_SONS_TIMER);

	elseif ( event == "RagWarn1" ) then
		CT_RABoss_Announce(CT_RABOSS_RAGNAROS_60SECSSONS, CT_RABoss_Mods["拉格纳罗斯"]["announce"]);
		CT_RABoss_PlaySound(1);

	elseif ( event == "RagWarn2" ) then
		CT_RABoss_Announce(CT_RABOSS_RAGNAROS_20SECSSONS, CT_RABoss_Mods["拉格纳罗斯"]["announce"]);
		CT_RABoss_PlaySound(1);

	-- WOR Warning
	elseif ( event == "preRagKB" ) then
		CT_RABoss_Announce(CT_RABOSS_RAGNAROS_5SECSKNOCKB, CT_RABoss_Mods["拉格纳罗斯"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	-- WOR
	elseif ( (event == "CHAT_MSG_MONSTER_YELL") and (string.find(arg1, CT_RABOSS_RAGNAROS_KNOCKBACK)) ) then
		CT_RABoss_Announce(CT_RABOSS_RAGNAROS_KNOCKB, CT_RABoss_Mods["拉格纳罗斯"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Ragnaros_EventHandler", 23, "preRagKB");
		CT_RABoss_VisualTimer.addTimer("RagnarosKnockback", 28, CT_RABOSS_RAGNAROS_KNOCKBACK_TIMER);

	-- Rag Submerge
	elseif ( (event == "CHAT_MSG_MONSTER_YELL") and (string.find(arg1, CT_RABOSS_RAGNAROS_SONS)) ) then
		CT_RABoss_Announce(CT_RABOSS_RAGNAROS_SUBMERGE, CT_RABoss_Mods["拉格纳罗斯"]["announce"]);
		CT_RABoss_PlaySound(1);
		CT_RABoss_UnSchedule("CT_RABoss_Ragnaros_EventHandler");  -- remove outstanding WOR warning
		CT_RABoss_Schedule("CT_RABoss_Ragnaros_EventHandler", 10, "waitStart");
		CT_RABoss_Schedule("CT_RABoss_Ragnaros_EventHandler", 75, "RagUpWarn");
		CT_RABoss_Schedule("CT_RABoss_Ragnaros_EventHandler", 90, "RagUp");
		CT_RABoss_VisualTimer.addTimer("RagnarosUp", 90, CT_RABOSS_RAGNAROS_UP_TIMER);
	
	elseif ( event == "waitStart" ) then
		CT_RABoss_SetVar("拉格纳罗斯", "WaitStart", 1);
		
	elseif ( event == "RagUpWarn" ) then
		CT_RABoss_Announce(CT_RABOSS_RAGNAROS_15SECSUP, CT_RABoss_Mods["拉格纳罗斯"]["announce"]);
		CT_RABoss_PlaySound(1);
	end
end


-- Shazzrah
function CT_RABoss_Shazzrah_OnLoad()
	CT_RABoss_AddMod("沙斯拉尔", CT_RABOSS_SHAZZRAH_INFO, 1, CT_RABOSS_LOCATIONS_MOLTENCORE);

	CT_RABoss_AddEvent("沙斯拉尔", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Shazzrah_EventHandler);
	CT_RABoss_AddEvent("沙斯拉尔", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Shazzrah_EventHandler);

	CT_RABoss_AddDropDownButton("沙斯拉尔", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_Shazzrah_EventHandler(event)
	if ( not CT_RABoss_Mods["沙斯拉尔"] or not CT_RABoss_Mods["沙斯拉尔"]["status"] or not CT_RABoss_Mods["沙斯拉尔"].enabled ) then
		return;
	end
	if ( (event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" or event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE") and string.find(arg1, CT_RABOSS_SHAZZRAH_BLINK) ) then
		CT_RABoss_Announce(CT_RABOSS_SHAZZRAH_40SECSBLINK, CT_RABoss_Mods["沙斯拉尔"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Shazzrah_EventHandler", 35, "preBlink");
		CT_RABoss_VisualTimer.addTimer("ShazzrahPortal", 40, CT_RABOSS_SHAZZRAH_BLINK_TIMER);
		
	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" and string.find(arg1, CT_RABOSS_SHAZZRAH_DEADENMAGIC) ) then
		CT_RABoss_Announce(CT_RABOSS_SHAZZRAH_SELFBUFF, CT_RABoss_Mods["沙斯拉尔"]["announce"]);
		CT_RABoss_PlaySound(1);
		
	elseif ( event == "preBlink" ) then
		CT_RABoss_Announce(CT_RABOSS_SHAZZRAH_5SECSBLINK, CT_RABoss_Mods["沙斯拉尔"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end


-- Lucifron
function CT_RABoss_Lucifron_OnLoad()
	CT_RABoss_AddMod("鲁西弗隆", CT_RABOSS_LUCIFRON_INFO, 1, CT_RABOSS_LOCATIONS_MOLTENCORE);

	CT_RABoss_AddEvent("鲁西弗隆", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Lucifron_EventHandler);
	CT_RABoss_AddEvent("鲁西弗隆", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Lucifron_EventHandler);
	CT_RABoss_AddEvent("鲁西弗隆", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Lucifron_EventHandler);

	CT_RABoss_AddDropDownButton("鲁西弗隆", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("鲁西弗隆", { CT_RABOSS_LUCIFRON_DOOMMENU, CT_RABOSS_LUCIFRON_DOOMMENU_INFO }, "CT_RABoss_ModInfo", "enableDoom", "CT_RABoss_SetInfo");
end

function CT_RABoss_Lucifron_EventHandler(event)
	if ( not CT_RABoss_Mods["鲁西弗隆"] or not CT_RABoss_Mods["鲁西弗隆"]["status"] or not CT_RABoss_Mods["鲁西弗隆"].enabled ) then
		return;
	end
	if ( event == "preCurseWarning" ) then
		CT_RABoss_Mods["鲁西弗隆"]["CurseTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_LUCIFRON_5SECSCURSE, CT_RABoss_Mods["鲁西弗隆"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( event == "impendingWarning" and CT_RABoss_Mods["鲁西弗隆"]["enableDoom"] ) then
		CT_RABoss_Mods["鲁西弗隆"]["ImpendingTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_LUCIFRON_5SECSDOOM, CT_RABoss_Mods["鲁西弗隆"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( ( string.find(arg1, CT_RABOSS_LUCIFRON_CURSE) ) and not CT_RABoss_Mods["鲁西弗隆"]["CurseTrip"] ) then
		CT_RABoss_Mods["鲁西弗隆"]["CurseTrip"] = true;
		CT_RABoss_Announce(CT_RABOSS_LUCIFRON_30SECSCURSE, CT_RABoss_Mods["鲁西弗隆"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Lucifron_EventHandler", 15, "preCurseWarning");
		CT_RABoss_VisualTimer.addTimer("LucifronCurse", 20, CT_RABOSS_LUCIFRON_CURSE_TIMER);
		
	elseif ( ( string.find(arg1, CT_RABOSS_LUCIFRON_DOOM) ) and not CT_RABoss_Mods["鲁西弗隆"]["ImpendingTrip"] and CT_RABoss_Mods["鲁西弗隆"]["enableDoom"] ) then
		CT_RABoss_Mods["鲁西弗隆"]["ImpendingTrip"] = true;
		CT_RABoss_Announce(CT_RABOSS_LUCIFRON_30SECSDOOM, CT_RABoss_Mods["鲁西弗隆"]["announce"]);
		CT_RABoss_PlaySound(1);
		CT_RABoss_Schedule("CT_RABoss_Lucifron_EventHandler", 15, "impendingWarning");
		CT_RABoss_VisualTimer.addTimer("LucifronDoom", 20, CT_RABOSS_LUCIFRON_DOOM_TIMER);
	end
end